/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands;

import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.AddExtensionsCommandHandler;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.registry.ExtensionRegistry;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;

public class AddExtensions {
    public static final String NAME = "add-extensions";
    public static final String EXTENSIONS = ToolsUtils.dotJoin("quarkus", "add-extensions", "extensions");
    public static final String OUTCOME_UPDATED = ToolsUtils.dotJoin("quarkus", "add-extensions", "outcome", "updated");
    public static final String EXTENSION_MANAGER = ToolsUtils.dotJoin("quarkus", "add-extensions", "extension-manager");
    public static final String EXTENSION_REGISTRY = ToolsUtils.dotJoin("quarkus", "add-extensions", "extension-registry");
    private final QuarkusCommandInvocation invocation;
    private final AddExtensionsCommandHandler handler = new AddExtensionsCommandHandler();

    public AddExtensions(QuarkusProject quarkusProject) {
        this.invocation = new QuarkusCommandInvocation(quarkusProject);
    }

    public AddExtensions(QuarkusProject quarkusProject, MessageWriter messageWriter) {
        this.invocation = new QuarkusCommandInvocation(quarkusProject, new HashMap<String, Object>(), messageWriter);
    }

    public AddExtensions extensionManager(ExtensionManager extensionManager) {
        this.invocation.setValue(EXTENSION_MANAGER, Objects.requireNonNull(extensionManager, "extensionManager is required"));
        return this;
    }

    public AddExtensions extensionRegistry(ExtensionRegistry extensionRegistry) {
        this.invocation.setValue(EXTENSION_REGISTRY, Objects.requireNonNull(extensionRegistry, "extensionRegistry is required"));
        return this;
    }

    public AddExtensions extensions(Set<String> extensions) {
        this.invocation.setValue(EXTENSIONS, extensions);
        return this;
    }

    public QuarkusCommandOutcome execute() throws QuarkusCommandException {
        return this.handler.execute(this.invocation);
    }
}

