/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.builder;

import io.quarkus.dependencies.Extension;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.registry.builder.ImmutableArtifactCoordsTuple;
import io.quarkus.registry.catalog.spi.IndexVisitor;
import io.quarkus.registry.model.ArtifactCoords;
import io.quarkus.registry.model.ArtifactKey;
import io.quarkus.registry.model.Extension;
import io.quarkus.registry.model.ImmutableArtifactCoords;
import io.quarkus.registry.model.ImmutableArtifactKey;
import io.quarkus.registry.model.ImmutableExtensionPlatformRelease;
import io.quarkus.registry.model.ImmutableRegistry;
import io.quarkus.registry.model.ModifiableExtension;
import io.quarkus.registry.model.ModifiableExtensionRelease;
import io.quarkus.registry.model.ModifiablePlatform;
import io.quarkus.registry.model.Registry;
import io.quarkus.registry.model.Release;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.immutables.value.Value;

public class RegistryBuilder
implements IndexVisitor {
    private final Map<ArtifactKey, ModifiablePlatform> platforms = new LinkedHashMap<ArtifactKey, ModifiablePlatform>();
    private final Map<ArtifactKey, ModifiableExtension> extensions = new LinkedHashMap<ArtifactKey, ModifiableExtension>();
    private final Map<ArtifactCoordsTuple, ModifiableExtensionRelease> releases = new LinkedHashMap<ArtifactCoordsTuple, ModifiableExtensionRelease>();
    private final ImmutableRegistry.Builder registryBuilder = Registry.builder();

    @Override
    public void visitPlatform(QuarkusPlatformDescriptor platform) {
        this.registryBuilder.putCoreVersions(new ComparableVersion(platform.getQuarkusVersion()), new HashMap<String, String>());
        this.registryBuilder.addAllCategories(platform.getCategories());
        ImmutableArtifactKey platformKey = ImmutableArtifactKey.of(platform.getBomGroupId(), platform.getBomArtifactId());
        ModifiablePlatform platformBuilder = this.platforms.computeIfAbsent(platformKey, key -> ModifiablePlatform.create().setId((ArtifactKey)key));
        platformBuilder.addReleases((Release)Release.builder().version(platform.getBomVersion()).quarkusCore(platform.getQuarkusVersion()).build());
        ImmutableArtifactCoords platformCoords = ImmutableArtifactCoords.of(platformKey, platform.getBomVersion());
        for (Extension extension : platform.getExtensions()) {
            this.visitExtension(extension, platform.getQuarkusVersion(), platformCoords);
        }
    }

    @Override
    public void visitExtension(Extension extension, String quarkusCore) {
        this.visitExtension(extension, quarkusCore, null);
    }

    private void visitExtension(Extension extension, String quarkusCore, ArtifactCoords platform) {
        if (extension.isUnlisted()) {
            return;
        }
        this.registryBuilder.putCoreVersions(new ComparableVersion(quarkusCore), new HashMap<String, String>());
        ImmutableArtifactKey extensionKey = ImmutableArtifactKey.of(extension.getGroupId(), extension.getArtifactId());
        ModifiableExtension extensionBuilder = this.extensions.computeIfAbsent(extensionKey, key -> ModifiableExtension.create().setId(extensionKey).setName(Objects.toString(extension.getName(), extension.getArtifactId())).setDescription(extension.getDescription()).setMetadata(extension.getMetadata()));
        ImmutableArtifactCoords coords = ImmutableArtifactCoords.of(extensionKey, extension.getVersion());
        ImmutableArtifactCoordsTuple key2 = ImmutableArtifactCoordsTuple.builder().coords(coords).quarkusVersion(quarkusCore).build();
        ModifiableExtensionRelease releaseBuilder = this.releases.computeIfAbsent(key2, appArtifactCoords -> ModifiableExtensionRelease.create().setRelease(Release.builder().version(appArtifactCoords.getCoords().getVersion()).quarkusCore(appArtifactCoords.getQuarkusVersion()).build()));
        if (platform != null) {
            Map<String, Object> metadata = RegistryBuilder.diff(extensionBuilder.getMetadata(), extension.getMetadata());
            ImmutableExtensionPlatformRelease platformRelease = ImmutableExtensionPlatformRelease.builder().coords(platform).metadata(metadata).build();
            releaseBuilder.addPlatforms((Extension.ExtensionPlatformRelease)platformRelease);
        }
    }

    public Registry build() {
        for (Map.Entry<ArtifactCoordsTuple, ModifiableExtensionRelease> entry : this.releases.entrySet()) {
            ArtifactCoordsTuple tuple = entry.getKey();
            ModifiableExtensionRelease extensionReleaseBuilder = entry.getValue();
            ArtifactKey key = tuple.getCoords().getId();
            ModifiableExtension extensionBuilder = this.extensions.get(key);
            extensionBuilder.addReleases((Extension.ExtensionRelease)extensionReleaseBuilder.toImmutable());
        }
        this.extensions.values().stream().map(ModifiableExtension::toImmutable).forEach(this.registryBuilder::addExtensions);
        this.platforms.values().stream().map(ModifiablePlatform::toImmutable).forEach(this.registryBuilder::addPlatforms);
        return this.registryBuilder.build();
    }

    static Map<String, Object> diff(Map<String, Object> left, Map<String, Object> right) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : right.entrySet()) {
            Object value = left.get(entry.getKey());
            if (entry.getValue().equals(value)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Value.Immutable
    public static interface ArtifactCoordsTuple {
        @Value.Parameter
        public ArtifactCoords getCoords();

        @Value.Parameter
        public String getQuarkusVersion();
    }
}

