/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.codegen;

import io.quarkus.devtools.project.codegen.ProjectGenerator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public class ProjectGeneratorRegistry {
    private static final Map<String, ProjectGenerator> generators = new ConcurrentHashMap<String, ProjectGenerator>(7);
    private static final ProjectGeneratorRegistry INSTANCE = new ProjectGeneratorRegistry();

    private ProjectGeneratorRegistry() {
        ProjectGeneratorRegistry.loadGenerators();
    }

    public static ProjectGeneratorRegistry getInstance() {
        return INSTANCE;
    }

    public static ProjectGenerator get(String name) throws NoSuchElementException {
        ProjectGenerator generator = generators.get(name);
        if (generator == null) {
            throw new NoSuchElementException("Unknown generator: " + name);
        }
        return generator;
    }

    private static void register(ProjectGenerator generator) {
        if (generator == null) {
            throw new NullPointerException("Cannot register null generator");
        }
        generators.put(generator.getName(), generator);
    }

    private static void loadGenerators() {
        ServiceLoader<ProjectGenerator> serviceLoader = ServiceLoader.load(ProjectGenerator.class);
        serviceLoader.iterator().forEachRemaining(ProjectGeneratorRegistry::register);
    }
}

