/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.buildfile;

import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.buildfile.BuildFile;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractGradleBuildFile
extends BuildFile {
    private static final String BUILD_GRADLE_PATH = "build.gradle";
    private static final String SETTINGS_GRADLE_PATH = "settings.gradle";
    private static final String GRADLE_PROPERTIES_PATH = "gradle.properties";
    private final Path rootProjectPath;
    private final AtomicReference<Model> modelReference = new AtomicReference();

    public AbstractGradleBuildFile(Path projectDirPath, QuarkusPlatformDescriptor platformDescriptor) {
        this(projectDirPath, platformDescriptor, null);
    }

    public AbstractGradleBuildFile(Path projectDirPath, QuarkusPlatformDescriptor platformDescriptor, Path rootProjectPath) {
        super(projectDirPath, platformDescriptor);
        this.rootProjectPath = rootProjectPath;
    }

    @Override
    public void writeToDisk() throws IOException {
        if (this.rootProjectPath != null) {
            Files.write(this.rootProjectPath.resolve(SETTINGS_GRADLE_PATH), this.getModel().getRootSettingsContent().getBytes(), new OpenOption[0]);
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                this.getModel().getRootPropertiesContent().store(out, "Gradle properties");
                Files.write(this.rootProjectPath.resolve(GRADLE_PROPERTIES_PATH), out.toByteArray(), new OpenOption[0]);
            }
        }
        this.writeToProjectFile(SETTINGS_GRADLE_PATH, this.getModel().getSettingsContent().getBytes());
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            this.getModel().getPropertiesContent().store(out, "Gradle properties");
            this.writeToProjectFile(GRADLE_PROPERTIES_PATH, out.toByteArray());
        }
        this.writeToProjectFile(BUILD_GRADLE_PATH, this.getModel().getBuildContent().getBytes());
    }

    @Override
    protected boolean addDependency(AppArtifactCoords coords, boolean managed) {
        return AbstractGradleBuildFile.addDependencyInModel(this.getModel(), coords, managed);
    }

    static boolean addDependencyInModel(Model model, AppArtifactCoords coords, boolean managed) {
        StringBuilder newDependency;
        boolean isBOM = "pom".equals(coords.getType());
        if (isBOM) {
            String resolvedPlatform = String.format("%s:%s", AbstractGradleBuildFile.getProperty(model, "quarkusPlatformGroupId"), AbstractGradleBuildFile.getProperty(model, "quarkusPlatformArtifactId"));
            String thisBOM = String.format("%s:%s", coords.getGroupId(), coords.getArtifactId());
            if (thisBOM.equals(resolvedPlatform)) {
                return false;
            }
            newDependency = new StringBuilder().append("    implementation enforcedPlatform(\"").append(thisBOM).append(":").append(coords.getVersion()).append("\")'");
        } else {
            newDependency = new StringBuilder().append("    implementation '").append(coords.getGroupId()).append(":").append(coords.getArtifactId());
        }
        if (!managed && coords.getVersion() != null && !coords.getVersion().isEmpty()) {
            newDependency.append(":").append(coords.getVersion());
        }
        newDependency.append("'").append(System.lineSeparator());
        String newDependencyString = newDependency.toString();
        StringBuilder buildContent = new StringBuilder(model.getBuildContent());
        boolean changed = false;
        if (buildContent.indexOf(newDependencyString) == -1) {
            changed = true;
            int indexOfDeps = buildContent.indexOf("dependencies {");
            if (indexOfDeps > -1) {
                int nextLine = buildContent.indexOf("\n", indexOfDeps) + 1;
                buildContent.insert(nextLine, newDependencyString);
            } else {
                buildContent.append("dependencies {").append(System.lineSeparator()).append(newDependencyString).append("}").append(System.lineSeparator());
            }
            model.setBuildContent(buildContent.toString());
        }
        return changed;
    }

    @Override
    protected void removeDependency(AppArtifactKey key) {
        StringBuilder newBuildContent = new StringBuilder();
        Scanner scanner = new Scanner(this.getModel().getBuildContent());
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.contains(key.getGroupId() + ":" + key.getArtifactId())) continue;
            newBuildContent.append(line).append(System.lineSeparator());
        }
        scanner.close();
        this.getModel().setBuildContent(newBuildContent.toString());
    }

    @Override
    public String getProperty(String propertyName) {
        return AbstractGradleBuildFile.getProperty(this.getModel(), propertyName);
    }

    @Override
    public BuildTool getBuildTool() {
        return BuildTool.GRADLE;
    }

    static String getProperty(Model model, String propertyName) {
        String property = model.getPropertiesContent().getProperty(propertyName);
        if (property != null || model.getRootPropertiesContent() == null) {
            return property;
        }
        return model.getRootPropertiesContent().getProperty(propertyName);
    }

    private Model getModel() {
        return this.modelReference.updateAndGet(model -> {
            if (model == null) {
                try {
                    return this.readModel();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return model;
        });
    }

    @Override
    protected void refreshData() {
        this.modelReference.set(null);
    }

    private boolean hasRootProjectFile(String fileName) {
        if (this.rootProjectPath == null) {
            return false;
        }
        Path filePath = this.rootProjectPath.resolve(fileName);
        return Files.exists(filePath, new LinkOption[0]);
    }

    private byte[] readRootProjectFile(String fileName) throws IOException {
        if (this.rootProjectPath == null) {
            throw new IllegalStateException("There is no rootProject defined in this GradleBuildFile");
        }
        Path filePath = this.rootProjectPath.resolve(fileName);
        return Files.readAllBytes(filePath);
    }

    private Model readModel() throws IOException {
        byte[] properties;
        byte[] settings;
        String settingsContent = "";
        String buildContent = "";
        Properties propertiesContent = new Properties();
        String rootSettingsContent = null;
        Properties rootPropertiesContent = null;
        if (this.hasProjectFile(SETTINGS_GRADLE_PATH)) {
            settings = this.readProjectFile(SETTINGS_GRADLE_PATH);
            settingsContent = new String(settings, StandardCharsets.UTF_8);
        }
        if (this.hasRootProjectFile(SETTINGS_GRADLE_PATH)) {
            settings = this.readRootProjectFile(SETTINGS_GRADLE_PATH);
            rootSettingsContent = new String(settings, StandardCharsets.UTF_8);
        }
        if (this.hasProjectFile(BUILD_GRADLE_PATH)) {
            byte[] build = this.readProjectFile(BUILD_GRADLE_PATH);
            buildContent = new String(build, StandardCharsets.UTF_8);
        }
        if (this.hasProjectFile(GRADLE_PROPERTIES_PATH)) {
            properties = this.readProjectFile(GRADLE_PROPERTIES_PATH);
            propertiesContent.load(new ByteArrayInputStream(properties));
        }
        if (this.hasRootProjectFile(GRADLE_PROPERTIES_PATH)) {
            properties = this.readRootProjectFile(GRADLE_PROPERTIES_PATH);
            rootPropertiesContent = new Properties();
            rootPropertiesContent.load(new ByteArrayInputStream(properties));
        }
        return new Model(settingsContent, buildContent, propertiesContent, rootSettingsContent, rootPropertiesContent);
    }

    protected String getBuildContent() {
        return this.getModel().getBuildContent();
    }

    static class Model {
        private String settingsContent;
        private String buildContent;
        private final Properties propertiesContent;
        private final String rootSettingsContent;
        private final Properties rootPropertiesContent;

        public Model(String settingsContent, String buildContent, Properties propertiesContent, String rootSettingsContent, Properties rootPropertiesContent) {
            this.settingsContent = settingsContent;
            this.buildContent = buildContent;
            this.propertiesContent = propertiesContent;
            this.rootSettingsContent = rootSettingsContent;
            this.rootPropertiesContent = rootPropertiesContent;
        }

        public String getSettingsContent() {
            return this.settingsContent;
        }

        public String getBuildContent() {
            return this.buildContent;
        }

        public Properties getPropertiesContent() {
            return this.propertiesContent;
        }

        public String getRootSettingsContent() {
            return this.rootSettingsContent;
        }

        public Properties getRootPropertiesContent() {
            return this.rootPropertiesContent;
        }

        public void setSettingsContent(String settingsContent) {
            this.settingsContent = settingsContent;
        }

        public void setBuildContent(String buildContent) {
            this.buildContent = buildContent;
        }
    }
}

