/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.devtools.commands.AddExtensions;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.project.extensions.ExtensionInstallPlan;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.platform.tools.ConsoleMessageFormats;
import io.quarkus.registry.DefaultExtensionRegistry;
import io.quarkus.registry.ExtensionRegistry;
import io.quarkus.registry.MultipleExtensionsFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

public class AddExtensionsCommandHandler
implements QuarkusCommandHandler {
    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        Set<String> extensionsQuery = invocation.getValue(AddExtensions.EXTENSIONS, Collections.emptySet());
        if (extensionsQuery.isEmpty()) {
            return (QuarkusCommandOutcome)QuarkusCommandOutcome.success().setValue(AddExtensions.OUTCOME_UPDATED, false);
        }
        ExtensionRegistry extensionRegistry = (ExtensionRegistry)invocation.getValue(AddExtensions.EXTENSION_REGISTRY);
        if (extensionRegistry == null) {
            extensionRegistry = DefaultExtensionRegistry.fromPlatform(invocation.getPlatformDescriptor());
        }
        String quarkusVersion = invocation.getPlatformDescriptor().getQuarkusVersion();
        ExtensionManager extensionManager = invocation.getValue(AddExtensions.EXTENSION_MANAGER, invocation.getQuarkusProject().getExtensionManager());
        try {
            ExtensionInstallPlan extensionInstallPlan = extensionRegistry.planInstallation(quarkusVersion, extensionsQuery);
            if (extensionInstallPlan.isNotEmpty()) {
                ExtensionManager.InstallResult result = extensionManager.install(extensionInstallPlan);
                result.getInstalled().forEach(a -> invocation.log().info(ConsoleMessageFormats.ok((String)("Extension " + a.getGroupId() + ":" + a.getArtifactId())) + " has been installed"));
                return (QuarkusCommandOutcome)new QuarkusCommandOutcome(true).setValue(AddExtensions.OUTCOME_UPDATED, result.isSourceUpdated());
            }
        }
        catch (MultipleExtensionsFoundException m) {
            StringBuilder sb = new StringBuilder();
            sb.append(ConsoleMessageFormats.nok((String)"Multiple extensions matching '")).append(m.getKeyword()).append("'");
            m.getExtensions().forEach(extension -> sb.append(System.lineSeparator()).append("     * ").append(extension.managementKey()));
            sb.append(System.lineSeparator()).append("     Be more specific e.g using the exact name or the full GAV.");
            invocation.log().info(sb.toString());
        }
        catch (IOException e) {
            throw new QuarkusCommandException("Failed to add extensions", e);
        }
        return (QuarkusCommandOutcome)new QuarkusCommandOutcome(false).setValue(AddExtensions.OUTCOME_UPDATED, false);
    }
}

