/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands;

import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.cli.commands.file.MavenBuildFile;
import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.generators.BuildTool;
import io.quarkus.generators.ProjectGeneratorRegistry;
import io.quarkus.generators.SourceType;
import io.quarkus.maven.utilities.MojoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.model.Model;

public class CreateProject {
    private ProjectWriter writer;
    private String groupId;
    private String artifactId;
    private String version = MojoUtils.getPluginVersion();
    private SourceType sourceType = SourceType.JAVA;
    private BuildFile buildFile;
    private BuildTool buildTool;
    private String className;
    private Set<String> extensions;
    private Model model;

    public CreateProject(ProjectWriter writer) {
        this.writer = writer;
    }

    public CreateProject groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public CreateProject artifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public CreateProject version(String version) {
        this.version = version;
        return this;
    }

    public CreateProject sourceType(SourceType sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public CreateProject className(String className) {
        this.className = className;
        return this;
    }

    public CreateProject extensions(Set<String> extensions) {
        this.extensions = extensions;
        return this;
    }

    public CreateProject buildFile(BuildFile buildFile) {
        this.buildFile = buildFile;
        return this;
    }

    public CreateProject buildTool(BuildTool buildTool) {
        this.buildTool = buildTool;
        return this;
    }

    public Model getModel() {
        return this.model;
    }

    public boolean doCreateProject(Map<String, Object> context) throws IOException {
        if (!this.writer.init()) {
            return false;
        }
        MojoUtils.getAllProperties().forEach((k, v) -> context.put(k.replace("-", "_"), v));
        context.put("project_groupId", this.groupId);
        context.put("project_artifactId", this.artifactId);
        context.put("project_version", this.version);
        context.put("bom_groupId", MojoUtils.getBomGroupId());
        context.put("bom_artifactId", MojoUtils.getBomArtifactId());
        context.put("bom_version", MojoUtils.getBomVersionForTemplate(this.getBuildFile().getPlatformBomVersionExpression()));
        context.put("quarkus_version", MojoUtils.getQuarkusVersion());
        context.put("source_type", (Object)this.sourceType);
        context.put("build_file", this.getBuildFile());
        if (this.extensions != null && this.extensions.stream().anyMatch(e -> e.toLowerCase().contains("spring-web"))) {
            context.put("is_spring", Boolean.TRUE);
        }
        if (this.className != null) {
            this.className = this.sourceType.stripExtensionFrom(this.className);
            int idx = this.className.lastIndexOf(46);
            if (idx >= 0) {
                String packageName = this.className.substring(0, idx);
                this.className = this.className.substring(idx + 1);
                context.put("package_name", packageName);
            }
            context.put("class_name", this.className);
        }
        ProjectGeneratorRegistry.get("basic-rest").generate(this.writer, context);
        try (BuildFile buildFile = this.getBuildFile();){
            buildFile.completeFile(this.groupId, this.artifactId, this.version);
        }
        return true;
    }

    private BuildFile getBuildFile() throws IOException {
        if (this.buildFile == null) {
            this.buildFile = this.buildTool == null ? new MavenBuildFile(this.writer) : this.buildTool.createBuildFile(this.writer);
        }
        return this.buildFile;
    }

    public static SourceType determineSourceType(Set<String> extensions) {
        Optional<SourceType> sourceType = extensions.stream().map(SourceType::parse).filter(Optional::isPresent).map(e -> e.orElse(SourceType.JAVA)).findAny();
        return sourceType.orElse(SourceType.JAVA);
    }
}

