/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runner.bootstrap;

import io.quarkus.bootstrap.BootstrapDebug;
import io.quarkus.bootstrap.app.AdditionalDependency;
import io.quarkus.bootstrap.app.ArtifactResult;
import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.AugmentResult;
import io.quarkus.bootstrap.app.ClassChangeInformation;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.classloading.ClassLoaderEventListener;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.BuildChain;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildExecutionBuilder;
import io.quarkus.builder.BuildResult;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ExtensionLoader;
import io.quarkus.deployment.QuarkusAugmentor;
import io.quarkus.deployment.builditem.ApplicationClassNameBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedFileSystemResourceHandledBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.builditem.RawCommandLineArgumentsBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.DeploymentResultBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.runner.bootstrap.StartupActionImpl;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ProfileManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.logging.Logger;

public class AugmentActionImpl
implements AugmentAction {
    private static final Logger log = Logger.getLogger(AugmentActionImpl.class);
    private static final Class[] NON_NORMAL_MODE_OUTPUTS = new Class[]{GeneratedClassBuildItem.class, GeneratedResourceBuildItem.class, ApplicationClassNameBuildItem.class, MainClassBuildItem.class, GeneratedFileSystemResourceHandledBuildItem.class, TransformedClassesBuildItem.class};
    private final QuarkusBootstrap quarkusBootstrap;
    private final CuratedApplication curatedApplication;
    private final LaunchMode launchMode;
    private final DevModeType devModeType;
    private final List<Consumer<BuildChainBuilder>> chainCustomizers;
    private final List<ClassLoaderEventListener> classLoadListeners;
    private final Map<Class<?>, Object> reloadContext = new ConcurrentHashMap();

    public AugmentActionImpl(CuratedApplication curatedApplication) {
        this(curatedApplication, Collections.emptyList(), Collections.emptyList());
    }

    @Deprecated
    public AugmentActionImpl(CuratedApplication curatedApplication, List<Consumer<BuildChainBuilder>> chainCustomizers) {
        this(curatedApplication, chainCustomizers, Collections.emptyList());
    }

    public AugmentActionImpl(CuratedApplication curatedApplication, List<Consumer<BuildChainBuilder>> chainCustomizers, List<ClassLoaderEventListener> classLoadListeners) {
        DevModeType devModeType;
        LaunchMode launchMode;
        this.quarkusBootstrap = curatedApplication.getQuarkusBootstrap();
        this.curatedApplication = curatedApplication;
        this.chainCustomizers = chainCustomizers;
        this.classLoadListeners = classLoadListeners;
        switch (this.quarkusBootstrap.getMode()) {
            case DEV: {
                launchMode = LaunchMode.DEVELOPMENT;
                devModeType = DevModeType.LOCAL;
                break;
            }
            case PROD: {
                launchMode = LaunchMode.NORMAL;
                devModeType = null;
                break;
            }
            case TEST: {
                launchMode = LaunchMode.TEST;
                devModeType = null;
                break;
            }
            case REMOTE_DEV_CLIENT: {
                launchMode = LaunchMode.NORMAL;
                devModeType = DevModeType.REMOTE_LOCAL_SIDE;
                break;
            }
            case CONTINUOUS_TEST: {
                launchMode = LaunchMode.DEVELOPMENT;
                devModeType = DevModeType.TEST_ONLY;
                break;
            }
            case REMOTE_DEV_SERVER: {
                launchMode = LaunchMode.DEVELOPMENT;
                devModeType = DevModeType.REMOTE_SERVER_SIDE;
                break;
            }
            default: {
                throw new RuntimeException("Unknown launch mode " + this.quarkusBootstrap.getMode());
            }
        }
        this.launchMode = launchMode;
        this.devModeType = devModeType;
    }

    public void performCustomBuild(String resultHandler, Object context, String ... finalOutputs) {
        QuarkusClassLoader classLoader = this.curatedApplication.createDeploymentClassLoader();
        Class[] targets = (Class[])Arrays.stream(finalOutputs).map(new Function<String, Class<? extends BuildItem>>((ClassLoader)classLoader){
            final /* synthetic */ ClassLoader val$classLoader;
            {
                this.val$classLoader = classLoader;
            }

            @Override
            public Class<? extends BuildItem> apply(String s) {
                try {
                    return Class.forName(s, false, this.val$classLoader);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }).toArray(Class[]::new);
        BuildResult result = this.runAugment(true, Collections.emptySet(), null, (ClassLoader)classLoader, targets);
        String debugSourcesDir = BootstrapDebug.DEBUG_SOURCES_DIR;
        if (debugSourcesDir != null) {
            for (GeneratedClassBuildItem i : result.consumeMulti(GeneratedClassBuildItem.class)) {
                try {
                    if (i.getSource() != null) {
                        File debugPath = new File(debugSourcesDir);
                        if (!debugPath.exists()) {
                            debugPath.mkdir();
                        }
                        File sourceFile = new File(debugPath, i.getName() + ".zig");
                        sourceFile.getParentFile().mkdirs();
                        Files.write(sourceFile.toPath(), i.getSource().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
                        log.infof("Wrote source: %s", (Object)sourceFile.getAbsolutePath());
                        continue;
                    }
                    log.infof("Source not available: %s", (Object)i.getName());
                }
                catch (Exception t) {
                    log.errorf((Throwable)t, "Failed to write debug source file: %s", (Object)i.getName());
                }
            }
        }
        try {
            BiConsumer consumer = (BiConsumer)Class.forName(resultHandler, false, (ClassLoader)classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
            consumer.accept(context, result);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public AugmentResult createProductionApplication() {
        if (this.launchMode != LaunchMode.NORMAL) {
            throw new IllegalStateException("Can only create a production application when using NORMAL launch mode");
        }
        QuarkusClassLoader classLoader = this.curatedApplication.createDeploymentClassLoader();
        BuildResult result = this.runAugment(true, Collections.emptySet(), null, (ClassLoader)classLoader, ArtifactResultBuildItem.class, DeploymentResultBuildItem.class);
        String debugSourcesDir = BootstrapDebug.DEBUG_SOURCES_DIR;
        if (debugSourcesDir != null) {
            for (GeneratedClassBuildItem i : result.consumeMulti(GeneratedClassBuildItem.class)) {
                try {
                    if (i.getSource() != null) {
                        File debugPath = new File(debugSourcesDir);
                        if (!debugPath.exists()) {
                            debugPath.mkdir();
                        }
                        File sourceFile = new File(debugPath, i.getName() + ".zig");
                        sourceFile.getParentFile().mkdirs();
                        Files.write(sourceFile.toPath(), i.getSource().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
                        log.infof("Wrote source: %s", (Object)sourceFile.getAbsolutePath());
                        continue;
                    }
                    log.infof("Source not available: %s", (Object)i.getName());
                }
                catch (Exception t) {
                    log.errorf((Throwable)t, "Failed to write debug source file: %s", (Object)i.getName());
                }
            }
        }
        JarBuildItem jarBuildItem = (JarBuildItem)result.consumeOptional(JarBuildItem.class);
        NativeImageBuildItem nativeImageBuildItem = (NativeImageBuildItem)result.consumeOptional(NativeImageBuildItem.class);
        List artifactResultBuildItems = result.consumeMulti(ArtifactResultBuildItem.class);
        BuildSystemTargetBuildItem buildSystemTargetBuildItem = (BuildSystemTargetBuildItem)result.consume(BuildSystemTargetBuildItem.class);
        ArtifactResultBuildItem lastResult = (ArtifactResultBuildItem)((Object)artifactResultBuildItems.get(artifactResultBuildItems.size() - 1));
        this.writeArtifactResultMetadataFile(buildSystemTargetBuildItem, lastResult);
        return new AugmentResult(artifactResultBuildItems.stream().map(a -> new ArtifactResult(a.getPath(), a.getType(), a.getMetadata())).collect(Collectors.toList()), jarBuildItem != null ? jarBuildItem.toJarResult() : null, nativeImageBuildItem != null ? nativeImageBuildItem.getPath() : null);
    }

    private void writeArtifactResultMetadataFile(BuildSystemTargetBuildItem outputTargetBuildItem, ArtifactResultBuildItem lastResult) {
        Map<String, Object> metadata;
        Path quarkusArtifactMetadataPath = outputTargetBuildItem.getOutputDirectory().resolve("quarkus-artifact.properties");
        Properties properties = new Properties();
        properties.put("type", lastResult.getType());
        if (lastResult.getPath() != null) {
            properties.put("path", outputTargetBuildItem.getOutputDirectory().relativize(lastResult.getPath()).toString());
        }
        if ((metadata = lastResult.getMetadata()) != null) {
            for (Map.Entry<String, Object> entry : metadata.entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                properties.put("metadata." + entry.getKey(), entry.getValue());
            }
        }
        try (FileOutputStream fos = new FileOutputStream(quarkusArtifactMetadataPath.toFile());){
            properties.store(fos, "Generated by Quarkus - Do not edit manually");
        }
        catch (IOException e) {
            log.debug((Object)"Unable to write artifact result metadata file", (Throwable)e);
        }
    }

    public StartupActionImpl createInitialRuntimeApplication() {
        if (this.launchMode == LaunchMode.NORMAL) {
            throw new IllegalStateException("Cannot launch a runtime application with NORMAL launch mode");
        }
        QuarkusClassLoader classLoader = this.curatedApplication.createDeploymentClassLoader();
        BuildResult result = this.runAugment(true, Collections.emptySet(), null, (ClassLoader)classLoader, NON_NORMAL_MODE_OUTPUTS);
        return new StartupActionImpl(this.curatedApplication, result);
    }

    public StartupActionImpl reloadExistingApplication(boolean hasStartedSuccessfully, Set<String> changedResources, ClassChangeInformation classChangeInformation) {
        if (this.launchMode != LaunchMode.DEVELOPMENT) {
            throw new IllegalStateException("Only application with launch mode DEVELOPMENT can restart");
        }
        QuarkusClassLoader classLoader = this.curatedApplication.createDeploymentClassLoader();
        BuildResult result = this.runAugment(!hasStartedSuccessfully, changedResources, classChangeInformation, (ClassLoader)classLoader, NON_NORMAL_MODE_OUTPUTS);
        return new StartupActionImpl(this.curatedApplication, result);
    }

    public BuildResult runCustomAction(Consumer<BuildChainBuilder> chainBuild, Consumer<BuildExecutionBuilder> executionBuild) {
        ProfileManager.setLaunchMode((LaunchMode)this.launchMode);
        QuarkusClassLoader classLoader = this.curatedApplication.getAugmentClassLoader();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
            BuildChainBuilder chainBuilder = BuildChain.builder();
            chainBuilder.setClassLoader((ClassLoader)classLoader);
            ExtensionLoader.loadStepsFrom((ClassLoader)classLoader, new Properties(), this.curatedApplication.getAppModel(), this.launchMode, this.devModeType, null).accept(chainBuilder);
            chainBuilder.loadProviders((ClassLoader)classLoader);
            for (Consumer<BuildChainBuilder> c : this.chainCustomizers) {
                c.accept(chainBuilder);
            }
            chainBuilder.addInitial(ShutdownContextBuildItem.class).addInitial(LaunchModeBuildItem.class).addInitial(LiveReloadBuildItem.class).addInitial(RawCommandLineArgumentsBuildItem.class);
            chainBuild.accept(chainBuilder);
            BuildChain chain = chainBuilder.build();
            boolean auxiliaryApplication = this.curatedApplication.getQuarkusBootstrap().isAuxiliaryApplication();
            BuildExecutionBuilder execBuilder = chain.createExecutionBuilder("main").produce((BuildItem)new LaunchModeBuildItem(this.launchMode, this.devModeType == null ? Optional.empty() : Optional.of(this.devModeType), auxiliaryApplication, Optional.ofNullable(this.curatedApplication.getQuarkusBootstrap().isHostApplicationIsTestOnly() ? DevModeType.TEST_ONLY : (auxiliaryApplication ? DevModeType.LOCAL : null)), this.curatedApplication.getQuarkusBootstrap().isTest())).produce((BuildItem)new ShutdownContextBuildItem()).produce((BuildItem)new RawCommandLineArgumentsBuildItem()).produce((BuildItem)new LiveReloadBuildItem());
            executionBuild.accept(execBuilder);
            BuildResult buildResult = execBuilder.execute();
            return buildResult;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to run task", e);
        }
        finally {
            try {
                ConfigProviderResolver.instance().releaseConfig(ConfigProviderResolver.instance().getConfig((ClassLoader)classLoader));
            }
            catch (Exception exception) {}
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private BuildResult runAugment(boolean firstRun, Set<String> changedResources, ClassChangeInformation classChangeInformation, ClassLoader deploymentClassLoader, Class<? extends BuildItem> ... finalOutputs) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            QuarkusClassLoader classLoader = this.curatedApplication.getAugmentClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
            ProfileManager.setLaunchMode((LaunchMode)this.launchMode);
            ProfileManager.setRuntimeDefaultProfile((String)Optional.ofNullable(this.quarkusBootstrap.getBuildSystemProperties()).map(properties -> properties.getProperty("quarkus.profile")).orElse(null));
            QuarkusAugmentor.Builder builder = QuarkusAugmentor.builder().setRoot(this.quarkusBootstrap.getApplicationRoot()).setClassLoader((ClassLoader)classLoader).setTargetDir(this.quarkusBootstrap.getTargetDirectory()).setDeploymentClassLoader(deploymentClassLoader).setBuildSystemProperties(this.quarkusBootstrap.getBuildSystemProperties()).setEffectiveModel(this.curatedApplication.getAppModel());
            if (this.quarkusBootstrap.getBaseName() != null) {
                builder.setBaseName(this.quarkusBootstrap.getBaseName());
            }
            boolean auxiliaryApplication = this.curatedApplication.getQuarkusBootstrap().isAuxiliaryApplication();
            builder.setAuxiliaryApplication(auxiliaryApplication);
            builder.setAuxiliaryDevModeType((DevModeType)(this.curatedApplication.getQuarkusBootstrap().isHostApplicationIsTestOnly() ? DevModeType.TEST_ONLY : (auxiliaryApplication ? DevModeType.LOCAL : null)));
            builder.setLaunchMode(this.launchMode);
            builder.setDevModeType(this.devModeType);
            builder.setTest(this.curatedApplication.getQuarkusBootstrap().isTest());
            builder.setRebuild(this.quarkusBootstrap.isRebuild());
            if (firstRun) {
                builder.setLiveReloadState(new LiveReloadBuildItem(false, Collections.emptySet(), this.reloadContext, classChangeInformation));
            } else {
                builder.setLiveReloadState(new LiveReloadBuildItem(true, changedResources, this.reloadContext, classChangeInformation));
            }
            for (AdditionalDependency additionalDependency : this.quarkusBootstrap.getAdditionalApplicationArchives()) {
                if (!additionalDependency.isForceApplicationArchive()) continue;
                builder.addAdditionalApplicationArchive(additionalDependency.getArchivePath());
            }
            builder.excludeFromIndexing(this.quarkusBootstrap.getExcludeFromClassPath());
            for (Consumer consumer : this.chainCustomizers) {
                builder.addBuildChainCustomizer(consumer);
            }
            for (Iterator<Object> iterator : finalOutputs) {
                builder.addFinal(iterator);
            }
            try {
                Iterator<Object> iterator = builder.build().run();
                return iterator;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            ProfileManager.setRuntimeDefaultProfile(null);
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public static class BuildTask
    implements BiConsumer<CuratedApplication, Map<String, Object>> {
        @Override
        public void accept(CuratedApplication application, Map<String, Object> stringObjectMap) {
            AugmentActionImpl action = new AugmentActionImpl(application);
            action.createProductionApplication();
        }
    }
}

