/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.mutability;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.model.PersistentAppModel;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;

public class ReaugmentTask {
    public static void main(Path appRoot) throws Exception {
        Path deploymentLib = appRoot.resolve("lib").resolve("deployment");
        try (ObjectInputStream in = new ObjectInputStream(Files.newInputStream(deploymentLib.resolve("appmodel.dat"), new OpenOption[0]));){
            Properties buildSystemProperties = new Properties();
            try (InputStream buildIn = Files.newInputStream(deploymentLib.resolve("build-system.properties"), new OpenOption[0]);){
                buildSystemProperties.load(buildIn);
            }
            PersistentAppModel appModel = (PersistentAppModel)in.readObject();
            AppModel existingModel = appModel.getAppModel(appRoot);
            System.setProperty("quarkus.package.type", "fast-jar");
            try (CuratedApplication bootstrap = QuarkusBootstrap.builder().setAppArtifact(existingModel.getAppArtifact()).setExistingModel(existingModel).setRebuild(true).setBuildSystemProperties(buildSystemProperties).setBaseName(appModel.getBaseName()).setApplicationRoot(existingModel.getAppArtifact().getPath()).setTargetDirectory(appRoot.getParent()).setBaseClassLoader(ReaugmentTask.class.getClassLoader()).build().bootstrap();){
                bootstrap.createAugmentor().createProductionApplication();
            }
        }
    }
}

