/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.pkg.steps.ErrorReplacingProcessReader;
import io.quarkus.deployment.pkg.steps.NativeImageBuildStep;
import io.quarkus.deployment.util.ProcessUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class NativeImageBuildRunner {
    public NativeImageBuildStep.GraalVM.Version getGraalVMVersion() {
        NativeImageBuildStep.GraalVM.Version graalVMVersion;
        try {
            String[] versionCommand = this.getGraalVMVersionCommand(Collections.singletonList("--version"));
            Process versionProcess = new ProcessBuilder(versionCommand).redirectErrorStream(true).start();
            versionProcess.waitFor();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(versionProcess.getInputStream(), StandardCharsets.UTF_8));){
                graalVMVersion = NativeImageBuildStep.GraalVM.Version.of(reader.lines());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get GraalVM version", e);
        }
        return graalVMVersion;
    }

    public void setup(boolean processInheritIODisabled) {
    }

    public void cleanupServer(File outputDir, boolean processInheritIODisabled) throws InterruptedException, IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int build(List<String> args, Path outputDir, boolean processInheritIODisabled) throws InterruptedException, IOException {
        this.preBuild(args);
        try {
            CountDownLatch errorReportLatch = new CountDownLatch(1);
            ProcessBuilder processBuilder = new ProcessBuilder(this.getBuildCommand(args)).directory(outputDir.toFile());
            Process process = ProcessUtil.launchProcessStreamStdOut(processBuilder, processInheritIODisabled);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.submit(new ErrorReplacingProcessReader(process.getErrorStream(), outputDir.resolve("reports").toFile(), errorReportLatch));
            executor.shutdown();
            errorReportLatch.await();
            int n = process.waitFor();
            return n;
        }
        finally {
            this.postBuild();
        }
    }

    protected abstract String[] getGraalVMVersionCommand(List<String> var1);

    protected abstract String[] getBuildCommand(List<String> var1);

    protected void preBuild(List<String> buildArgs) throws IOException, InterruptedException {
    }

    protected void postBuild() throws InterruptedException, IOException {
    }
}

