/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime.noop;

import io.quarkus.cache.Cache;
import io.quarkus.cache.CacheManager;
import io.quarkus.cache.runtime.CacheManagerImpl;
import io.quarkus.cache.runtime.noop.NoOpCache;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@Recorder
public class NoOpCacheBuildRecorder {
    public Supplier<CacheManager> getCacheManagerSupplier(final Set<String> cacheNames) {
        Objects.requireNonNull(cacheNames);
        return new Supplier<CacheManager>(){

            @Override
            public CacheManager get() {
                if (cacheNames.isEmpty()) {
                    return new CacheManagerImpl(Collections.emptyMap());
                }
                HashMap<String, Cache> caches = new HashMap<String, Cache>(cacheNames.size() + 1, 1.0f);
                NoOpCache cache = new NoOpCache();
                for (String cacheName : cacheNames) {
                    caches.put(cacheName, cache);
                }
                return new CacheManagerImpl(caches);
            }
        };
    }
}

