/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.creator.ops;

import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.TypeKind;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ops.ComparableOps;
import io.quarkus.gizmo2.creator.ops.ObjectOps;
import io.quarkus.gizmo2.desc.Descs;
import io.quarkus.gizmo2.desc.MethodDesc;

public final class StringOps
extends ObjectOps
implements ComparableOps {
    public StringOps(BlockCreator bc, Expr obj) {
        super(bc, obj);
    }

    public Expr isEmpty() {
        return this.bc.invokeVirtual(Descs.MD_String.isEmpty, this.obj);
    }

    public Expr length() {
        return this.bc.invokeVirtual(Descs.MD_String.length, this.obj);
    }

    public Expr substring(Expr start) {
        return this.bc.invokeVirtual((MethodDesc)Descs.MD_String.substring_1, this.obj, start);
    }

    public Expr substring(int start) {
        return this.substring(Const.of(start));
    }

    public Expr substring(Expr start, Expr end) {
        return this.bc.invokeVirtual((MethodDesc)Descs.MD_String.substring_2, this.obj, start, end);
    }

    public Expr substring(int start, int end) {
        return this.substring(Const.of(start), Const.of(end));
    }

    public Expr charAt(Expr index) {
        return this.bc.invokeVirtual((MethodDesc)Descs.MD_String.charAt, this.obj, index);
    }

    public Expr charAt(int index) {
        return this.charAt(Const.of(index));
    }

    public Expr codePointAt(Expr index) {
        return this.bc.invokeVirtual((MethodDesc)Descs.MD_String.codePointAt, this.obj, index);
    }

    public Expr codePointAt(int index) {
        return this.codePointAt(Const.of(index));
    }

    public Expr indexOf(Expr item) {
        return switch (item.typeKind().asLoadable()) {
            case TypeKind.INT -> this.bc.invokeVirtual((MethodDesc)Descs.MD_String.indexOf_int, this.obj, item);
            case TypeKind.REFERENCE -> this.bc.invokeVirtual((MethodDesc)Descs.MD_String.indexOf_String, this.obj, item);
            default -> throw new IllegalArgumentException("Invalid item type " + String.valueOf(item.type()));
        };
    }

    public Expr indexOf(int ch) {
        return this.indexOf(Const.of(ch));
    }

    public Expr indexOf(String str) {
        return this.indexOf(Const.of(str));
    }

    public Expr lastIndexOf(Expr item) {
        return switch (item.typeKind().asLoadable()) {
            case TypeKind.INT -> this.bc.invokeVirtual((MethodDesc)Descs.MD_String.lastIndexOf_int, this.obj, item);
            case TypeKind.REFERENCE -> this.bc.invokeVirtual((MethodDesc)Descs.MD_String.lastIndexOf_String, this.obj, item);
            default -> throw new IllegalArgumentException("Invalid item type " + String.valueOf(item.type()));
        };
    }

    public Expr lastIndexOf(int ch) {
        return this.lastIndexOf(Const.of(ch));
    }

    public Expr lastIndexOf(String str) {
        return this.lastIndexOf(Const.of(str));
    }

    public Expr concat(Expr other) {
        return this.bc.invokeVirtual((MethodDesc)Descs.MD_String.concat, this.obj, other);
    }

    @Override
    public Expr compareTo(Expr other) {
        return this.bc.invokeVirtual((MethodDesc)Descs.MD_String.compareTo, this.obj, other);
    }
}

