/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.mojo;

import com.google.common.base.Joiner;
import io.protostuff.compiler.CachingProtoLoader;
import io.protostuff.compiler.CompilerMain;
import io.protostuff.mojo.ProtoModule;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="compile", configurator="include-project-dependencies", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ProtoCompilerMojo
extends AbstractMojo {
    public static final String GENERATE_TEST_SOURCES_PHASE = "generate-test-sources";
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="protostuff.compiler.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="protostuff.compiler.cache_protos", defaultValue="false")
    private boolean cacheProtos;
    @Parameter(property="protostuff.compiler.force", defaultValue="false", required=true)
    private boolean forceMojoExecution;
    @Parameter
    protected File modulesFile;
    @Parameter
    protected File sourceBaseDir;
    @Parameter
    protected File outputBaseDir;
    @Parameter
    protected ProtoModule[] protoModules;
    @Parameter(property="project.basedir", required=true)
    protected File baseDir;
    @Parameter
    protected Properties properties;
    @Component
    private MojoExecution execution;
    private Properties systemPropertiesBackup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        block20: {
            if (this.skipMojo()) {
                return;
            }
            assert (this.baseDir != null && this.baseDir.exists() && this.baseDir.isDirectory());
            CachingProtoLoader loader = this.cacheProtos ? new CachingProtoLoader() : null;
            try {
                this.setSystemProperties();
                if (this.modulesFile == null) {
                    if (this.protoModules == null) {
                        throw new MojoExecutionException("Either <modules> or <modulesFile> should be provided.");
                    }
                    try {
                        for (ProtoModule m : this.protoModules) {
                            if (m.getOutput() == null || m.getOutput().isEmpty()) {
                                throw new MojoExecutionException("Module parameter <output> is not set.");
                            }
                            m.setCachingProtoLoader(loader);
                            this.updateRelativeOutputLocation(m);
                            CompilerMain.compile((io.protostuff.compiler.ProtoModule)m);
                            if (!m.isAddToCompileSourceRoot()) continue;
                            if (GENERATE_TEST_SOURCES_PHASE.equals(this.execution.getLifecyclePhase())) {
                                this.project.addTestCompileSourceRoot(m.getOutputDir().getAbsolutePath());
                                continue;
                            }
                            this.project.addCompileSourceRoot(m.getOutputDir().getAbsolutePath());
                        }
                        break block20;
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException(e.getMessage(), e);
                    }
                }
                try {
                    if (this.protoModules != null) {
                        for (ProtoModule m : this.protoModules) {
                            m.setCachingProtoLoader(loader);
                            CompilerMain.compile((io.protostuff.compiler.ProtoModule)m);
                            if (!m.isAddToCompileSourceRoot()) continue;
                            if (GENERATE_TEST_SOURCES_PHASE.equals(this.execution.getLifecyclePhase())) {
                                this.project.addTestCompileSourceRoot(m.getOutputDir().getAbsolutePath());
                                continue;
                            }
                            this.project.addCompileSourceRoot(m.getOutputDir().getAbsolutePath());
                        }
                    }
                    if (!this.modulesFile.exists()) {
                        throw new MojoExecutionException(this.modulesFile + " does not exist.");
                    }
                    File parent = this.modulesFile.getParentFile();
                    File sourceBaseDir = this.sourceBaseDir;
                    File outputBaseDir = this.outputBaseDir;
                    if (sourceBaseDir == null) {
                        sourceBaseDir = parent;
                    }
                    if (outputBaseDir == null) {
                        outputBaseDir = parent;
                    }
                    CompilerMain.compile((List)CompilerMain.loadModules((File)this.modulesFile, (File)sourceBaseDir, (File)outputBaseDir));
                }
                catch (Exception e) {
                    throw new MojoExecutionException(e.getMessage(), e);
                }
            }
            finally {
                this.resetSystemProperties();
            }
        }
    }

    private void updateRelativeOutputLocation(ProtoModule m) {
        String originalOutput = m.getOutput();
        String[] outputList = CompilerMain.COMMA.split(originalOutput);
        ArrayList<String> result = new ArrayList<String>();
        for (String output : outputList) {
            output = output.trim();
            boolean standardOutput = CompilerMain.isAvailableOutput((String)output);
            File basedir = this.baseDir.getAbsoluteFile();
            File currentDir = new File(".").getAbsoluteFile();
            if (!standardOutput) {
                try {
                    File relativePath;
                    File absolutePath = new File(output);
                    if (!absolutePath.exists() && (relativePath = new File(this.baseDir, output)).exists()) {
                        output = relativePath.getCanonicalPath();
                    }
                }
                catch (Exception e) {
                    this.getLog().debug((CharSequence)("Can not determine full path for output=" + output), (Throwable)e);
                }
            }
            result.add(output);
        }
        String updatedOutput = Joiner.on((char)',').join(result);
        m.setOutput(updatedOutput);
    }

    private void setSystemProperties() {
        this.systemPropertiesBackup = System.getProperties();
        if (this.properties != null) {
            for (Object o : this.properties.keySet()) {
                String key = (String)o;
                String value = this.properties.getProperty(key);
                System.setProperty(key, value);
                this.getLog().info((CharSequence)("Set property: " + key + " = '" + value + "'"));
            }
        }
    }

    private void resetSystemProperties() {
        System.setProperties(this.systemPropertiesBackup);
    }

    protected boolean skipMojo() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping protostuff mojo execution");
            return true;
        }
        if (!this.forceMojoExecution && "pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping protostuff mojo execution for project with packaging type 'pom'");
            return true;
        }
        return false;
    }
}

