/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.handler.ssl.util.LazyX509Certificate;
import io.netty.incubator.codec.quic.BoringSSLCertificateCallback;
import io.netty.incubator.codec.quic.BoringSSLCertificateVerifyCallback;
import io.netty.incubator.codec.quic.BoringSSLHandshakeCompleteCallback;
import io.netty.incubator.codec.quic.BoringSSLKeylogCallback;
import io.netty.incubator.codec.quic.BoringSSLNativeStaticallyReferencedJniMethods;
import io.netty.incubator.codec.quic.BoringSSLSessionCallback;
import io.netty.incubator.codec.quic.BoringSSLTlsextServernameCallback;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;

final class BoringSSL {
    static final int SSL_VERIFY_NONE = BoringSSLNativeStaticallyReferencedJniMethods.ssl_verify_none();
    static final int SSL_VERIFY_FAIL_IF_NO_PEER_CERT = BoringSSLNativeStaticallyReferencedJniMethods.ssl_verify_fail_if_no_peer_cert();
    static final int SSL_VERIFY_PEER = BoringSSLNativeStaticallyReferencedJniMethods.ssl_verify_peer();
    static final int X509_V_OK = BoringSSLNativeStaticallyReferencedJniMethods.x509_v_ok();
    static final int X509_V_ERR_CERT_HAS_EXPIRED = BoringSSLNativeStaticallyReferencedJniMethods.x509_v_err_cert_has_expired();
    static final int X509_V_ERR_CERT_NOT_YET_VALID = BoringSSLNativeStaticallyReferencedJniMethods.x509_v_err_cert_not_yet_valid();
    static final int X509_V_ERR_CERT_REVOKED = BoringSSLNativeStaticallyReferencedJniMethods.x509_v_err_cert_revoked();
    static final int X509_V_ERR_UNSPECIFIED = BoringSSLNativeStaticallyReferencedJniMethods.x509_v_err_unspecified();

    private BoringSSL() {
    }

    static long SSLContext_new(boolean server, String[] applicationProtocols, BoringSSLHandshakeCompleteCallback handshakeCompleteCallback, BoringSSLCertificateCallback certificateCallback, BoringSSLCertificateVerifyCallback verifyCallback, BoringSSLTlsextServernameCallback servernameCallback, BoringSSLKeylogCallback keylogCallback, BoringSSLSessionCallback sessionCallback, int verifyMode, byte[][] subjectNames) {
        return BoringSSL.SSLContext_new0(server, BoringSSL.toWireFormat(applicationProtocols), handshakeCompleteCallback, certificateCallback, verifyCallback, servernameCallback, keylogCallback, sessionCallback, verifyMode, subjectNames);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] toWireFormat(String[] applicationProtocols) {
        if (applicationProtocols == null) {
            return null;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            for (String p : applicationProtocols) {
                byte[] bytes = p.getBytes(StandardCharsets.US_ASCII);
                out.write(bytes.length);
                out.write(bytes);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static native long SSLContext_new0(boolean var0, byte[] var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, int var8, byte[][] var9);

    static native void SSLContext_set_early_data_enabled(long var0, boolean var2);

    static native long SSLContext_setSessionCacheSize(long var0, long var2);

    static native long SSLContext_setSessionCacheTimeout(long var0, long var2);

    static native void SSLContext_free(long var0);

    static long SSL_new(long context, boolean server, String hostname) {
        return BoringSSL.SSL_new0(context, server, BoringSSL.tlsExtHostName(hostname));
    }

    static native long SSL_new0(long var0, boolean var2, String var3);

    static native void SSL_free(long var0);

    static native long EVP_PKEY_parse(byte[] var0, String var1);

    static native void EVP_PKEY_free(long var0);

    static native long CRYPTO_BUFFER_stack_new(long var0, byte[][] var2);

    static native void CRYPTO_BUFFER_stack_free(long var0);

    static native String ERR_last_error();

    private static String tlsExtHostName(String hostname) {
        if (hostname != null && hostname.endsWith(".")) {
            hostname = hostname.substring(0, hostname.length() - 1);
        }
        return hostname;
    }

    static X509Certificate[] certificates(byte[][] chain) {
        X509Certificate[] peerCerts = new X509Certificate[chain.length];
        for (int i = 0; i < peerCerts.length; ++i) {
            peerCerts[i] = new LazyX509Certificate(chain[i]);
        }
        return peerCerts;
    }

    static byte[][] subjectNames(X509Certificate[] certificates) {
        byte[][] subjectNames = new byte[certificates.length][];
        for (int i = 0; i < certificates.length; ++i) {
            subjectNames[i] = certificates[i].getSubjectX500Principal().getEncoded();
        }
        return subjectNames;
    }
}

