/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.cache;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import io.micrometer.core.lang.Nullable;
import java.lang.ref.WeakReference;

@NonNullApi
@NonNullFields
public abstract class CacheMeterBinder
implements MeterBinder {
    private final WeakReference<Object> cache;
    private final Iterable<Tag> tags;

    public CacheMeterBinder(Object cache, String cacheName, Iterable<Tag> tags) {
        this.tags = Tags.concat(tags, "cache", cacheName);
        this.cache = new WeakReference<Object>(cache);
    }

    @Override
    public final void bindTo(MeterRegistry registry) {
        if (this.size() != null) {
            Gauge.builder("cache.size", this.cache.get(), c -> {
                Long size = this.size();
                return size == null ? 0.0 : (double)size.longValue();
            }).tags(this.tags).description("The number of entries in this cache. This may be an approximation, depending on the type of cache.").register(registry);
        }
        if (this.missCount() != null) {
            FunctionCounter.builder("cache.gets", this.cache.get(), c -> {
                Long misses = this.missCount();
                return misses == null ? 0.0 : (double)misses.longValue();
            }).tags(this.tags).tag("result", "miss").description("the number of times cache lookup methods have returned an uncached (newly loaded) value, or null").register(registry);
        }
        FunctionCounter.builder("cache.gets", this.cache.get(), c -> this.hitCount()).tags(this.tags).tag("result", "hit").description("The number of times cache lookup methods have returned a cached value.").register(registry);
        FunctionCounter.builder("cache.puts", this.cache.get(), c -> this.putCount()).tags(this.tags).description("The number of entries added to the cache").register(registry);
        if (this.evictionCount() != null) {
            FunctionCounter.builder("cache.evictions", this.cache.get(), c -> {
                Long evictions = this.evictionCount();
                return evictions == null ? 0.0 : (double)evictions.longValue();
            }).tags(this.tags).description("cache evictions").register(registry);
        }
        this.bindImplementationSpecificMetrics(registry);
    }

    @Nullable
    protected abstract Long size();

    protected abstract long hitCount();

    @Nullable
    protected abstract Long missCount();

    @Nullable
    protected abstract Long evictionCount();

    protected abstract long putCount();

    protected abstract void bindImplementationSpecificMetrics(MeterRegistry var1);

    protected Iterable<Tag> getTagsWithCacheName() {
        return this.tags;
    }
}

