/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.util;

import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.util.RandomSubsettingLoadBalancer;
import java.util.Map;

@Internal
public final class RandomSubsettingLoadBalancerProvider
extends LoadBalancerProvider {
    private static final String POLICY_NAME = "random_subsetting_experimental";

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new RandomSubsettingLoadBalancer(helper);
    }

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return POLICY_NAME;
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        try {
            return this.parseLoadBalancingPolicyConfigInternal(rawConfig);
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError((Status)Status.UNAVAILABLE.withCause((Throwable)e).withDescription("Failed parsing configuration for " + this.getPolicyName()));
        }
    }

    private NameResolver.ConfigOrError parseLoadBalancingPolicyConfigInternal(Map<String, ?> rawConfig) {
        Long subsetSize = JsonUtil.getNumberAsLong(rawConfig, (String)"subsetSize");
        if (subsetSize == null) {
            return NameResolver.ConfigOrError.fromError((Status)Status.UNAVAILABLE.withDescription("Subset size missing in " + this.getPolicyName() + ", LB policy config=" + rawConfig));
        }
        NameResolver.ConfigOrError childConfig = GracefulSwitchLoadBalancer.parseLoadBalancingPolicyConfig(JsonUtil.getListOfObjects(rawConfig, (String)"childPolicy"));
        if (childConfig.getError() != null) {
            return NameResolver.ConfigOrError.fromError((Status)Status.UNAVAILABLE.withDescription("Failed to parse child in " + this.getPolicyName() + ", LB policy config=" + rawConfig).withCause((Throwable)childConfig.getError().asRuntimeException()));
        }
        return NameResolver.ConfigOrError.fromConfig((Object)new RandomSubsettingLoadBalancer.RandomSubsettingLoadBalancerConfig.Builder().setSubsetSize(subsetSize).setChildConfig(childConfig.getConfig()).build());
    }
}

