/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.AttachmentContentEncoding;
import io.cucumber.messages.types.Source;
import io.cucumber.messages.types.Timestamp;
import java.util.Objects;
import java.util.Optional;

public final class Attachment {
    private final String body;
    private final AttachmentContentEncoding contentEncoding;
    private final String fileName;
    private final String mediaType;
    private final Source source;
    private final String testCaseStartedId;
    private final String testStepId;
    private final String url;
    private final String testRunStartedId;
    private final String testRunHookStartedId;
    private final Timestamp timestamp;

    public Attachment(String body, AttachmentContentEncoding contentEncoding, String fileName, String mediaType, Source source, String testCaseStartedId, String testStepId, String url, String testRunStartedId, String testRunHookStartedId, Timestamp timestamp) {
        this.body = Objects.requireNonNull(body, "Attachment.body cannot be null");
        this.contentEncoding = Objects.requireNonNull(contentEncoding, "Attachment.contentEncoding cannot be null");
        this.fileName = fileName;
        this.mediaType = Objects.requireNonNull(mediaType, "Attachment.mediaType cannot be null");
        this.source = source;
        this.testCaseStartedId = testCaseStartedId;
        this.testStepId = testStepId;
        this.url = url;
        this.testRunStartedId = testRunStartedId;
        this.testRunHookStartedId = testRunHookStartedId;
        this.timestamp = timestamp;
    }

    public String getBody() {
        return this.body;
    }

    public AttachmentContentEncoding getContentEncoding() {
        return this.contentEncoding;
    }

    public Optional<String> getFileName() {
        return Optional.ofNullable(this.fileName);
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public Optional<Source> getSource() {
        return Optional.ofNullable(this.source);
    }

    public Optional<String> getTestCaseStartedId() {
        return Optional.ofNullable(this.testCaseStartedId);
    }

    public Optional<String> getTestStepId() {
        return Optional.ofNullable(this.testStepId);
    }

    public Optional<String> getUrl() {
        return Optional.ofNullable(this.url);
    }

    public Optional<String> getTestRunStartedId() {
        return Optional.ofNullable(this.testRunStartedId);
    }

    public Optional<String> getTestRunHookStartedId() {
        return Optional.ofNullable(this.testRunHookStartedId);
    }

    public Optional<Timestamp> getTimestamp() {
        return Optional.ofNullable(this.timestamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attachment that = (Attachment)o;
        return this.body.equals(that.body) && this.contentEncoding.equals((Object)that.contentEncoding) && Objects.equals(this.fileName, that.fileName) && this.mediaType.equals(that.mediaType) && Objects.equals(this.source, that.source) && Objects.equals(this.testCaseStartedId, that.testCaseStartedId) && Objects.equals(this.testStepId, that.testStepId) && Objects.equals(this.url, that.url) && Objects.equals(this.testRunStartedId, that.testRunStartedId) && Objects.equals(this.testRunHookStartedId, that.testRunHookStartedId) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.body, this.contentEncoding, this.fileName, this.mediaType, this.source, this.testCaseStartedId, this.testStepId, this.url, this.testRunStartedId, this.testRunHookStartedId, this.timestamp});
    }

    public String toString() {
        return "Attachment{body=" + this.body + ", contentEncoding=" + (Object)((Object)this.contentEncoding) + ", fileName=" + this.fileName + ", mediaType=" + this.mediaType + ", source=" + this.source + ", testCaseStartedId=" + this.testCaseStartedId + ", testStepId=" + this.testStepId + ", url=" + this.url + ", testRunStartedId=" + this.testRunStartedId + ", testRunHookStartedId=" + this.testRunHookStartedId + ", timestamp=" + this.timestamp + '}';
    }
}

