/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.AmbiguousParameterTypeException;
import io.cucumber.cucumberexpressions.BuiltInParameterTransformer;
import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.cucumberexpressions.CucumberExpressionGenerator;
import io.cucumber.cucumberexpressions.DuplicateTypeNameException;
import io.cucumber.cucumberexpressions.GeneratedExpression;
import io.cucumber.cucumberexpressions.ParameterByTypeTransformer;
import io.cucumber.cucumberexpressions.ParameterType;
import io.cucumber.cucumberexpressions.Transformer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class ParameterTypeRegistry {
    private static final List<String> INTEGER_REGEXPS = Arrays.asList(Pattern.compile("-?\\d+").pattern(), Pattern.compile("\\d+").pattern());
    private static final List<String> FLOAT_REGEXPS = Collections.singletonList(Pattern.compile("-?\\d*[.,]\\d+").pattern());
    private static final List<String> WORD_REGEXPS = Collections.singletonList(Pattern.compile("[^\\s]+").pattern());
    private static final List<String> STRING_REGEXPS = Collections.singletonList(Pattern.compile("\"([^\"\\\\]*(\\\\.[^\"\\\\]*)*)\"|'([^'\\\\]*(\\\\.[^'\\\\]*)*)'").pattern());
    private static final String ANONYMOUS_REGEX = Pattern.compile(".*").pattern();
    private final Map<String, ParameterType<?>> parameterTypeByName = new HashMap();
    private final Map<String, SortedSet<ParameterType<?>>> parameterTypesByRegexp = new HashMap();
    private final ParameterByTypeTransformer internalParameterTransformer;
    private ParameterByTypeTransformer defaultParameterTransformer;

    public ParameterTypeRegistry(Locale locale) {
        this(new BuiltInParameterTransformer(locale));
    }

    private ParameterTypeRegistry(ParameterByTypeTransformer defaultParameterTransformer) {
        this.internalParameterTransformer = defaultParameterTransformer;
        this.defaultParameterTransformer = defaultParameterTransformer;
        this.defineParameterType(new ParameterType<BigInteger>("biginteger", INTEGER_REGEXPS, BigInteger.class, new Transformer<BigInteger>(){

            @Override
            public BigInteger transform(String arg) throws Throwable {
                return (BigInteger)ParameterTypeRegistry.this.internalParameterTransformer.transform(arg, (Type)((Object)BigInteger.class));
            }
        }, false, false));
        this.defineParameterType(new ParameterType<BigDecimal>("bigdecimal", FLOAT_REGEXPS, BigDecimal.class, new Transformer<BigDecimal>(){

            @Override
            public BigDecimal transform(String arg) throws Throwable {
                return (BigDecimal)ParameterTypeRegistry.this.internalParameterTransformer.transform(arg, (Type)((Object)BigDecimal.class));
            }
        }, false, false));
        this.defineParameterType(new ParameterType<Byte>("byte", INTEGER_REGEXPS, Byte.class, new Transformer<Byte>(){

            @Override
            public Byte transform(String arg) throws Throwable {
                return (Byte)ParameterTypeRegistry.this.internalParameterTransformer.transform(arg, (Type)((Object)Byte.class));
            }
        }, false, false));
        this.defineParameterType(new ParameterType<Short>("short", INTEGER_REGEXPS, Short.class, new Transformer<Short>(){

            @Override
            public Short transform(String arg) throws Throwable {
                return (Short)ParameterTypeRegistry.this.internalParameterTransformer.transform(arg, (Type)((Object)Short.class));
            }
        }, false, false));
        this.defineParameterType(new ParameterType<Integer>("int", INTEGER_REGEXPS, Integer.class, new Transformer<Integer>(){

            @Override
            public Integer transform(String arg) throws Throwable {
                return (Integer)ParameterTypeRegistry.this.internalParameterTransformer.transform(arg, (Type)((Object)Integer.class));
            }
        }, true, true));
        this.defineParameterType(new ParameterType<Long>("long", INTEGER_REGEXPS, Long.class, new Transformer<Long>(){

            @Override
            public Long transform(String arg) throws Throwable {
                return (Long)ParameterTypeRegistry.this.internalParameterTransformer.transform(arg, (Type)((Object)Long.class));
            }
        }, false, false));
        this.defineParameterType(new ParameterType<Float>("float", FLOAT_REGEXPS, Float.class, new Transformer<Float>(){

            @Override
            public Float transform(String arg) throws Throwable {
                return (Float)ParameterTypeRegistry.this.internalParameterTransformer.transform(arg, (Type)((Object)Float.class));
            }
        }, false, false));
        this.defineParameterType(new ParameterType<Double>("double", FLOAT_REGEXPS, Double.class, new Transformer<Double>(){

            @Override
            public Double transform(String arg) throws Throwable {
                return (Double)ParameterTypeRegistry.this.internalParameterTransformer.transform(arg, (Type)((Object)Double.class));
            }
        }, true, true));
        this.defineParameterType(new ParameterType<String>("word", WORD_REGEXPS, String.class, new Transformer<String>(){

            @Override
            public String transform(String arg) throws Throwable {
                return (String)ParameterTypeRegistry.this.internalParameterTransformer.transform(arg, (Type)((Object)String.class));
            }
        }, false, false));
        this.defineParameterType(new ParameterType<String>("string", STRING_REGEXPS, String.class, new Transformer<String>(){

            @Override
            public String transform(String arg) throws Throwable {
                return arg == null ? null : (String)ParameterTypeRegistry.this.internalParameterTransformer.transform(arg.replaceAll("\\\\\"", "\"").replaceAll("\\\\'", "'"), (Type)((Object)String.class));
            }
        }, true, false));
        this.defineParameterType(ParameterType.createAnonymousParameterType(ANONYMOUS_REGEX));
    }

    public void defineParameterType(ParameterType<?> parameterType) {
        if (parameterType.getName() != null) {
            if (this.parameterTypeByName.containsKey(parameterType.getName())) {
                if (parameterType.getName().isEmpty()) {
                    throw new DuplicateTypeNameException("The anonymous parameter type has already been defined");
                }
                throw new DuplicateTypeNameException(String.format("There is already a parameter type with name %s", parameterType.getName()));
            }
            this.parameterTypeByName.put(parameterType.getName(), parameterType);
        }
        for (String parameterTypeRegexp : parameterType.getRegexps()) {
            SortedSet<ParameterType<?>> parameterTypes;
            if (!this.parameterTypesByRegexp.containsKey(parameterTypeRegexp)) {
                this.parameterTypesByRegexp.put(parameterTypeRegexp, new TreeSet());
            }
            if (!(parameterTypes = this.parameterTypesByRegexp.get(parameterTypeRegexp)).isEmpty() && parameterTypes.first().preferForRegexpMatch() && parameterType.preferForRegexpMatch()) {
                throw new CucumberExpressionException(String.format("There can only be one preferential parameter type per regexp. The regexp /%s/ is used for two preferential parameter types, {%s} and {%s}", parameterTypeRegexp, parameterTypes.first().getName(), parameterType.getName()));
            }
            parameterTypes.add(parameterType);
        }
    }

    public ParameterByTypeTransformer getDefaultParameterTransformer() {
        return this.defaultParameterTransformer;
    }

    public void setDefaultParameterTransformer(ParameterByTypeTransformer defaultParameterTransformer) {
        this.defaultParameterTransformer = defaultParameterTransformer;
    }

    public <T> ParameterType<T> lookupByTypeName(String typeName) {
        return this.parameterTypeByName.get(typeName);
    }

    public <T> ParameterType<T> lookupByRegexp(String parameterTypeRegexp, Pattern expressionRegexp, String text) {
        SortedSet<ParameterType<?>> parameterTypes = this.parameterTypesByRegexp.get(parameterTypeRegexp);
        if (parameterTypes == null) {
            return null;
        }
        if (parameterTypes.size() > 1 && !parameterTypes.first().preferForRegexpMatch()) {
            List<GeneratedExpression> generatedExpressions = new CucumberExpressionGenerator(this).generateExpressions(text);
            throw new AmbiguousParameterTypeException(parameterTypeRegexp, expressionRegexp, parameterTypes, generatedExpressions);
        }
        return parameterTypes.first();
    }

    public Collection<ParameterType<?>> getParameterTypes() {
        return this.parameterTypeByName.values();
    }
}

