/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.util;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class PageVisibility {
    private final UI ui;
    private List<PageVisibilityListener> listeners = new ArrayList<PageVisibilityListener>();
    private DomListenerRegistration domListenerRegistration;

    private PageVisibility(UI ui) {
        this.ui = ui;
    }

    public static PageVisibility get() {
        return PageVisibility.get(UI.getCurrent());
    }

    public static PageVisibility get(UI ui) {
        PageVisibility pageVisibility = (PageVisibility)ComponentUtil.getData((Component)ui, PageVisibility.class);
        if (pageVisibility == null) {
            pageVisibility = new PageVisibility(ui);
            ComponentUtil.setData((Component)ui, PageVisibility.class, (Object)pageVisibility);
        }
        return pageVisibility;
    }

    public CompletableFuture<Visibility> isVisible() {
        return this.ui.getPage().executeJs("    if(document.hidden) {\n        return 'HIDDEN';\n    } else {\n        if(document.hasFocus()) {\n            return 'VISIBLE';\n        } else {\n            return 'VISIBLE_NON_FOCUSED';\n        }\n    }\n", new Object[0]).toCompletableFuture(String.class).thenApply(str -> Visibility.valueOf(str.toUpperCase()));
    }

    public Registration addVisibilityChangeListener(PageVisibilityListener listener) {
        if (this.domListenerRegistration == null) {
            this.ui.getPage().executeJs("document.addEventListener('visibilitychange', function() {\n     if(document.hidden) {\n       document.body.dispatchEvent(new CustomEvent('viritin-visibilitychange', {detail: 'HIDDEN'}));\n     } else {\n        // when becoming visible, always also has focus\n        document.body.dispatchEvent(new CustomEvent('viritin-visibilitychange', {detail: 'VISIBLE'}));\n     }\n     if(document.viritinBlurTimer) {\n         clearTimeout(document.viritinBlurTimer);\n         unset(document.viritinBlurTimer);\n     }\n});\nwindow.addEventListener('blur', function(event) {\n     var timeout = 10;\n     // Firefox has a long delay before it fires the visibilitychange event\n     // when the page is blurred, so we use a timeout to ensure we catch it.\n     const isFirefox = navigator.userAgent.indexOf(\"Firefox\") > -1;\n     if(isFirefox) {\n         // Timeout for the visibilitychange event in Firefox is actaully more than 500ms,\n         // but at 500ms the document.hidden is already true, so we can use that to ignore the\n         // obsolete state change\n         timeout = 500;\n     }\n     document.viritinBlurTimer = setTimeout(() => {\n         if(document.hidden) {\n             // detected by visibilitychange\n             console.error(\"Blur event detected, but page is hidden, not dispatching visibility change.\");\n         } else {\n             document.body.dispatchEvent(new CustomEvent('viritin-visibilitychange', {detail: 'VISIBLE_NON_FOCUSED'}));\n         }\n         unset(document.viritinBlurTimer);\n     }, timeout);\n});\nwindow.addEventListener('focus', function(event) {\n     if(!document.hidden) {\n         document.body.dispatchEvent(new CustomEvent('viritin-visibilitychange', {detail: 'VISIBLE'}));\n     }\n});\n", new Object[0]);
            this.domListenerRegistration = this.ui.getElement().addEventListener("viritin-visibilitychange", (DomEventListener & Serializable)event -> {
                String detail = (String)event.getEventDetail(String.class);
                Visibility visibility = Visibility.valueOf(detail.toUpperCase());
                this.listeners.stream().toList().forEach(l -> l.accept((Object)visibility));
            }).addEventDetail().debounce(100);
        }
        this.listeners.add(listener);
        return (Registration & Serializable)() -> this.listeners.remove(listener);
    }

    public static interface PageVisibilityListener
    extends SerializableConsumer<Visibility> {
    }

    public static enum Visibility {
        VISIBLE,
        VISIBLE_NON_FOCUSED,
        HIDDEN;

    }
}

