/*
 * #%L
 * JMexico :: Swing Editor
 * 
 * $Id: InputDesignEditorHandler.java 70 2012-06-25 12:36:31Z sletellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/jmexico/tags/jmexico-0.6/jmexico-editor/src/main/java/fr/reseaumexico/editor/InputDesignEditorHandler.java $
 * %%
 * Copyright (C) 2011 Réseau Mexico, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package fr.reseaumexico.editor;

import com.google.common.collect.Maps;
import fr.reseaumexico.model.Factor;
import fr.reseaumexico.model.InputDesign;
import fr.reseaumexico.model.Scenario;
import fr.reseaumexico.model.ScenarioImpl;
import java.util.Collection;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;

import static org.nuiton.i18n.I18n._;

/**
 * @author sletellier <letellier@codelutin.com>
 * @since 0.1
 */
public class InputDesignEditorHandler {

    public void addScenario(InputDesignEditor editor) {
        InputDesign inputDesign = editor.getInputDesign();

        String selectedName = JOptionPane.showInputDialog(editor,
                _("jmexico.scenario.inputName"),
                _("jmexico.scenario.inputName.title"),
                JOptionPane.QUESTION_MESSAGE);

        // if user enter name
        if (StringUtils.isNotBlank(selectedName)) {

            // check that name is never used
            Collection<Scenario> scenarios = inputDesign.getScenario();

            int maxOrder = 0;

            if (scenarios != null) {
                for (Scenario scenario : scenarios) {
                    if (selectedName.equalsIgnoreCase(scenario.getName())) {

                        JOptionPane.showMessageDialog(editor,
                                _("jmexico.error.title"),
                                _("jmexico.error.scenario.name.used"),
                                JOptionPane.ERROR_MESSAGE);

                        return;
                    }
                    int orderNumber = scenario.getOrderNumber();
                    if (maxOrder < orderNumber) {
                        maxOrder = orderNumber;
                    }
                }
            }

            // create new scenario
            Scenario scenarioToAdd = new ScenarioImpl();

            // set last order
            // TODO sletellier 20111219 : ask user order number
            scenarioToAdd.setOrderNumber(maxOrder + 1);

            // set name
            scenarioToAdd.setName(selectedName);

            // create all empty factor values
            Collection<Factor> factors = inputDesign.getExperimentDesign().getFactor();
            Map<Factor, Object> factorValues = Maps.newLinkedHashMap();
            for (Factor factor : factors) {
                factorValues.put(factor, null);
            }
            scenarioToAdd.setFactorValues(factorValues);

            inputDesign.addScenario(scenarioToAdd);
        }
    }

    public void removeScenario(InputDesignEditor editor) {
        InputDesign inputDesign = editor.getInputDesign();

        // show scenario select dialog
        Collection<Scenario> scenarios = inputDesign.getScenario();
        Scenario scenario = (Scenario) JOptionPane.showInputDialog(
                editor,
                _("jmexico.scenario.selectRemove"),
                _("jmexico.scenario.selectRemove.title"),
                JOptionPane.PLAIN_MESSAGE,
                null,
                scenarios.toArray(),
                null);

        // if scenario is selected
        if (scenario != null) {
            inputDesign.removeScenario(scenario);
        }
    }
}
