/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.formatter;

import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;

public abstract class Directive {
    private final Directive parent;
    private final String startDirective;
    private final String endDirective;

    public Directive(Directive parent, String startDirective, String endDirective) {
        this.parent = parent;
        this.startDirective = startDirective;
        this.endDirective = endDirective;
    }

    public String getStartDirective() {
        return this.startDirective;
    }

    public String getEndDirective() {
        return this.endDirective;
    }

    public abstract DirectiveType getType();

    public Directive getParent() {
        return this.parent;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[START_");
        s.append((Object)this.getType());
        s.append(": ");
        s.append(this.startDirective);
        s.append(", END_");
        s.append((Object)this.getType());
        s.append(": ");
        s.append(this.endDirective);
        return s.toString();
    }

    public static String formatDirective(String directive, String startNoParse, String endNoParse) {
        if (startNoParse != null) {
            return endNoParse + directive + startNoParse;
        }
        return directive;
    }

    public static String getStartNoParse(IDocumentFormatter formatter, FieldsMetadata fieldsMetadata) {
        if (Directive.isEvaluateEngineOnlyForFields(formatter, fieldsMetadata)) {
            return formatter.getStartNoParse();
        }
        return null;
    }

    public static String getEndNoParse(IDocumentFormatter formatter, FieldsMetadata fieldsMetadata) {
        if (Directive.isEvaluateEngineOnlyForFields(formatter, fieldsMetadata)) {
            return formatter.getEndNoParse();
        }
        return null;
    }

    public static boolean isEvaluateEngineOnlyForFields(IDocumentFormatter formatter, FieldsMetadata fieldsMetadata) {
        if (formatter == null) {
            return false;
        }
        return fieldsMetadata != null && fieldsMetadata.isEvaluateEngineOnlyForFields();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DirectiveType {
        LOOP,
        IF;

    }
}

