/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.maven.plugins.toolbox;

import fr.ird.observe.maven.plugins.toolbox.GenerateValidatorMojoSupport;
import fr.ird.observe.maven.plugins.toolbox.ValidatorsCache;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.TreeSet;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.nuiton.plugin.PluginHelper;

@Mojo(name="generate-i18n-validator-fields", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
class GenerateI18nValidatorFieldsMojo
extends GenerateValidatorMojoSupport {
    @Parameter(property="generateI18nValidatorFields.verbose", defaultValue="${maven.verbose}")
    private boolean verbose;
    @Parameter(property="generateI18nValidatorFields.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="generateI18nValidatorFields.packageName")
    private String packageName;
    @Parameter(property="generateI18nValidatorFields.className", defaultValue="I18nValidatorHelper", required=true)
    private String className;
    @Parameter(property="generateI18nValidatorFields.prefix")
    private String prefix;
    @Parameter(property="generateI18nValidatorFields.outputDirectory", defaultValue="${basedir}/target/generated-sources/java", required=true)
    private File outputDirectory;

    GenerateI18nValidatorFieldsMojo() {
    }

    @Override
    protected Path createOutputFile() throws IOException {
        if (this.packageName == null) {
            this.packageName = this.getProject().getGroupId() + "." + this.getProject().getArtifactId().replaceAll("-", ".");
        }
        Path directory = PluginHelper.getFile((File)this.outputDirectory, (String[])this.packageName.trim().split("\\.")).toPath();
        Files.createDirectories(directory, new FileAttribute[0]);
        return directory.resolve(this.className + ".java");
    }

    @Override
    protected boolean isSkip() {
        return this.skip;
    }

    public void doAction() throws Exception {
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("project = " + this.getProject()));
        }
        this.getLog().info((CharSequence)("Generate to " + this.getOutputFile()));
        List compileSourceRoots = this.getProject().getCompileSourceRoots();
        if (!compileSourceRoots.contains(this.outputDirectory.getAbsolutePath())) {
            this.getLog().info((CharSequence)("Add to compile source root: " + this.outputDirectory));
            this.getProject().addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
        TreeSet<String> fields = new TreeSet<String>();
        for (ValidatorsCache.ValidatorInfo validator : this.getValidators()) {
            fields.addAll(validator.getFields());
        }
        this.getLog().info((CharSequence)(fields.size() + " validator files(s) detected."));
        this.generate(this.packageName, this.className, this.prefix, fields, this.getOutputFile());
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

