/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.protocol.CaracteristicMappingRow;
import fr.ifremer.tutti.persistence.entities.protocol.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.protocol.MaturityCaracteristic;
import fr.ifremer.tutti.persistence.entities.protocol.OperationFieldMappingRow;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.Strata;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.TuttiDecorator;
import fr.ifremer.tutti.ui.swing.content.home.actions.CloneProtocolAction;
import fr.ifremer.tutti.ui.swing.content.home.actions.EditProtocolAction;
import fr.ifremer.tutti.ui.swing.content.home.actions.ImportProtocolAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchRowHelper;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolCaracteristicsRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolCaracteristicsTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolOperationFieldsRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolOperationFieldsTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.content.protocol.MandatorySampleCategoryColumnIdentifier;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorUI;
import fr.ifremer.tutti.ui.swing.content.protocol.rtp.RtpCellEditor;
import fr.ifremer.tutti.ui.swing.content.protocol.rtp.RtpCellRenderer;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.AvailableStratasTreeModel;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.ZonesTreeModel;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.node.StrataNode;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.JAXXWidgetUtil;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanDoubleListModel;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;
import org.nuiton.jaxx.application.swing.util.CloseableUI;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditProtocolUIHandler
extends AbstractTuttiUIHandler<EditProtocolUIModel, EditProtocolUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(EditProtocolUIHandler.class);
    protected SampleCategoryModel sampleCategoryModel;
    protected List<BeanDoubleList<Caracteristic>> allDoubleLists;
    private Multimap<TuttiLocation, TuttiLocation> programStratasAndSubstratas;

    public static String getTitle(boolean exist) {
        String result = exist ? I18n.t((String)"tutti.editProtocol.title.edit.protocol", (Object[])new Object[0]) : I18n.t((String)"tutti.editProtocol.title.create.protocol", (Object[])new Object[0]);
        return result;
    }

    public JXTable getSpeciesTable() {
        return ((EditProtocolUI)this.ui).getSpeciesTable();
    }

    public JXTable getBenthosTable() {
        return ((EditProtocolUI)this.ui).getBenthosTable();
    }

    public JXTable getCaracteristicsMappingTable() {
        return ((EditProtocolUI)this.ui).getCaracteristicsMappingTable();
    }

    public JXTable getOperationFieldsMappingTable() {
        return ((EditProtocolUI)this.ui).getOperationFieldsMappingTable();
    }

    public EditProtocolSpeciesTableModel getSpeciesTableModel() {
        return (EditProtocolSpeciesTableModel)((Object)this.getSpeciesTable().getModel());
    }

    public EditProtocolSpeciesTableModel getBenthosTableModel() {
        return (EditProtocolSpeciesTableModel)((Object)this.getBenthosTable().getModel());
    }

    public boolean isSpeciesSelected(Object selectedItem) {
        return selectedItem != null && selectedItem instanceof Species;
    }

    public EditProtocolCaracteristicsTableModel getCaracteristicMappingTableModel() {
        return (EditProtocolCaracteristicsTableModel)((Object)this.getCaracteristicsMappingTable().getModel());
    }

    public EditProtocolOperationFieldsTableModel getEditProtocolOperationFieldsMappingTableModel() {
        return (EditProtocolOperationFieldsTableModel)((Object)this.getOperationFieldsMappingTable().getModel());
    }

    public SwingValidator<EditProtocolUIModel> getValidator() {
        return ((EditProtocolUI)this.ui).getValidator();
    }

    public void beforeInit(EditProtocolUI ui) {
        super.beforeInit((ApplicationUI)ui);
        this.sampleCategoryModel = this.getContext().getDataContext().getSampleCategoryModel();
        this.incrementsMessage("Chargement des r\u00e9ferentiels");
        this.getDataContext().resetValidationDataContext();
        EditProtocolUIModel model = new EditProtocolUIModel();
        ArrayList<Species> allSpecies = new ArrayList<Species>(this.getDataContext().getSpecies());
        model.setAllSpecies(allSpecies);
        Multimap allSpeciesByTaxonId = Speciess.splitByReferenceTaxonId(allSpecies);
        model.setAllSpeciesByTaxonId((Multimap<String, Species>)allSpeciesByTaxonId);
        List referentSpecies = this.getDataContext().getReferentSpecies();
        Map allReferentSpeciesByTaxonId = Speciess.splitReferenceSpeciesByReferenceTaxonId((Iterable)referentSpecies);
        model.setAllReferentSpeciesByTaxonId(allReferentSpeciesByTaxonId);
        ArrayList<Caracteristic> caracteristics = new ArrayList<Caracteristic>(this.getDataContext().getCaracteristics());
        model.setCaracteristics(caracteristics);
        Map allCaracteristic = TuttiEntities.splitById(caracteristics);
        model.setAllCaracteristic(allCaracteristic);
        this.listModelIsModify(model);
        TuttiLocation programZone = this.getDataContext().getProgram().getZone();
        this.programStratasAndSubstratas = HashMultimap.create((Multimap)this.getPersistenceService().getAllFishingOperationStratasAndSubstratas(programZone.getId()));
        ImmutableMap.Builder locationLabelCacheBuilder = ImmutableMap.builder();
        this.programStratasAndSubstratas.keySet().forEach(strata -> {
            locationLabelCacheBuilder.put((Object)strata.getId(), (Object)strata.getLabel());
            this.programStratasAndSubstratas.get(strata).stream().filter(Objects::nonNull).forEach(subStrata -> locationLabelCacheBuilder.put((Object)subStrata.getId(), (Object)subStrata.getLabel()));
        });
        ImmutableMap locationLabelCache = locationLabelCacheBuilder.build();
        model.setLocationLabelCache((ImmutableMap<String, String>)locationLabelCache);
        model.addPropertyChangeListener("modifyingZones", evt -> {
            boolean newValue = (Boolean)evt.getNewValue();
            if (!newValue) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Ask to release zone trees caches and revalidate protocol.");
                }
                EditProtocolUIModel source = (EditProtocolUIModel)((Object)((Object)evt.getSource()));
                boolean stratasAvailable = source.getAvailableStratasTreeModel().isAvailableStratas();
                source.setAvailableStratas(stratasAvailable);
                this.getValidator().doValidate();
            }
        });
        ((EditProtocolUI)this.ui).setContextValue(model);
    }

    public void afterInit(EditProtocolUI ui) {
        MandatorySampleCategoryColumnIdentifier identifier;
        List<Object> benthosRows;
        List<Object> speciesRows;
        List<Object> operationFieldMappingRows;
        List<Object> caracteristicMappingRows;
        TuttiProtocol protocol;
        this.initUI(this.ui);
        EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        if (this.getContext().isProtocolFilled()) {
            this.incrementsMessage("Chargement du protocole");
            protocol = this.getDataContext().getProtocol();
            if (EditProtocolAction.CLEAN_PROTOCOL_ENTRY.getContextValue((JAXXContext)this.ui) != null) {
                protocol = (TuttiProtocol)EditProtocolAction.CLEAN_PROTOCOL_ENTRY.getContextValue((JAXXContext)this.ui);
                EditProtocolAction.CLEAN_PROTOCOL_ENTRY.removeContextValue((JAXXContext)this.ui);
                model.setCleaned(true);
                ((EditProtocolUI)this.ui).getSaveWarning().setText(I18n.t((String)"tutti.editProtocol.warn.clean", (Object[])new Object[0]));
            }
            model.fromEntity(protocol);
        } else {
            protocol = (TuttiProtocol)ImportProtocolAction.IMPORT_PROTOCOL_ENTRY.getContextValue((JAXXContext)this.ui);
            if (protocol != null) {
                this.incrementsMessage("Import du protocole");
                ImportProtocolAction.IMPORT_PROTOCOL_ENTRY.removeContextValue((JAXXContext)this.ui);
                model.fromEntity(protocol);
                model.setImported(true);
                ((EditProtocolUI)this.ui).getSaveWarning().setText(I18n.t((String)"tutti.editProtocol.warn.import", (Object[])new Object[0]));
            } else {
                protocol = (TuttiProtocol)CloneProtocolAction.CLONE_PROTOCOL_ENTRY.getContextValue((JAXXContext)this.ui);
                if (protocol != null) {
                    this.incrementsMessage("Clone du protocole");
                    CloneProtocolAction.CLONE_PROTOCOL_ENTRY.removeContextValue((JAXXContext)this.ui);
                    model.fromEntity(protocol);
                    model.setCloned(true);
                    ((EditProtocolUI)this.ui).getSaveWarning().setText(I18n.t((String)"tutti.editProtocol.warn.clone", (Object[])new Object[0]));
                } else {
                    this.incrementsMessage("Cr\u00e9ation d'un nouveau protocol");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Will create a new protocol");
                    }
                }
            }
        }
        if (model.getLengthClassesPmfmId() == null) {
            model.setLengthClassesPmfmId(Lists.newArrayList());
        }
        model.setProgramId(this.getDataContext().getProgramId());
        SwingValidator<EditProtocolUIModel> validator = ((EditProtocolUI)this.ui).getValidator();
        this.listenValidatorValid((SimpleBeanValidator)validator, model);
        this.registerValidators(validator);
        Collection<Species> referents = model.getAllReferentSpeciesByTaxonId().values();
        this.initBeanFilterableComboBox(((EditProtocolUI)this.ui).getSpeciesComboBox(), Lists.newArrayList(referents), null);
        this.initBeanFilterableComboBox(((EditProtocolUI)this.ui).getBenthosComboBox(), Lists.newArrayList(referents), null);
        this.initBeanFilterableComboBox(ui.getCaracteristicMappingComboBox(), new ArrayList<Caracteristic>(model.getCaracteristics()), null);
        model.addPropertyChangeListener("importColumns", evt -> this.populateImportColumnTableEditors());
        this.incrementsMessage("Pr\u00e9paration des interfaces graphiques");
        ArrayList<CalcifiedPiecesSamplingEditorRowModel> cpsRows = new ArrayList<CalcifiedPiecesSamplingEditorRowModel>();
        if (protocol == null) {
            caracteristicMappingRows = Lists.newArrayList();
            operationFieldMappingRows = Lists.newArrayList();
            speciesRows = Lists.newArrayList();
            benthosRows = Lists.newArrayList();
        } else {
            caracteristicMappingRows = this.toProtocolCaracteristicRows(protocol.getCaracteristicMapping());
            operationFieldMappingRows = this.toProtocolOperationFieldsRows(protocol.getOperationFieldMapping());
            speciesRows = this.toSpeciesRows(protocol.getSpecies(), cpsRows);
            benthosRows = this.toSpeciesRows(protocol.getBenthos(), cpsRows);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will edit protocol with " + speciesRows.size() + " protocolSpecies and " + benthosRows.size() + " benthos declared."));
            }
        }
        cpsRows.sort(CalcifiedPiecesSamplingEditorRowModel.COMPARATOR);
        ((EditProtocolUIModel)((Object)this.getModel())).setCpsRows(cpsRows);
        model.setSpeciesRow((List<EditProtocolSpeciesRowModel>)speciesRows);
        model.setBenthosRow((List<EditProtocolSpeciesRowModel>)benthosRows);
        model.setCaracteristicMappingRows(caracteristicMappingRows);
        model.setOperationFieldMappingRows(operationFieldMappingRows);
        ((EditProtocolUI)this.ui).getSpeciesComboBox().reset();
        ((EditProtocolUI)this.ui).getBenthosComboBox().reset();
        ((EditProtocolUI)this.ui).getCaracteristicMappingComboBox().reset();
        JXTable table = this.getSpeciesTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        TableColumnExt speciesColumn = this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Species.class), EditProtocolSpeciesTableModel.SPECIES_ID);
        speciesColumn.setSortable(true);
        DecoratorService.SpeciesDecorator speciesDecorator = new DecoratorService.SpeciesDecorator();
        speciesColumn.putClientProperty((Object)"decorator", (Object)speciesDecorator);
        speciesColumn.setCellRenderer(this.newTableCellRender((Decorator)speciesDecorator));
        TableColumnExt speciesSurveyCodeColumn = this.addColumnToModel((TableColumnModel)columnModel, null, null, EditProtocolSpeciesTableModel.SURVEY_CODE_ID);
        speciesSurveyCodeColumn.setSortable(true);
        this.addLengthClassesColumnToModel((TableColumnModel)columnModel, model.getLengthClassesPmfmId());
        this.addMaturityColumnToModel((TableColumnModel)columnModel, model.getMaturityPmfmId());
        this.addCpsPmfmColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.CALCIFIED_PIECES_SAMPLING_TYPE_PMFM_ID);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.WEIGHT_ENABLED, (JTable)table);
        for (SampleCategoryModelEntry sampleCategoryModelEntry : this.sampleCategoryModel.getCategory()) {
            if (sampleCategoryModelEntry.getOrder() == 0) continue;
            identifier = MandatorySampleCategoryColumnIdentifier.newId("mandatorySampleCategoryId", sampleCategoryModelEntry.getCategoryId(), sampleCategoryModelEntry.getLabel(), sampleCategoryModelEntry.getLabel());
            this.addBooleanColumnToModel((TableColumnModel)columnModel, identifier, (JTable)table);
        }
        this.addIndividualObservationColumnToModel(columnModel, table);
        this.addColumnToModel((TableColumnModel)columnModel, RtpCellEditor.newEditor(ui), new RtpCellRenderer(), EditProtocolSpeciesTableModel.USE_RTP);
        this.initTable(table, columnModel, speciesColumn, EditProtocolSpeciesTableModel.USE_RTP, speciesRows, e -> {
            ListSelectionModel source = (ListSelectionModel)e.getSource();
            ((EditProtocolUIModel)((Object)((Object)this.getModel()))).setRemoveSpeciesEnabled(!source.isSelectionEmpty());
        });
        table = this.getBenthosTable();
        columnModel = new DefaultTableColumnModelExt();
        speciesColumn = this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Species.class), EditProtocolSpeciesTableModel.SPECIES_ID);
        speciesColumn.setSortable(true);
        speciesDecorator = new DecoratorService.SpeciesDecorator();
        speciesColumn.putClientProperty((Object)"decorator", (Object)speciesDecorator);
        speciesColumn.setCellRenderer(this.newTableCellRender((Decorator)speciesDecorator));
        speciesSurveyCodeColumn = this.addColumnToModel((TableColumnModel)columnModel, null, null, EditProtocolSpeciesTableModel.SURVEY_CODE_ID);
        speciesSurveyCodeColumn.setSortable(true);
        this.addLengthClassesColumnToModel((TableColumnModel)columnModel, model.getLengthClassesPmfmId());
        this.addMaturityColumnToModel((TableColumnModel)columnModel, model.getMaturityPmfmId());
        this.addCpsPmfmColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.CALCIFIED_PIECES_SAMPLING_TYPE_PMFM_ID);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.WEIGHT_ENABLED, (JTable)table);
        for (SampleCategoryModelEntry sampleCategoryModelEntry : this.sampleCategoryModel.getCategory()) {
            if (sampleCategoryModelEntry.getOrder() == 0) continue;
            identifier = MandatorySampleCategoryColumnIdentifier.newId("mandatorySampleCategoryId", sampleCategoryModelEntry.getCategoryId(), sampleCategoryModelEntry.getLabel(), sampleCategoryModelEntry.getLabel());
            this.addBooleanColumnToModel((TableColumnModel)columnModel, identifier, (JTable)table);
        }
        this.addIndividualObservationColumnToModel(columnModel, table);
        this.addColumnToModel((TableColumnModel)columnModel, RtpCellEditor.newEditor(ui), new RtpCellRenderer(), EditProtocolSpeciesTableModel.USE_RTP);
        this.initTable(table, columnModel, speciesColumn, EditProtocolSpeciesTableModel.USE_RTP, benthosRows, e -> {
            ListSelectionModel source = (ListSelectionModel)e.getSource();
            ((EditProtocolUIModel)((Object)((Object)this.getModel()))).setRemoveBenthosEnabled(!source.isSelectionEmpty());
        });
        BeanDoubleList<Caracteristic> maturityList = ((EditProtocolUI)this.ui).getMaturityList();
        this.allDoubleLists = Lists.newArrayList((Object[])new BeanDoubleList[]{((EditProtocolUI)this.ui).getLengthClassesList(), ((EditProtocolUI)this.ui).getIndividualObservationList(), maturityList});
        this.initDoubleList("lengthClassesPmfmId", ((EditProtocolUI)this.ui).getLengthClassesList(), Lists.newArrayList(model.getCaracteristics()), model.getLengthClassesPmfmId());
        this.initDoubleList("individualObservationPmfmId", ((EditProtocolUI)this.ui).getIndividualObservationList(), Lists.newArrayList(model.getCaracteristics()), model.getIndividualObservationPmfmId());
        this.initDoubleList("maturityPmfmId", maturityList, model.getCaracteristics().stream().filter(caracteristic -> !caracteristic.isQualitativeValueEmpty()).collect(Collectors.toList()), model.getMaturityPmfmId());
        JMenuItem editMaturity = ui.getEditMaturityCaracteristicAction();
        maturityList.getSelectedListPopup().add(editMaturity);
        JList maturitySelectedList = maturityList.getSelectedList();
        maturitySelectedList.addListSelectionListener(e -> {
            boolean editMaturityEnabled = maturitySelectedList.getSelectedIndices().length == 1;
            editMaturity.setEnabled(editMaturityEnabled);
        });
        ListCellRenderer defaultRenderer = maturitySelectedList.getCellRenderer();
        maturitySelectedList.setCellRenderer(new MaturityCaracteristicCellRenderer(defaultRenderer));
        JXTable caracteristicsMappingTable = this.getCaracteristicsMappingTable();
        DefaultTableColumnModelExt columnModel2 = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)columnModel2, null, this.newTableCellRender(Caracteristic.class), EditProtocolCaracteristicsTableModel.PSFM_ID);
        this.addComboDataColumnToModel((TableColumnModel)columnModel2, EditProtocolCaracteristicsTableModel.TYPE, this.getDecorator(CaracteristicType.class, null), Lists.newArrayList((Object[])CaracteristicType.getTabTypes()));
        this.addColumnToModel((TableColumnModel)columnModel2, EditProtocolCaracteristicsTableModel.IMPORT_FILE_COLUMN);
        ArrayList<Caracteristic> caracteristics = new ArrayList<Caracteristic>(((EditProtocolUIModel)((Object)this.getModel())).getCaracteristics());
        EditProtocolCaracteristicsTableModel tableModel = new EditProtocolCaracteristicsTableModel((TableColumnModelExt)columnModel2, caracteristics);
        caracteristicsMappingTable.setModel((TableModel)((Object)tableModel));
        caracteristicsMappingTable.setColumnModel((TableColumnModel)columnModel2);
        caracteristicsMappingTable.getTableHeader().setReorderingAllowed(false);
        this.addHighlighters(caracteristicsMappingTable);
        caracteristicsMappingTable.getSelectionModel().addListSelectionListener(e -> {
            int rowIndex = this.getCaracteristicsMappingTable().getSelectedRow();
            boolean enableRemoveCaracteristicMapping = false;
            boolean enableMoveUpCaracteristicMapping = false;
            boolean enableMoveDownCaracteristicMapping = false;
            if (rowIndex != -1) {
                enableRemoveCaracteristicMapping = true;
                enableMoveUpCaracteristicMapping = rowIndex > 0;
                enableMoveDownCaracteristicMapping = rowIndex < this.getCaracteristicsMappingTable().getModel().getRowCount() - 1;
            }
            EditProtocolUIModel model1 = (EditProtocolUIModel)((Object)((Object)this.getModel()));
            model1.setRemoveCaracteristicMappingEnabled(enableRemoveCaracteristicMapping);
            model1.setMoveUpCaracteristicMappingEnabled(enableMoveUpCaracteristicMapping);
            model1.setMoveDownCaracteristicMappingEnabled(enableMoveDownCaracteristicMapping);
        });
        SwingUtil.scrollToTableSelection((JTable)caracteristicsMappingTable);
        tableModel.setRows(caracteristicMappingRows);
        JXTable operationFieldsTable = ((EditProtocolUI)this.getUI()).getOperationFieldsMappingTable();
        columnModel2 = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)columnModel2, null, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setText(I18n.t((String)("tutti.editFishingOperation.field." + value.toString()), (Object[])new Object[0]));
                return this;
            }
        }, EditProtocolOperationFieldsTableModel.FIELD);
        this.addColumnToModel((TableColumnModel)columnModel2, EditProtocolOperationFieldsTableModel.IMPORT_FILE_COLUMN);
        EditProtocolOperationFieldsTableModel tableModel2 = new EditProtocolOperationFieldsTableModel((TableColumnModelExt)columnModel2);
        operationFieldsTable.setModel((TableModel)((Object)tableModel2));
        operationFieldsTable.setColumnModel((TableColumnModel)columnModel2);
        operationFieldsTable.getTableHeader().setReorderingAllowed(false);
        this.addHighlighters(operationFieldsTable);
        tableModel2.setRows(operationFieldMappingRows);
        SwingUtil.scrollToTableSelection((JTable)operationFieldsTable);
        this.populateImportColumnTableEditors();
        this.initZonesTree();
        this.initAvailableStratasTree();
        model.setModify(model.isCreate() || model.isCleaned());
        ((EditProtocolUI)this.ui).getCaracteristicPane().addChangeListener(e -> {
            BeanDoubleList<Caracteristic> selectedDoubleList;
            JTabbedPane tabPanel = (JTabbedPane)e.getSource();
            int selectedIndex = tabPanel.getSelectedIndex();
            log.debug((Object)("selected " + selectedIndex));
            switch (selectedIndex) {
                case 0: {
                    selectedDoubleList = ((EditProtocolUI)this.ui).getLengthClassesList();
                    break;
                }
                case 1: {
                    selectedDoubleList = ((EditProtocolUI)this.ui).getIndividualObservationList();
                    break;
                }
                case 2: {
                    selectedDoubleList = ((EditProtocolUI)this.ui).getMaturityList();
                    break;
                }
                default: {
                    selectedDoubleList = null;
                }
            }
            if (selectedDoubleList != null) {
                selectedDoubleList.getHandler().refreshFilteredElements();
            } else {
                ArrayList<Caracteristic> selectedCaracteristics = new ArrayList<Caracteristic>(((EditProtocolUIModel)((Object)((Object)this.getModel()))).getCaracteristics());
                for (BeanDoubleList<Caracteristic> doubleList : this.allDoubleLists) {
                    selectedCaracteristics.removeAll(doubleList.getModel().getSelected());
                }
                selectedCaracteristics.removeAll(((EditProtocolUIModel)((Object)((Object)this.getModel()))).getUsedCaracteristics());
                ((EditProtocolUI)this.getUI()).getCaracteristicMappingComboBox().setData(selectedCaracteristics);
            }
        });
        ((EditProtocolUI)this.ui).getTabPanel().addChangeListener(e -> {
            JTabbedPane tabPanel = (JTabbedPane)e.getSource();
            int selectedIndex = tabPanel.getSelectedIndex();
            if (log.isDebugEnabled()) {
                log.debug((Object)("New tab selected: " + selectedIndex));
            }
            if (selectedIndex == 4) {
                List<EditProtocolSpeciesRowModel> benthosRows1;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Update species list on calcifiedPiecesSamplingEditorUI model.");
                }
                CalcifiedPiecesSamplingEditorUI calcifiedPiecesSamplingEditorUI = ((EditProtocolUI)this.getUI()).getCalcifiedPiecesSamplingEditorUI();
                ArrayList protocolSpecies = new ArrayList();
                List<EditProtocolSpeciesRowModel> speciesRows1 = ((EditProtocolUIModel)((Object)((Object)this.getModel()))).getSpeciesRow();
                if (speciesRows1 != null) {
                    protocolSpecies.addAll(speciesRows1.stream().filter(EditProtocolSpeciesRowModel::withLengthStepPmfm).map(EditProtocolSpeciesRowModel::toSpeciesWithSurveyCode).collect(Collectors.toList()));
                }
                if ((benthosRows1 = ((EditProtocolUIModel)((Object)((Object)this.getModel()))).getBenthosRow()) != null) {
                    protocolSpecies.addAll(benthosRows1.stream().filter(EditProtocolSpeciesRowModel::withLengthStepPmfm).map(EditProtocolSpeciesRowModel::toSpeciesWithSurveyCode).collect(Collectors.toList()));
                }
                protocolSpecies.removeAll(((EditProtocolUIModel)((Object)((Object)this.getModel()))).getCpsRows().stream().map(CalcifiedPiecesSamplingEditorRowModel::getProtocolSpecies).map(EditProtocolSpeciesRowModel::getSpecies).collect(Collectors.toList()));
                calcifiedPiecesSamplingEditorUI.getSpeciesComboBox().setData(null);
                calcifiedPiecesSamplingEditorUI.getSpeciesComboBox().setData(protocolSpecies);
            }
        });
        model.setVersion(TuttiProtocols.CURRENT_PROTOCOL_VERSION);
    }

    protected void addIndividualObservationColumnToModel(DefaultTableColumnModelExt columnModel, final JXTable table) {
        TableCellRenderer renderer = new TableCellRenderer(){
            TableCellRenderer delegate;
            {
                this.delegate = table.getDefaultRenderer(Boolean.class);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component result = this.delegate.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
                result.setEnabled(table2.isCellEditable(row, column));
                return result;
            }
        };
        this.addColumnToModel((TableColumnModel)columnModel, table.getDefaultEditor(Boolean.class), renderer, EditProtocolSpeciesTableModel.INDIVIDUAL_OBSERVATION_ENABLED);
    }

    protected void initZonesTree() {
        final EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        ZonesTreeModel zonesTreeModel = model.getZonesTreeModel();
        zonesTreeModel.setCreatingModel(true);
        try {
            model.getIncomingZones().forEach(zonesTreeModel::addZone);
        }
        finally {
            zonesTreeModel.setCreatingModel(false);
        }
        zonesTreeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                model.setModify(true);
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                ((EditProtocolUI)EditProtocolUIHandler.this.getUI()).getZoneEditor().getZonesTree().expandPath(e.getTreePath());
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
        this.initJTree(((EditProtocolUI)this.ui).getZoneEditor().getZonesTree());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initAvailableStratasTree() {
        EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        LinkedHashSet usedStrataLocations = new LinkedHashSet();
        LinkedHashSet usedSubStrataLocations = new LinkedHashSet();
        model.getIncomingZones().forEach(zone -> {
            Collection zoneStratas = zone.getStrata();
            Set strataLocations = zoneStratas.stream().map(TuttiEntity::getId).collect(Collectors.toSet());
            usedStrataLocations.addAll(strataLocations);
            Set subStrataLocations = zoneStratas.stream().map(Strata::getSubstrata).flatMap(Collection::stream).map(TuttiEntity::getId).collect(Collectors.toSet());
            usedSubStrataLocations.addAll(subStrataLocations);
        });
        AvailableStratasTreeModel availableStratasTreeModel = model.getAvailableStratasTreeModel();
        availableStratasTreeModel.setCreatingModel(true);
        try {
            this.programStratasAndSubstratas.keySet().stream().forEach(strataLocation -> {
                String strataId = strataLocation.getId();
                HashSet subStrataLocations = new HashSet(this.programStratasAndSubstratas.get(strataLocation));
                subStrataLocations.remove(null);
                List<String> subStratas = subStrataLocations.stream().map(TuttiEntity::getId).filter(id -> !usedSubStrataLocations.contains(id)).collect(Collectors.toList());
                if (!subStratas.isEmpty() || !usedStrataLocations.contains(strataLocation.getId())) {
                    StrataNode strataNode = availableStratasTreeModel.getOrCreateStrataNode(strataId);
                    subStratas.forEach(subStrataId -> availableStratasTreeModel.addSubsStrata(strataNode, (String)subStrataId));
                }
            });
        }
        finally {
            availableStratasTreeModel.setCreatingModel(false);
        }
        this.initJTree(((EditProtocolUI)this.ui).getZoneEditor().getAvailableStratasTree());
    }

    protected JComponent getComponentToFocus() {
        return ((EditProtocolUI)this.getUI()).getNameField();
    }

    public List<EditProtocolSpeciesRowModel> toSpeciesRows(List<SpeciesProtocol> speciesProtocols) {
        return this.toSpeciesRows(speciesProtocols, ((EditProtocolUIModel)((Object)this.getModel())).getCpsRows());
    }

    public List<EditProtocolSpeciesRowModel> toSpeciesRows(List<SpeciesProtocol> speciesProtocols, List<CalcifiedPiecesSamplingEditorRowModel> cpsRows) {
        BeanFilterableComboBox<Species> speciesComboBox = ((EditProtocolUI)this.ui).getSpeciesComboBox();
        Preconditions.checkNotNull((Object)speciesComboBox.getData());
        BeanFilterableComboBox<Species> benthosComboBox = ((EditProtocolUI)this.ui).getBenthosComboBox();
        Preconditions.checkNotNull((Object)benthosComboBox.getData());
        EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        Map<String, Species> allReferentSpeciesByTaxonId = model.getAllReferentSpeciesByTaxonId();
        Map<String, Caracteristic> allCaracteristic = model.getAllCaracteristic();
        ArrayList lengthClassesPmfmId = Lists.newArrayList();
        HashSet speciesSet = Sets.newHashSet();
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(speciesProtocols)) {
            for (SpeciesProtocol speciesProtocol : speciesProtocols) {
                Integer taxonId = speciesProtocol.getSpeciesReferenceTaxonId();
                if (taxonId == null) continue;
                String taxonIdStr = String.valueOf(taxonId);
                Collection<Species> allSynonyms = model.getAllSynonyms(taxonIdStr);
                model.getAllSynonyms().removeAll(allSynonyms);
                Species species = allReferentSpeciesByTaxonId.get(taxonIdStr);
                Preconditions.checkNotNull((Object)species, (Object)("Esp\u00e8ce inconnue : " + taxonIdStr));
                speciesSet.add(species);
                EditProtocolSpeciesRowModel row = this.createNewProtocolSpeciesRow();
                row.setSpecies(species);
                String lengthStepPmfmId = speciesProtocol.getLengthStepPmfmId();
                Caracteristic lengthStepPmfm = allCaracteristic.get(lengthStepPmfmId);
                if (lengthStepPmfmId != null && !lengthClassesPmfmId.contains(lengthStepPmfm) && !model.containsLengthClassesPmfmId(lengthStepPmfmId)) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Found a new lengthStep pmfm: " + lengthStepPmfmId));
                    }
                    lengthClassesPmfmId.add(lengthStepPmfm);
                }
                row.setLengthStepPmfm(lengthStepPmfm);
                String maturityPmfmId = speciesProtocol.getMaturityPmfmId();
                Caracteristic maturityPmfm = allCaracteristic.get(maturityPmfmId);
                row.setMaturityPmfm(maturityPmfm);
                row.fromEntity(speciesProtocol);
                row.setMandatorySampleCategoryId(Lists.newArrayList((Iterable)speciesProtocol.getMandatorySampleCategoryId()));
                result.add(row);
                Collection cpsDefs = speciesProtocol.getCalcifiedPiecesSamplingDefinition();
                if (cpsDefs == null) continue;
                cpsDefs.forEach(def -> {
                    CalcifiedPiecesSamplingEditorRowModel cpsRow = new CalcifiedPiecesSamplingEditorRowModel();
                    cpsRow.fromEntity(def);
                    cpsRow.setProtocolSpecies(row);
                    cpsRow.setValid(true);
                    cpsRows.add(cpsRow);
                });
            }
            speciesComboBox.removeItems((Iterable)speciesSet);
            benthosComboBox.removeItems((Iterable)speciesSet);
        }
        if (CollectionUtils.isNotEmpty((Collection)lengthClassesPmfmId)) {
            model.addAllLengthClassesPmfmId(TuttiEntities.collecIds((List)lengthClassesPmfmId));
            BeanDoubleList<Caracteristic> lengthClassesList = ((EditProtocolUI)this.ui).getLengthClassesList();
            lengthClassesList.getModel().addToSelected((List)lengthClassesPmfmId);
        }
        return result;
    }

    public EditProtocolSpeciesRowModel createNewProtocolSpeciesRow() {
        EditProtocolSpeciesRowModel result = EditProtocolSpeciesTableModel.newRow(this.sampleCategoryModel);
        result.addPropertyChangeListener("lengthStepPmfm", evt -> {
            Caracteristic newValue = (Caracteristic)evt.getNewValue();
            if (newValue == null) {
                List<CalcifiedPiecesSamplingEditorRowModel> speciesCpsRows;
                result.setIndividualObservationEnabled(false);
                if (((EditProtocolUIModel)((Object)((Object)this.getModel()))).getCpsRows() != null && !(speciesCpsRows = ((EditProtocolUIModel)((Object)((Object)this.getModel()))).getCpsRows().stream().filter(row -> ((Object)((Object)row.getProtocolSpecies())).equals((Object)result)).collect(Collectors.toList())).isEmpty()) {
                    boolean deleteCpsRows;
                    String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.editProtocol.action.removeLengthStepPmfm.removeCpsRows.message", (Object[])new Object[0]), I18n.t((String)"jaxx.application.common.askBeforeDelete.help", (Object[])new Object[0]));
                    int i = JOptionPane.showConfirmDialog((Component)this.getUI(), htmlMessage, I18n.t((String)"tutti.editProtocol.action.removeLengthStepPmfm.removeCpsRows.title", (Object[])new Object[0]), 2, 3);
                    boolean bl = deleteCpsRows = i == 0;
                    if (deleteCpsRows) {
                        this.deleteCpsRows(speciesCpsRows);
                    } else {
                        result.setLengthStepPmfm((Caracteristic)evt.getOldValue());
                    }
                }
            }
        });
        return result;
    }

    public void deleteCpsRows(Collection<CalcifiedPiecesSamplingEditorRowModel> cpsRowsToDelete) {
        CalcifiedPiecesSamplingEditorUI cpsEditor = ((EditProtocolUI)this.getUI()).getCalcifiedPiecesSamplingEditorUI();
        List<CalcifiedPiecesSamplingEditorRowModel> cpsRows = ((EditProtocolUIModel)((Object)this.getModel())).getCpsRows();
        TreeSet indexesToDelete = new TreeSet(cpsRowsToDelete.stream().map(cpsRows::indexOf).collect(Collectors.toSet()));
        cpsRows.removeAll(cpsRowsToDelete);
        CalcifiedPiecesSamplingEditorTableModel cpsTableModel = (CalcifiedPiecesSamplingEditorTableModel)((Object)cpsEditor.getCpsTable().getModel());
        cpsTableModel.fireTableRowsDeleted((Integer)indexesToDelete.first(), (Integer)indexesToDelete.last());
    }

    public List<EditProtocolCaracteristicsRowModel> toProtocolCaracteristicRows(List<CaracteristicMappingRow> caracteristicMappingRows) {
        BeanFilterableComboBox<Caracteristic> caracteristicMappingComboBox = ((EditProtocolUI)this.ui).getCaracteristicMappingComboBox();
        Preconditions.checkNotNull((Object)caracteristicMappingComboBox.getData());
        EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        HashSet caracteristicSet = Sets.newHashSet();
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(caracteristicMappingRows)) {
            for (CaracteristicMappingRow caracteristicMappingRow : caracteristicMappingRows) {
                String pmfmId = caracteristicMappingRow.getPmfmId();
                if (pmfmId == null) continue;
                caracteristicSet.add(model.getAllCaracteristic().get(pmfmId));
                EditProtocolCaracteristicsRowModel row = this.createEditProtocolCaracteristicsRowModel();
                row.fromEntity(caracteristicMappingRow);
                row.setValid(row.getType() != null);
                result.add(row);
            }
            caracteristicMappingComboBox.removeItems((Iterable)caracteristicSet);
        }
        return result;
    }

    public List<EditProtocolOperationFieldsRowModel> toProtocolOperationFieldsRows(Collection<OperationFieldMappingRow> operationFieldMappingRows) {
        ArrayList result = Lists.newArrayList();
        if (operationFieldMappingRows == null) {
            operationFieldMappingRows = new ArrayList<OperationFieldMappingRow>();
        }
        ImmutableMap rowsByField = Maps.uniqueIndex(operationFieldMappingRows, OperationFieldMappingRow::getField);
        I18n.n((String)"tutti.editFishingOperation.field.gearShootingStartDay", (Object[])new Object[0]);
        I18n.n((String)"tutti.editFishingOperation.field.gearShootingStartTime", (Object[])new Object[0]);
        I18n.n((String)"tutti.editFishingOperation.field.gearShootingEndDay", (Object[])new Object[0]);
        I18n.n((String)"tutti.editFishingOperation.field.gearShootingEndTime", (Object[])new Object[0]);
        ArrayList properties = Lists.newArrayList((Object[])new String[]{"stationNumber", "fishingOperationNumber", "gearShootingStartDay", "gearShootingStartTime", "gearShootingStartLatitude", "gearShootingStartLongitude", "gearShootingEndDay", "gearShootingEndTime", "gearShootingEndLatitude", "gearShootingEndLongitude", "fishingOperationRectiligne", "trawlDistance", "fishingOperationValid", "multirigAggregation", "recorderPerson", "gear", "vessel", "strata", "subStrata", "location", "secondaryVessel"});
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            String property;
            OperationFieldMappingRow row = (OperationFieldMappingRow)rowsByField.get(property = (String)iterator.next());
            EditProtocolOperationFieldsRowModel newRow = this.createOperationFieldRow(property, row != null ? row.getImportColumn() : null);
            result.add(newRow);
        }
        return result;
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.clearValidators();
        ((EditProtocolUI)this.ui).getTabPanel().setSelectedIndex(0);
        this.closeUI(((EditProtocolUI)this.ui).getRtpEditorUI());
        this.closeUI(((EditProtocolUI)this.ui).getZoneEditor());
    }

    public boolean quitUI() {
        return this.quitScreen(((EditProtocolUIModel)((Object)this.getModel())).isValid(), ((EditProtocolUIModel)((Object)this.getModel())).isModify(), I18n.t((String)"tutti.editProtocol.askCancelEditBeforeLeaving.cancelSaveProtocol", (Object[])new Object[0]), I18n.t((String)"tutti.editProtocol.askSaveBeforeLeaving.saveProtocol", (Object[])new Object[0]), ((EditProtocolUI)this.ui).getSaveButton().getAction());
    }

    public void addDoubleListListeners() {
        EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        for (BeanDoubleList<Caracteristic> list : this.allDoubleLists) {
            String id = (String)list.getClientProperty((Object)"_updateListenerId");
            UpdateSelectedList updateListener = (UpdateSelectedList)list.getClientProperty((Object)"_updateListener");
            model.addPropertyChangeListener(id, updateListener);
        }
    }

    public void removeDoubleListListeners() {
        EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        for (BeanDoubleList<Caracteristic> list : this.allDoubleLists) {
            String id = (String)list.getClientProperty((Object)"_updateListenerId");
            UpdateSelectedList updateListener = (UpdateSelectedList)list.getClientProperty((Object)"_updateListener");
            model.removePropertyChangeListener(id, updateListener);
        }
    }

    public EditProtocolCaracteristicsRowModel createEditProtocolCaracteristicsRowModel() {
        EditProtocolCaracteristicsRowModel newRow = new EditProtocolCaracteristicsRowModel(((EditProtocolUIModel)((Object)this.getModel())).getCaracteristics());
        newRow.addPropertyChangeListener(evt -> {
            EditProtocolCaracteristicsRowModel row = (EditProtocolCaracteristicsRowModel)((Object)((Object)evt.getSource()));
            EditProtocolUIModel model = (EditProtocolUIModel)((Object)((Object)this.getModel()));
            if ("importColumn".equals(evt.getPropertyName())) {
                String newValue;
                String oldValue = (String)evt.getOldValue();
                if (oldValue != null) {
                    model.decNumberOfRows(oldValue);
                }
                if ((newValue = (String)evt.getNewValue()) != null) {
                    model.incNumberOfRows(newValue);
                }
                this.recomputeRowsValidState();
            } else {
                row.setValid(this.isCaracteristicsRowValid(row));
            }
            if (row.isValid()) {
                model.setModify(true);
            }
        });
        return newRow;
    }

    protected void initDoubleList(String propertyId, BeanDoubleList<Caracteristic> widget, List<Caracteristic> availableCaracteristics, List<String> selectedCaracteristics) {
        this.initBeanList(widget, availableCaracteristics, Lists.newArrayList());
        UpdateSelectedList listener = new UpdateSelectedList(widget, ((EditProtocolUIModel)((Object)this.getModel())).getAllCaracteristic());
        widget.putClientProperty((Object)"_updateListener", (Object)listener);
        widget.putClientProperty((Object)"_updateListenerId", (Object)propertyId);
        listener.select(selectedCaracteristics);
        ArrayList list = Lists.newArrayList(this.allDoubleLists);
        list.remove(widget);
        widget.getHandler().addFilter((Predicate)new SelectValuePredicate(list));
        widget.getHandler().addFilter(caracteristic -> !((EditProtocolUIModel)((Object)((Object)this.getModel()))).isCaracteristicUsedInMapping((Caracteristic)caracteristic));
        widget.getHandler().sortData();
    }

    protected void selectCaracteristics(List<String> ids, JComboBox comboBox) {
        ArrayList dataToList;
        Map<String, Caracteristic> allCaracteristic = ((EditProtocolUIModel)((Object)this.getModel())).getAllCaracteristic();
        ArrayList selection = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(ids)) {
            for (String id : ids) {
                selection.add(allCaracteristic.get(id));
            }
        }
        if (!(dataToList = Lists.newArrayList((Iterable)selection)).isEmpty() && dataToList.get(0) != null) {
            dataToList.add(0, null);
        }
        SwingUtil.fillComboBox((JComboBox)comboBox, (Collection)dataToList, null);
    }

    protected void addLengthClassesColumnToModel(TableColumnModel model, List<String> selectedIds) {
        Decorator<Caracteristic> decorator = this.getDecorator(Caracteristic.class, null);
        JComboBox comboBox = new JComboBox();
        ((EditProtocolUIModel)((Object)this.getModel())).addPropertyChangeListener("lengthClassesPmfmId", evt -> {
            List ids = (List)evt.getNewValue();
            this.selectCaracteristics(ids, comboBox);
        });
        comboBox.setRenderer(this.newListCellRender(decorator));
        this.selectCaracteristics(selectedIds, comboBox);
        ObjectToStringConverter converter = BeanUIUtil.newDecoratedObjectToStringConverter(decorator);
        BeanUIUtil.decorate(comboBox, (ObjectToStringConverter)converter);
        ComboBoxCellEditor editor = new ComboBoxCellEditor(comboBox);
        this.addColumnToModel(model, (TableCellEditor)editor, this.newTableCellRender(decorator), EditProtocolSpeciesTableModel.LENGTH_STEP_PMFM_ID);
    }

    protected void addMaturityColumnToModel(TableColumnModel model, List<String> selectedIds) {
        Decorator<Caracteristic> decorator = this.getDecorator(Caracteristic.class, null);
        JComboBox comboBox = new JComboBox();
        ((EditProtocolUIModel)((Object)this.getModel())).addPropertyChangeListener("maturityPmfmId", evt -> {
            List ids = (List)evt.getNewValue();
            this.selectCaracteristics(ids, comboBox);
        });
        comboBox.setRenderer(this.newListCellRender(decorator));
        this.selectCaracteristics(selectedIds, comboBox);
        ObjectToStringConverter converter = BeanUIUtil.newDecoratedObjectToStringConverter(decorator);
        BeanUIUtil.decorate(comboBox, (ObjectToStringConverter)converter);
        ComboBoxCellEditor editor = new ComboBoxCellEditor(comboBox);
        this.addColumnToModel(model, (TableCellEditor)editor, this.newTableCellRender(decorator), EditProtocolSpeciesTableModel.MATURITY_PMFM_ID);
    }

    protected void addCpsPmfmColumnToModel(TableColumnModel model, ColumnIdentifier<EditProtocolSpeciesRowModel> column) {
        Decorator<CaracteristicQualitativeValue> caracteristicQualitativeValueDecorator = this.getDecorator(CaracteristicQualitativeValue.class, null);
        this.addComboDataColumnToModel(model, EditProtocolSpeciesTableModel.CALCIFIED_PIECES_SAMPLING_TYPE_PMFM_ID, caracteristicQualitativeValueDecorator, this.getDataContext().getCpsTypeValues());
    }

    protected void initTable(JXTable table, DefaultTableColumnModelExt columnModel, TableColumnExt speciesColumn, ColumnIdentifier rtpIdentifier, List<EditProtocolSpeciesRowModel> rows, ListSelectionListener selectionListener) {
        EditProtocolSpeciesTableModel tableModel = new EditProtocolSpeciesTableModel(this.sampleCategoryModel, (TableColumnModelExt)columnModel);
        table.setModel((TableModel)((Object)tableModel));
        table.setColumnModel((TableColumnModel)columnModel);
        JTableHeader tableHeader = table.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        this.addHighlighters(table);
        if (rtpIdentifier != null) {
            this.addRtpHighlighter(table, rtpIdentifier);
        }
        SwingUtil.scrollToTableSelection((JTable)table);
        table.getSelectionModel().addListSelectionListener(selectionListener);
        tableModel.addTableModelListener(e -> {
            ((EditProtocolUIModel)((Object)((Object)this.getModel()))).setModify(true);
            int type = e.getType();
            if (type == -1 || type == 1 || e.getLastRow() == Integer.MAX_VALUE) {
                boolean comparatorNull;
                TableColumnExt tableColumn = (TableColumnExt)table.getColumns().get(0);
                TuttiDecorator.TuttiDecoratorComparator comparator = (TuttiDecorator.TuttiDecoratorComparator)tableColumn.getComparator();
                TuttiDecorator<Species> decorator = SpeciesBatchRowHelper.getSpeciesColumnDecorator(tableColumn);
                boolean bl = comparatorNull = comparator == null;
                if (comparatorNull) {
                    comparator = decorator.getCurrentComparator();
                }
                comparator.init(decorator, tableModel.getSpeciesList());
                if (comparatorNull) {
                    tableColumn.setComparator((Comparator)comparator);
                }
            }
        });
        SpeciesBatchRowHelper.installSpeciesColumnComparatorPopup(table, speciesColumn, null, I18n.t((String)"tutti.species.refTaxCode.tip", (Object[])new Object[0]), I18n.t((String)"tutti.species.name.tip", (Object[])new Object[0]));
        tableModel.setRows(rows);
    }

    protected void addRtpHighlighter(JXTable table, ColumnIdentifier identifier) {
        Color cellWithValueColor = this.getConfig().getColorCellWithValue();
        Highlighter commentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{identifier}), (renderer, adapter) -> (Boolean)adapter.getValue()}), (Color)cellWithValueColor);
        table.addHighlighter(commentHighlighter);
    }

    protected EditProtocolOperationFieldsRowModel createOperationFieldRow(String property, String column) {
        EditProtocolOperationFieldsRowModel newRow = new EditProtocolOperationFieldsRowModel();
        newRow.addPropertyChangeListener(evt -> {
            EditProtocolUIModel model = (EditProtocolUIModel)((Object)((Object)this.getModel()));
            if ("importColumn".equals(evt.getPropertyName())) {
                String newValue;
                String oldValue = (String)evt.getOldValue();
                if (oldValue != null) {
                    model.decNumberOfRows(oldValue);
                }
                if ((newValue = (String)evt.getNewValue()) != null) {
                    model.incNumberOfRows(newValue);
                }
                this.recomputeRowsValidState();
            }
        });
        newRow.setValid(true);
        newRow.setField(property);
        newRow.setImportColumn(column);
        newRow.setValid(true);
        newRow.addPropertyChangeListener(evt -> ((EditProtocolUIModel)((Object)((Object)this.getModel()))).setModify(true));
        return newRow;
    }

    protected void recomputeRowsValidState() {
        EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        for (EditProtocolCaracteristicsRowModel editProtocolCaracteristicsRowModel : model.getCaracteristicMappingRows()) {
            editProtocolCaracteristicsRowModel.setValid(this.isCaracteristicsRowValid(editProtocolCaracteristicsRowModel));
        }
        for (EditProtocolOperationFieldsRowModel editProtocolOperationFieldsRowModel : model.getOperationFieldMappingRows()) {
            editProtocolOperationFieldsRowModel.setValid(this.isOperationFieldsRowValid(editProtocolOperationFieldsRowModel));
        }
        this.getCaracteristicsMappingTable().repaint();
        this.getOperationFieldsMappingTable().repaint();
    }

    protected boolean isOperationFieldsRowValid(EditProtocolOperationFieldsRowModel row) {
        EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        String importColumn = row.getImportColumn();
        return importColumn == null || model.numberOfRows(importColumn) < 2;
    }

    protected boolean isCaracteristicsRowValid(EditProtocolCaracteristicsRowModel row) {
        EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        String importColumn = row.getImportColumn();
        return row.getType() != null && (importColumn == null || model.numberOfRows(importColumn) < 2);
    }

    protected void populateImportColumnTableEditors() {
        Collection<String> importColumns = ((EditProtocolUIModel)((Object)this.getModel())).getImportColumns();
        ArrayList<String> dataToList = new ArrayList<String>();
        if (importColumns != null) {
            dataToList.addAll(importColumns);
            if (!dataToList.isEmpty() && dataToList.get(0) != null) {
                dataToList.add(0, null);
            }
        } else {
            dataToList.add(null);
        }
        this.populateImportColumnTableEditor(((EditProtocolUI)this.getUI()).getCaracteristicsMappingTable(), 2, dataToList);
        this.populateImportColumnTableEditor(((EditProtocolUI)this.getUI()).getOperationFieldsMappingTable(), 1, dataToList);
    }

    protected void populateImportColumnTableEditor(JXTable table, int columnIndex, ArrayList<String> dataToList) {
        JComboBox comboBox = new JComboBox();
        SwingUtil.fillComboBox(comboBox, dataToList, null);
        TableColumnExt col = table.getColumnExt(columnIndex);
        ComboBoxCellEditor editor = new ComboBoxCellEditor(comboBox);
        col.setCellEditor((TableCellEditor)editor);
    }

    protected void initJTree(JTree tree) {
        tree.getModel().addTreeModelListener(new ExpandOnInsertTreeModelListener(tree));
        JAXXWidgetUtil.expandTree((JTree)tree);
    }

    private class MaturityCaracteristicCellRenderer
    implements ListCellRenderer {
        public static final String TEXT_PATTERN = "<html><body><strong>%s</strong> :<ul><li>%s</li></ul><strong>%s</strong> :<ul><li>%s</li></ul></body></html>";
        private final ListCellRenderer defaultRenderer;
        private Color validColor;
        private Color invalidColor;

        MaturityCaracteristicCellRenderer(ListCellRenderer defaultRenderer) {
            this.validColor = EditProtocolUIHandler.this.getConfig().getColorCellWithValue();
            this.invalidColor = EditProtocolUIHandler.this.getConfig().getColorRowInvalid();
            this.defaultRenderer = defaultRenderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            Caracteristic maturityCaracteristic = (Caracteristic)value;
            if (!((EditProtocolUIModel)((Object)EditProtocolUIHandler.this.getModel())).isMaturityValid(maturityCaracteristic)) {
                result.setBackground(this.invalidColor);
            } else {
                result.setBackground(this.validColor);
            }
            if (result instanceof JComponent) {
                ((JComponent)result).setToolTipText(this.createToolTipText(maturityCaracteristic));
            }
            return result;
        }

        private String createToolTipText(Caracteristic caracteristic) {
            String tooltip = null;
            if (caracteristic != null && ((EditProtocolUIModel)((Object)EditProtocolUIHandler.this.getModel())).isMaturityValid(caracteristic.getId())) {
                MaturityCaracteristic maturityCaracteristic = ((EditProtocolUIModel)((Object)EditProtocolUIHandler.this.getModel())).getMaturityCaracteristic(caracteristic.getId());
                ArrayList matureStates = new ArrayList();
                ArrayList immatureStates = new ArrayList();
                caracteristic.getQualitativeValue().forEach(state -> {
                    if (maturityCaracteristic.containsMatureStateIds(state.getId())) {
                        matureStates.add(EditProtocolUIHandler.this.decorate((Serializable)state));
                    } else {
                        immatureStates.add(EditProtocolUIHandler.this.decorate((Serializable)state));
                    }
                });
                tooltip = String.format(TEXT_PATTERN, I18n.t((String)"tutti.editProtocol.field.maturity.immature.tip", (Object[])new Object[0]), StringUtils.join(immatureStates, (String)"</li><li>"), I18n.t((String)"tutti.editProtocol.field.maturity.mature.tip", (Object[])new Object[0]), StringUtils.join(matureStates, (String)"</li><li>"));
            }
            return tooltip;
        }
    }

    private static class ExpandOnInsertTreeModelListener
    implements TreeModelListener {
        private final JTree tree;

        private ExpandOnInsertTreeModelListener(JTree tree) {
            this.tree = tree;
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.tree.expandPath(e.getTreePath());
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }
    }

    protected static class SelectValuePredicate
    implements Predicate<Caracteristic> {
        protected final List<BeanDoubleList<Caracteristic>> lists;

        public SelectValuePredicate(List<BeanDoubleList<Caracteristic>> lists) {
            this.lists = lists;
        }

        public boolean apply(Caracteristic input) {
            boolean result = true;
            for (BeanDoubleList<Caracteristic> list : this.lists) {
                if (!list.getModel().getSelected().contains(input)) continue;
                result = false;
                break;
            }
            return result;
        }
    }

    protected static class UpdateSelectedList
    implements PropertyChangeListener {
        private final BeanDoubleListModel<Caracteristic> model;
        private final Map<String, Caracteristic> caracteristicMap;
        private boolean valueIsAdjusting;

        public UpdateSelectedList(BeanDoubleList<Caracteristic> doubleList, Map<String, Caracteristic> caracteristicMap) {
            this.model = doubleList.getModel();
            this.caracteristicMap = caracteristicMap;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!this.valueIsAdjusting) {
                this.valueIsAdjusting = true;
                try {
                    List selectedIds = (List)evt.getNewValue();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("[" + evt.getPropertyName() + "] selected ids: " + selectedIds));
                    }
                    this.select(selectedIds);
                }
                finally {
                    this.valueIsAdjusting = false;
                }
            }
        }

        public void select(List<String> selectedIds) {
            ArrayList selection = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(selectedIds)) {
                for (String selectedId : selectedIds) {
                    Caracteristic e = this.caracteristicMap.get(selectedId);
                    Preconditions.checkNotNull((Object)e, (Object)("Could not find caracteristic with id: " + selectedId));
                    selection.add(e);
                }
            }
            this.model.setSelected((List)selection);
        }
    }
}

