/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.fishing.actions;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatchs;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.FishingOperations;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.GearWithOriginalRankOrder;
import fr.ifremer.tutti.persistence.entities.referential.GearWithOriginalRankOrders;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.SecondaryVesselTypeEnum;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.actions.SaveCatchBatchAction;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.GearUseFeatureTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.VesselUseFeatureTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.actions.SaveFishingOperationAction;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;

public class EditFishingOperationAction
extends LongActionSupport<FishingOperationsUIModel, FishingOperationsUI, FishingOperationsUIHandler> {
    private static final Log log = LogFactory.getLog(EditFishingOperationAction.class);
    protected FishingOperation fishingOperation;
    protected boolean checkPreviousEdit = true;
    protected SaveFishingOperationAction saveFishingOperationAction;
    protected SaveCatchBatchAction saveCatchBatchAction;
    protected final List<String> errorMessages = Lists.newArrayList();
    protected boolean internalAction;
    private final PropertyChangeListener coordinatePropertiesListener = new PropertyChangeListener(){
        private List<String> properties = Lists.newArrayList((Object[])new String[]{"fishingOperationRectiligne", "gearShootingEndLatitude", "gearShootingEndLatitudeDmsSign", "gearShootingEndLatitudeDmsDegree", "gearShootingEndLatitudeDmsMinute", "gearShootingEndLatitudeDmsSecond", "gearShootingEndLatitudeDmdSign", "gearShootingEndLatitudeDmdDegree", "gearShootingEndLatitudeDmdMinute", "gearShootingEndLongitude", "gearShootingEndLongitudeDmsSign", "gearShootingEndLongitudeDmsDegree", "gearShootingEndLongitudeDmsMinute", "gearShootingEndLongitudeDmsSecond", "gearShootingEndLongitudeDmdSign", "gearShootingEndLongitudeDmdDegree", "gearShootingEndLongitudeDmdMinute", "gearShootingStartLatitude", "gearShootingStartLatitudeDmsSign", "gearShootingStartLatitudeDmsDegree", "gearShootingStartLatitudeDmsMinute", "gearShootingStartLatitudeDmsSecond", "gearShootingStartLatitudeDmdSign", "gearShootingStartLatitudeDmdDegree", "gearShootingStartLatitudeDmdMinute", "gearShootingStartLongitude", "gearShootingStartLongitudeDmsSign", "gearShootingStartLongitudeDmsDegree", "gearShootingStartLongitudeDmsMinute", "gearShootingStartLongitudeDmsSecond", "gearShootingStartLongitudeDmdSign", "gearShootingStartLongitudeDmdDegree", "gearShootingStartLongitudeDmdMinute"});

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EditFishingOperationUIModel source;
            if (this.properties.contains(evt.getPropertyName()) && (source = (EditFishingOperationUIModel)evt.getSource()).isFishingOperationRectiligne()) {
                source.computeDistance();
            }
        }
    };

    public EditFishingOperationAction(FishingOperationsUIHandler handler) {
        super(handler, true);
        this.setActionDescription(I18n.t((String)"tutti.editFishingOperation.action.editFishingOperation.tip", (Object[])new Object[0]));
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
        this.getDataContext().setFishingOperationId(fishingOperation != null ? fishingOperation.getIdAsInt() : null);
    }

    public void setCheckPreviousEdit(boolean checkPreviousEdit) {
        this.checkPreviousEdit = checkPreviousEdit;
    }

    public void releaseAction() {
        this.fishingOperation = null;
        this.checkPreviousEdit = true;
        this.internalAction = false;
        super.releaseAction();
    }

    protected SaveFishingOperationAction getSaveFishingOperationAction() {
        if (this.saveFishingOperationAction == null) {
            this.saveFishingOperationAction = new SaveFishingOperationAction(((FishingOperationsUI)this.getUI()).getFishingOperationTabContent().getHandler());
        }
        return this.saveFishingOperationAction;
    }

    protected SaveCatchBatchAction getSaveCatchBatchAction() {
        if (this.saveCatchBatchAction == null) {
            this.saveCatchBatchAction = new SaveCatchBatchAction(((FishingOperationsUI)this.getUI()).getCatchesTabContent().getHandler());
        }
        return this.saveCatchBatchAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareAction() {
        FishingOperationsUI ui;
        this.errorMessages.clear();
        boolean canContinue = true;
        if (this.checkPreviousEdit) {
            ui = (FishingOperationsUI)this.getUI();
            FishingOperationsUIModel model = ui.getModel();
            FishingOperation editFishingOperation = model.getEditFishingOperation();
            String editFishingOperationId = null;
            if (editFishingOperation == null) {
                canContinue = true;
            } else {
                boolean needSave;
                editFishingOperationId = editFishingOperation.getId();
                boolean create = TuttiEntities.isNew((TuttiEntity)editFishingOperation);
                boolean fishingOperationModified = ((FishingOperationsUIHandler)this.getHandler()).isFishingOperationModified();
                boolean catchBatchModified = ((FishingOperationsUIHandler)this.getHandler()).isCatchBatchModified();
                boolean fishingOperationValid = ((FishingOperationsUIHandler)this.getHandler()).isFishingOperationValid();
                boolean catchBatchValid = ((FishingOperationsUIHandler)this.getHandler()).isCatchBatchValid();
                boolean bl = needSave = create || fishingOperationModified || catchBatchModified;
                if (needSave) {
                    boolean canSave = fishingOperationValid && catchBatchValid;
                    canContinue = false;
                    if (canSave) {
                        String message = create ? I18n.t((String)"tutti.editFishingOperation.askSaveBeforeLeaving.createFishingOperation", (Object[])new Object[0]) : (fishingOperationModified ? I18n.t((String)"tutti.editFishingOperation.askSaveBeforeLeaving.saveFishingOperation", (Object[])new Object[0]) : I18n.t((String)"tutti.editCatchBatch.askSaveBeforeLeaving.saveCatchBatch", (Object[])new Object[0]));
                        int answer = ((FishingOperationsUIHandler)this.getHandler()).askSaveBeforeLeaving(message);
                        switch (answer) {
                            case 0: {
                                if (fishingOperationModified) {
                                    this.getSaveFishingOperationAction().setUpdateUI(false);
                                    this.getActionEngine().runInternalAction((AbstractApplicationAction)this.getSaveFishingOperationAction());
                                }
                                if (catchBatchModified) {
                                    this.getSaveCatchBatchAction().setUpdateUI(false);
                                    this.getActionEngine().runInternalAction((AbstractApplicationAction)this.getSaveCatchBatchAction());
                                }
                                canContinue = true;
                                break;
                            }
                            case 1: {
                                canContinue = true;
                            }
                        }
                    } else {
                        String message = fishingOperationValid ? I18n.t((String)"tutti.editCatchBatch.askCancelEditBeforeLeaving.cancelEditCatchBatch", (Object[])new Object[0]) : I18n.t((String)"tutti.editFishingOperation.askCancelEditBeforeLeaving.cancelEditFishingOperation", (Object[])new Object[0]);
                        canContinue = ((FishingOperationsUIHandler)this.handler).askCancelEditBeforeLeaving(message);
                    }
                }
            }
            if (!canContinue) {
                FishingOperation selectFishingOperation = TuttiEntities.isNew((TuttiEntity)editFishingOperation) ? null : model.getFishingOperation(editFishingOperationId);
                model.setEditionAdjusting(true);
                try {
                    model.setSelectedFishingOperation(selectFishingOperation);
                }
                finally {
                    model.setEditionAdjusting(false);
                }
            }
        }
        if (canContinue) {
            ui = (FishingOperationsUI)this.getUI();
            ui.getCatchesTabContent().getHandler().closeAttachments();
            ui.getFishingOperationTabContent().getFishingOperationAttachmentsButton().onCloseUI();
        }
        return canContinue;
    }

    @Override
    public void doAction() throws Exception {
        this.errorMessages.clear();
        FishingOperationsUI ui = (FishingOperationsUI)this.getUI();
        FishingOperationsUIModel model = ui.getModel();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Edit fishingOperation: " + this.fishingOperation));
        }
        model.setEditFishingOperation(this.fishingOperation);
        this.loadFishingOperation(this.fishingOperation);
        this.loadCatchBatch(this.fishingOperation);
        JTabbedPane form = ui.getTabPane();
        JLabel noContentPane = ui.getNoTraitPane();
        if (this.fishingOperation == null) {
            ui.getFishingOperationTabContent().getHandler().onCloseUI();
            ui.getCatchesTabContent().getHandler().onCloseUI();
            ui.remove(form);
            ui.add((Component)noContentPane, "Center");
        } else {
            ui.remove(noContentPane);
            ui.add((Component)form, "Center");
            ui.getFishingOperationTabContent().getFishingOperationTabPane().setSelectedIndex(0);
            if (this.checkPreviousEdit) {
                ui.getTabPane().setSelectedIndex(0);
            }
        }
        model.addPropertyChangeListener(this.coordinatePropertiesListener);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        ((FishingOperationsUI)this.getUI()).getCatchesTabContent().getSpeciesTabPanel().switchToEditBatch();
        ((FishingOperationsUI)this.getUI()).getCatchesTabContent().getBenthosTabPanel().switchToEditBatch();
        EditFishingOperationUI fishingOperationTabContent = ((FishingOperationsUI)this.getUI()).getFishingOperationTabContent();
        fishingOperationTabContent.getModel().setModify(false);
        SwingUtilities.invokeLater(() -> {
            JComponent componentToFocus = fishingOperationTabContent.getHandler().getComponentToFocus();
            componentToFocus.requestFocusInWindow();
        });
        ((FishingOperationsUI)this.getUI()).repaint();
    }

    public void loadFishingOperation(FishingOperation bean) {
        EditFishingOperationUI ui = ((FishingOperationsUI)this.getUI()).getFishingOperationTabContent();
        EditFishingOperationUIHandler handler = ui.getHandler();
        EditFishingOperationUIModel editFishingOperationUIModel = ui.getModel();
        editFishingOperationUIModel.setLoadingData(true);
        editFishingOperationUIModel.removeAllAttachment(editFishingOperationUIModel.getAttachment());
        handler.uninstallStartDateListener();
        handler.uninstallCoordinatesListener();
        if (bean == null) {
            editFishingOperationUIModel.fromEntity(FishingOperations.newFishingOperation());
            editFishingOperationUIModel.setFishingOperation(null);
            editFishingOperationUIModel.setAllSecondaryVessel(null);
            editFishingOperationUIModel.setFishingSecondaryVessel(null);
            editFishingOperationUIModel.setScientificSecondaryVessel(null);
            editFishingOperationUIModel.setOnlyCruisSecondaryVessel(null);
            editFishingOperationUIModel.setSecondaryVesselType(null);
            handler.clearValidators();
            handler.resetAllModels();
        } else {
            TuttiLocation strata = bean.getStrata();
            TuttiLocation subStrata = bean.getSubStrata();
            TuttiLocation location = bean.getLocation();
            PersistenceService persistenceService = this.getContext().getPersistenceService();
            Cruise cruise = bean.getCruise();
            if (cruise != null) {
                ArrayList gears = Lists.newArrayList();
                for (Gear gear : cruise.getGear()) {
                    CaracteristicMap caracteristics = persistenceService.getGearCaracteristics(cruise.getIdAsInt(), gear.getIdAsInt(), gear.getRankOrder().shortValue());
                    GearWithOriginalRankOrder toKeep = GearWithOriginalRankOrders.newGearWithOriginalRankOrder((Gear)gear);
                    toKeep.setCaracteristics(caracteristics);
                    gears.add(toKeep);
                }
                ui.getGearComboBox().setData((List)gears);
            }
            editFishingOperationUIModel.fromEntity(bean);
            editFishingOperationUIModel.setStrata(null);
            editFishingOperationUIModel.setSubStrata(null);
            editFishingOperationUIModel.setLocation(null);
            editFishingOperationUIModel.convertGearShootingCoordinatesFromDD();
            if (strata != null) {
                ui.getStrataComboBox().setSelectedItem((Object)strata);
            }
            if (subStrata != null) {
                ui.getSubStrataComboBox().setSelectedItem((Object)subStrata);
            }
            if (location != null) {
                ui.getLocationComboBox().setSelectedItem((Object)location);
            }
            editFishingOperationUIModel.setFishingOperation(bean);
            List<Person> saisisseur = editFishingOperationUIModel.getRecorderPerson();
            ui.getRecorderPersonList().getHandler().setSelected(saisisseur);
            GearUseFeatureTabUI gearUseFeatureTabContent = ui.getGearUseFeatureTabContent();
            gearUseFeatureTabContent.getHandler().reset(bean);
            VesselUseFeatureTabUI vesselUseFeatureTabContent = ui.getVesselUseFeatureTabContent();
            vesselUseFeatureTabContent.getHandler().reset(bean);
            Integer objectId = editFishingOperationUIModel.getObjectId();
            if (objectId != null) {
                List attachments = persistenceService.getAllAttachments(editFishingOperationUIModel.getObjectType(), objectId);
                editFishingOperationUIModel.addAllAttachment(attachments);
            }
            Vessel cruiseVessel = this.getDataContext().getCruise().getVessel();
            List scientificVessels = this.getDataContext().getScientificVessels();
            List fishingVessels = this.getDataContext().getFishingVessels();
            ArrayList vessels = Lists.newArrayList();
            vessels.addAll(scientificVessels);
            vessels.addAll(fishingVessels);
            vessels.remove(cruiseVessel);
            editFishingOperationUIModel.setAllSecondaryVessel(vessels);
            vessels = Lists.newArrayList();
            vessels.addAll(scientificVessels);
            vessels.remove(cruiseVessel);
            editFishingOperationUIModel.setScientificSecondaryVessel(vessels);
            vessels = Lists.newArrayList();
            vessels.addAll(fishingVessels);
            vessels.remove(cruiseVessel);
            editFishingOperationUIModel.setFishingSecondaryVessel(vessels);
            List<FishingOperation> fishingOperation = ((FishingOperationsUIModel)this.getModel()).getFishingOperation();
            HashSet vesselSet = Sets.newHashSet();
            for (FishingOperation operation : fishingOperation) {
                List secondaryVessel = persistenceService.getFishingOperationSecondaryVessel(operation.getIdAsInt());
                if (!CollectionUtils.isNotEmpty((Collection)secondaryVessel)) continue;
                vesselSet.addAll(secondaryVessel);
            }
            ArrayList vessel = Lists.newArrayList((Iterable)vesselSet);
            editFishingOperationUIModel.setOnlyCruisSecondaryVessel(vessel);
            ui.getSecondaryVesselList().getModel().setSelected(bean.getSecondaryVessel());
            editFishingOperationUIModel.setSecondaryVesselType(SecondaryVesselTypeEnum.ALL);
            editFishingOperationUIModel.setModify(false);
            handler.getFishingOperationMonitor().clearModified();
            handler.registerValidator();
        }
        editFishingOperationUIModel.setLoadingData(false);
        handler.installStartDateListener();
        handler.installCoordinatesListener();
    }

    public void loadCatchBatch(FishingOperation bean) {
        boolean catchEnabled;
        List attachments;
        CatchBatch batch;
        boolean empty = bean == null || TuttiEntities.isNew((TuttiEntity)bean);
        EditCatchesUI ui = ((FishingOperationsUI)this.getUI()).getCatchesTabContent();
        ui.getHandler().uninstallTotalRejectWeightListener();
        TuttiBeanMonitor<EditCatchesUIModel> catchBatchMonitor = ui.getHandler().getCatchBatchMonitor();
        EditCatchesUIModel catchesUIModel = ui.getModel();
        catchesUIModel.setLoadingData(true);
        catchesUIModel.reset();
        Integer operationId = bean == null ? null : bean.getIdAsInt();
        ProgressionModel progressionModel = this.getProgressionModel();
        if (progressionModel == null) {
            progressionModel = new ProgressionModel();
            this.setProgressionModel(progressionModel);
        }
        progressionModel.adaptTotal(empty ? 1 : 6);
        String validationErrorMessage = null;
        if (empty) {
            progressionModel.increments("Create new catch batch");
            if (log.isDebugEnabled()) {
                log.debug((Object)"Create a new CatchBatch (fishing operation is null)");
            }
            batch = CatchBatchs.newCatchBatch();
            batch.setFishingOperation(bean);
            attachments = Collections.emptyList();
            catchEnabled = true;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Load existing CatchBatch from operation id: " + operationId));
            }
            PersistenceService persistenceService = this.getContext().getPersistenceService();
            progressionModel.increments("Chargement de la capture");
            boolean withCatchBath = persistenceService.isFishingOperationWithCatchBatch(operationId);
            if (withCatchBath) {
                try {
                    batch = persistenceService.getCatchBatchFromFishingOperation(operationId);
                    batch.setFishingOperation(bean);
                    Integer objectId = batch.getIdAsInt();
                    attachments = persistenceService.getAllAttachments(catchesUIModel.getObjectType(), objectId);
                    catchEnabled = true;
                }
                catch (InvalidBatchModelException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Invalid batch model", (Throwable)e);
                    }
                    batch = null;
                    attachments = Collections.emptyList();
                    validationErrorMessage = I18n.t((String)"tutti.fishingOperations.warn.catchBatch.invalidSampleCategoryModel", (Object[])new Object[0]);
                    ((FishingOperationsUIModel)this.getModel()).setValidationErrorMessage(validationErrorMessage);
                    catchEnabled = false;
                }
            } else {
                batch = null;
                attachments = Collections.emptyList();
                catchEnabled = false;
                validationErrorMessage = I18n.t((String)"tutti.fishingOperations.warn.catchBatch.notFound", (Object[])new Object[0]);
            }
        }
        this.setCatch(attachments, catchesUIModel, catchBatchMonitor, batch, catchEnabled);
        FishingOperation operationToLoad = batch == null ? null : bean;
        boolean catchValid = true;
        try {
            progressionModel.increments("Chargement des captures Esp\u00e8ces");
            ui.getSpeciesTabPanel().getEditBatchesUI().getHandler().selectFishingOperation(operationToLoad);
        }
        catch (InvalidBatchModelException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invalid sample category model for species batches", (Throwable)e);
            }
            this.errorMessages.add(e.getMessage());
            catchValid = false;
        }
        try {
            progressionModel.increments("Chargement des captures Benthos");
            ui.getBenthosTabPanel().getEditBatchesUI().getHandler().selectFishingOperation(operationToLoad);
        }
        catch (InvalidBatchModelException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invalid sample category model for benthos batches", (Throwable)e);
            }
            this.errorMessages.add(e.getMessage());
            catchValid = false;
        }
        if (!this.errorMessages.isEmpty()) {
            StringBuilder message = new StringBuilder();
            for (String errorMessage : this.errorMessages) {
                message.append("<li>").append(errorMessage).append("</li>");
            }
            validationErrorMessage = I18n.t((String)"tutti.fishingOperations.warn.invalid.batch", (Object[])new Object[]{message.toString()});
        }
        ((FishingOperationsUIModel)this.getModel()).setValidationErrorMessage(validationErrorMessage);
        if (catchValid) {
            progressionModel.increments("Chargmenent des macro-d\u00e9chets");
            ui.getMarineLitterTabContent().getHandler().selectFishingOperation(operationToLoad);
            progressionModel.increments("Chargement des captures accidentelles");
            ui.getAccidentalTabContent().getHandler().selectFishingOperation(operationToLoad);
        } else {
            this.setCatch(Collections.emptyList(), catchesUIModel, catchBatchMonitor, null, false);
        }
        ui.getHandler().installTotalRejectWeightListener();
        catchesUIModel.setLoadingData(false);
    }

    public void postFailedAction(Throwable error) {
        super.postFailedAction(error);
    }

    protected void setCatch(List<Attachment> attachments, EditCatchesUIModel catchesUIModel, TuttiBeanMonitor<EditCatchesUIModel> catchBatchMonitor, CatchBatch batch, boolean catchEnabled) {
        ((FishingOperationsUIModel)this.getModel()).setCatchEnabled(catchEnabled);
        catchesUIModel.fromEntity(batch);
        catchesUIModel.addAllAttachment(attachments);
        catchesUIModel.setModify(false);
        catchBatchMonitor.clearModified();
    }

    public void setInternalAction(boolean internalAction) {
        this.internalAction = internalAction;
    }
}

