/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions;

import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationUICache;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.SimpleActionSupport;
import java.util.HashSet;
import javax.swing.JOptionPane;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RemoveObservationAction
extends SimpleActionSupport<SpeciesFrequencyUI> {
    public RemoveObservationAction(SpeciesFrequencyUI speciesFrequencyUI) {
        super(speciesFrequencyUI, false);
    }

    @Override
    protected void onActionPerformed(SpeciesFrequencyUI ui) {
        JXTable obsTable = ui.getObsTable();
        IndividualObservationBatchTableModel obsTableModel = (IndividualObservationBatchTableModel)((Object)obsTable.getModel());
        int[] selectedRowIndexes = obsTable.getSelectedRows();
        HashSet rowsToDelete = new HashSet();
        for (int selectedRowIndex : selectedRowIndexes) {
            rowsToDelete.add(obsTableModel.getRows().get(selectedRowIndex));
        }
        String message = rowsToDelete.size() == 1 ? I18n.t((String)"tutti.editSpeciesFrequencies.action.removeObservation.confirm.message", (Object[])new Object[0]) : I18n.t((String)"tutti.editSpeciesFrequencies.action.removeObservations.confirm.message", (Object[])new Object[]{rowsToDelete.size()});
        int answer = JOptionPane.showConfirmDialog(ui, message, I18n.t((String)"tutti.editSpeciesFrequencies.action.removeObservations.confirm.title", (Object[])new Object[0]), 0);
        if (answer == 0) {
            SpeciesFrequencyUIModel model = ui.getModel();
            SpeciesFrequencyUIHandler handler = ui.getHandler();
            IndividualObservationUICache individualObservationUICache = handler.getIndividualObservationUICache();
            rowsToDelete.forEach(row -> {
                if (row.withSize()) {
                    if (model.mustCopyIndividualObservationSize()) {
                        handler.updateFrequencyRowsNumbers(row.getSize(), null);
                    }
                    if (model.mustCopyIndividualObservationWeight() && row.withWeight()) {
                        handler.updateFrequencyRowsWeights(row.getSize(), Float.valueOf(-row.getWeight().floatValue()));
                    }
                    individualObservationUICache.decrements((IndividualObservationBatchRowModel)row);
                }
                model.removeIndividualObservationRowInError((IndividualObservationBatchRowModel)row);
            });
            int minSelection = obsTable.getSelectionModel().getMinSelectionIndex();
            int maxSelection = obsTable.getSelectionModel().getMaxSelectionIndex();
            obsTableModel.getRows().removeAll(rowsToDelete);
            obsTableModel.fireTableRowsDeleted(minSelection, maxSelection);
            model.setModify(true);
        }
    }
}

