/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.catches.multipost.MultiPostImportService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.actions.ImportMultiPostActionSupport;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesOrBenthosBatchUISupport;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public abstract class ImportMultiPostSpeciesSupportAction
extends ImportMultiPostActionSupport<SpeciesFrequencyUIModel, SpeciesFrequencyUI, SpeciesFrequencyUIHandler> {
    private static final Log log = LogFactory.getLog(ImportMultiPostSpeciesSupportAction.class);

    protected ImportMultiPostSpeciesSupportAction(SpeciesFrequencyUIHandler handler) {
        super(handler);
    }

    public abstract boolean isImportFrequencies();

    public abstract boolean isImportIndivudalObservations();

    @Override
    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            String message = "<ul>";
            boolean ask = false;
            if (this.isImportFrequencies() && ((SpeciesFrequencyUIModel)this.getModel()).getRowCount() > 0) {
                ask = true;
                message = "<li>" + I18n.t((String)"tutti.askBeforeMultiPostImport.frequencies.message", (Object[])new Object[0]) + "</li>";
            }
            if (this.isImportIndivudalObservations() && ((SpeciesFrequencyUIModel)this.getModel()).getIndividualObservationRows().size() > 0) {
                ask = true;
                message = message + "<li>" + I18n.t((String)"tutti.askBeforeMultiPostImport.frequencies.message", (Object[])new Object[0]) + "</li>";
            }
            message = message + "</ul>";
            if (ask) {
                String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.askBeforeMultiPostImport.message", (Object[])new Object[]{message}), I18n.t((String)"tutti.askBeforeMultiPostImport.help", (Object[])new Object[0]));
                int saveResponse = JOptionPane.showOptionDialog(((SpeciesFrequencyUIHandler)this.getHandler()).getTopestUI(), htmlMessage, I18n.t((String)"tutti.askBeforeMultiPostImport.title", (Object[])new Object[0]), 2, 3, null, new String[]{I18n.t((String)"tutti.option.cleanAndImport", (Object[])new Object[0]), I18n.t((String)"tutti.option.cancelImport", (Object[])new Object[0])}, I18n.t((String)"tutti.option.cleanAndImport", (Object[])new Object[0]));
                switch (saveResponse) {
                    case 0: {
                        doAction = true;
                        break;
                    }
                    case 1: {
                        doAction = false;
                    }
                }
            }
        }
        return doAction;
    }

    @Override
    protected final Map<String, Object> importBatches(MultiPostImportService multiPostImportExportService, File file, FishingOperation operation) {
        SpeciesOrBenthosBatchUISupport batchUISupport = ((SpeciesFrequencyUIModel)this.getModel()).getSpeciesOrBenthosBatchUISupport();
        SpeciesBatch speciesBatch = ((SpeciesFrequencyUIModel)this.getModel()).getBatch().toEntity();
        return batchUISupport.importMultiPost(file, operation, speciesBatch, this.isImportFrequencies(), this.isImportIndivudalObservations());
    }

    @Override
    public final void postSuccessAction() {
        super.postSuccessAction();
        SpeciesFrequencyCellComponent.FrequencyCellEditor frequencyEditor = ((SpeciesFrequencyUIHandler)this.getHandler()).getFrequencyEditor();
        SpeciesBatchRowModel editRow = frequencyEditor.getEditRow();
        Integer speciesBatchId = editRow.getIdAsInt();
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        List frequencies = persistenceService.getAllSpeciesBatchFrequency(speciesBatchId);
        if (log.isInfoEnabled()) {
            log.info((Object)("[SpeciesBatch: " + speciesBatchId + "] Frequencies: " + frequencies.size()));
        }
        editRow.loadFrequencies(frequencies);
        List individualObservations = persistenceService.getAllIndividualObservationBatchsForBatch(speciesBatchId);
        editRow.loadIndividualObservations(this.getConfig().getIndividualObservationWeightUnit(), this.getDataContext().getDefaultIndividualObservationCaracteristics(), individualObservations);
        if (log.isInfoEnabled()) {
            log.info((Object)("[SpeciesBatch: " + speciesBatchId + "] Individual Observations: " + individualObservations.size()));
        }
        ((SpeciesFrequencyUIHandler)this.getHandler()).editBatch(frequencyEditor, Optional.empty());
    }
}

