/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.samplingCache;

import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import java.io.Closeable;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class CruiseSamplingInternalCache
implements Closeable {
    private static final Log log = LogFactory.getLog(CruiseSamplingInternalCache.class);
    private static final String KEY_SEPARATOR = "#";
    private final Map<String, MutableInt> data = new TreeMap<String, MutableInt>();

    CruiseSamplingInternalCache() {
    }

    public static String createSamplingKey(Species species, CaracteristicQualitativeValue gender, Boolean maturity, Float lengthStep) {
        Objects.requireNonNull(species);
        Objects.requireNonNull(lengthStep);
        return species.getReferenceTaxonId() + KEY_SEPARATOR + (gender == null ? null : gender.getId()) + KEY_SEPARATOR + maturity + KEY_SEPARATOR + lengthStep;
    }

    public static String addPrefixKey(Serializable prefix, String key) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(key);
        return prefix + KEY_SEPARATOR + key;
    }

    public int increment(String samplingKey) {
        Objects.requireNonNull(samplingKey);
        MutableInt value = this.data.computeIfAbsent(samplingKey, s -> new MutableInt(0));
        value.increment();
        if (log.isDebugEnabled()) {
            log.debug((Object)(samplingKey + " \u2192 " + value));
        }
        return value.intValue();
    }

    public int decrement(String samplingKey) {
        Objects.requireNonNull(samplingKey);
        MutableInt value = this.data.get(samplingKey);
        value.decrement();
        if (log.isDebugEnabled()) {
            log.debug((Object)(samplingKey + " \u2192 " + value));
        }
        return value.intValue();
    }

    public Integer decrementIfExist(String samplingKey) {
        Objects.requireNonNull(samplingKey);
        Integer result = null;
        MutableInt value = this.data.get(samplingKey);
        if (value != null) {
            value.decrement();
            result = value.intValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)(samplingKey + " \u2192 " + value));
            }
        }
        return result;
    }

    @Override
    public void close() {
        this.data.clear();
    }

    public int size() {
        return this.data.size();
    }

    public Set<String> removeAllWhereKeyStartingWith(String id) {
        Objects.requireNonNull(id);
        String keyPrefix = CruiseSamplingInternalCache.addPrefixKey((Serializable)((Object)id), "");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ask to remove all keys starting with: " + keyPrefix));
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Iterator<Map.Entry<String, MutableInt>> iterator = this.data.entrySet().iterator();
        int keyPrefixLength = keyPrefix.length();
        while (iterator.hasNext()) {
            Map.Entry<String, MutableInt> entry = iterator.next();
            String key = entry.getKey();
            if (!key.startsWith(keyPrefix)) continue;
            iterator.remove();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing key: " + key));
            }
            result.add(key.substring(keyPrefixLength));
        }
        return result;
    }
}

