/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.samplingCache;

import com.google.common.base.MoreObjects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.protocol.CalcifiedPiecesSamplingDefinition;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.Zone;
import fr.ifremer.tutti.persistence.entities.protocol.Zones;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.service.samplingCache.CruiseSamplingInternalCache;
import fr.ifremer.tutti.service.samplingCache.SamplingEvent;
import fr.ifremer.tutti.service.samplingCache.SamplingListener;
import java.io.Closeable;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CruiseSamplingCache
implements Closeable {
    private static final Log log = LogFactory.getLog(CruiseSamplingCache.class);
    private final CruiseSamplingInternalCache totalCruiseCache = new CruiseSamplingInternalCache();
    private final CruiseSamplingInternalCache zoneCache = new CruiseSamplingInternalCache();
    private final CruiseSamplingInternalCache operationCache = new CruiseSamplingInternalCache();
    private final Multimap<Zone, Integer> locationIdsPerZone;
    private final Multimap<Integer, CalcifiedPiecesSamplingDefinition> cpsDefinitionsBySpecies = HashMultimap.create();
    private final Map<Integer, Caracteristic> maturityCaracteristicBySpecies = new HashMap<Integer, Caracteristic>();
    private final Multimap<String, String> matureStatesByMaturityCracteristic = HashMultimap.create();
    private final Caracteristic sexCaracteristic;
    private final EventListenerList listeners = new EventListenerList();
    private final Integer cruiseId;
    private final String protocolId;
    private boolean loading;
    private final Map<Integer, Integer> highestSamplingCodeBySpecies = new HashMap<Integer, Integer>();

    public CruiseSamplingCache(Integer cruiseId, TuttiProtocol protocol, Caracteristic sexCaracteristic, Collection<Caracteristic> maturityCaracteristics) {
        this.cruiseId = cruiseId;
        this.sexCaracteristic = sexCaracteristic;
        this.protocolId = protocol.getId();
        this.locationIdsPerZone = HashMultimap.create();
        protocol.getZone().forEach(zone -> this.locationIdsPerZone.putAll(zone, (Iterable)Zones.getAllLocationIds((Zone)zone)));
        Map maturityCaracteristicsById = TuttiEntities.splitById(maturityCaracteristics);
        protocol.getSpecies().forEach(speciesProtocol -> {
            this.cpsDefinitionsBySpecies.putAll((Object)speciesProtocol.getSpeciesReferenceTaxonId(), (Iterable)speciesProtocol.getCalcifiedPiecesSamplingDefinition());
            this.maturityCaracteristicBySpecies.put(speciesProtocol.getSpeciesReferenceTaxonId(), (Caracteristic)maturityCaracteristicsById.get(speciesProtocol.getMaturityPmfmId()));
        });
        protocol.getMaturityCaracteristics().forEach(mc -> this.matureStatesByMaturityCracteristic.putAll((Object)mc.getId(), (Iterable)mc.getMatureStateIds()));
    }

    public Integer getCruiseId() {
        return this.cruiseId;
    }

    public String getProtocolId() {
        return this.protocolId;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    @Override
    public void close() {
        SamplingListener[] samplingListeners;
        if (log.isInfoEnabled()) {
            log.info((Object)"Closing cruise sampling cache.");
        }
        this.totalCruiseCache.close();
        this.zoneCache.close();
        this.operationCache.close();
        this.locationIdsPerZone.clear();
        this.cpsDefinitionsBySpecies.clear();
        this.maturityCaracteristicBySpecies.clear();
        this.matureStatesByMaturityCracteristic.clear();
        for (SamplingListener listener : samplingListeners = (SamplingListener[])this.listeners.getListeners(SamplingListener.class)) {
            this.removeSamplingListener(listener);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cruiseId", (Object)this.cruiseId).add("protocolId", (Object)this.protocolId).add("totalCruiseCache", this.totalCruiseCache.size()).add("zoneCache", this.zoneCache.size()).add("operationCache", this.operationCache.size()).toString();
    }

    public void addIndividualObservation(Integer fishingOperationId, Optional<Zone> optionalZone, IndividualObservationBatch individualObservationBatch) {
        Objects.requireNonNull(fishingOperationId);
        Objects.requireNonNull(optionalZone);
        Objects.requireNonNull(individualObservationBatch);
        Species species = individualObservationBatch.getSpecies();
        Objects.requireNonNull(species);
        Boolean maturity = this.getMaturity(individualObservationBatch);
        Float lengthStep = individualObservationBatch.getSize();
        Objects.requireNonNull(lengthStep);
        CaracteristicQualitativeValue gender = individualObservationBatch.getCaracteristics().getQualitativeValue(this.sexCaracteristic);
        this.addIndividualObservation(fishingOperationId, optionalZone, species, gender, maturity, lengthStep.floatValue());
        String samplingCode = individualObservationBatch.getSamplingCode();
        if (samplingCode != null) {
            String[] codeParts = samplingCode.split("#");
            Integer code = Integer.parseInt(codeParts[codeParts.length - 1]);
            Integer highestSmaplingCode = this.highestSamplingCodeBySpecies.get(species.getReferenceTaxonId());
            if (highestSmaplingCode == null || code > highestSmaplingCode) {
                this.highestSamplingCodeBySpecies.put(species.getReferenceTaxonId(), code);
            }
        }
    }

    public void addIndividualObservation(FishingOperation fishingOperation, Species species, CaracteristicQualitativeValue gender, Boolean maturity, float lengthStep) {
        Objects.requireNonNull(fishingOperation);
        Objects.requireNonNull(species);
        Optional<Zone> optionalZone = this.tryFindZone(fishingOperation);
        this.addIndividualObservation(fishingOperation.getIdAsInt(), optionalZone, species, gender, maturity, lengthStep);
    }

    public void addIndividualObservation(Integer fishingOperationId, Optional<Zone> optionalZone, Species species, CaracteristicQualitativeValue gender, Boolean maturity, float lengthStep) {
        Objects.requireNonNull(fishingOperationId);
        Objects.requireNonNull(species);
        Optional<CalcifiedPiecesSamplingDefinition> cpsDefinitionOpt = this.getCalcifiedPiecesSamplingDefinition(species, maturity, lengthStep);
        if (cpsDefinitionOpt.isPresent()) {
            int samplingInterval;
            CalcifiedPiecesSamplingDefinition cpsDefinition = cpsDefinitionOpt.get();
            if (log.isInfoEnabled()) {
                log.info((Object)("Found matching sampling definition: " + cpsDefinition));
            }
            if (!((samplingInterval = cpsDefinition.getSamplingInterval()) <= 0 || cpsDefinition.isSex() && gender == null)) {
                if (!cpsDefinition.isSex()) {
                    gender = null;
                }
                String samplingKey = CruiseSamplingInternalCache.createSamplingKey(species, gender, maturity, Float.valueOf(lengthStep));
                int totalValue = this.totalCruiseCache.increment(samplingKey);
                int zoneValue = 0;
                if (optionalZone.isPresent()) {
                    String zoneKey = CruiseSamplingInternalCache.addPrefixKey((Serializable)((Object)optionalZone.get().getId()), samplingKey);
                    zoneValue = this.zoneCache.increment(zoneKey);
                }
                String operationKey = CruiseSamplingInternalCache.addPrefixKey(fishingOperationId, samplingKey);
                int operationValue = this.operationCache.increment(operationKey);
                if (log.isInfoEnabled()) {
                    log.info((Object)("addIndividualObservation " + samplingKey + " => op " + operationValue + " / zone " + zoneValue + " / cruise " + totalValue));
                }
                if (!(this.isLoading() || totalValue != 1 && totalValue % samplingInterval != 1)) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"-> needs sampling");
                    }
                    this.fireSamplingNeeded(lengthStep, gender, maturity, cpsDefinition, samplingInterval, totalValue, zoneValue, operationValue);
                }
            }
        }
    }

    public void removeIndividualObservations(Integer fishingOperationId, Optional<Zone> optionalZone, Collection<IndividualObservationBatch> individualObservationBatches) {
        Objects.requireNonNull(fishingOperationId);
        Objects.requireNonNull(optionalZone);
        Objects.requireNonNull(individualObservationBatches);
        individualObservationBatches.forEach(individualObservationBatch -> {
            Species species = individualObservationBatch.getSpecies();
            Objects.requireNonNull(species);
            Boolean maturity = this.getMaturity((IndividualObservationBatch)individualObservationBatch);
            Float lengthStep = individualObservationBatch.getSize();
            Objects.requireNonNull(lengthStep);
            CaracteristicQualitativeValue gender = individualObservationBatch.getCaracteristics().getQualitativeValue(this.sexCaracteristic);
            this.removeIndividualObservation(fishingOperationId, optionalZone, species, gender, maturity, lengthStep);
        });
    }

    public void removeIndividualObservation(FishingOperation fishingOperation, Species species, CaracteristicQualitativeValue gender, Boolean maturity, Float lengthStep) {
        Objects.requireNonNull(fishingOperation);
        Objects.requireNonNull(species);
        Objects.requireNonNull(lengthStep);
        Optional<Zone> optionalZone = this.tryFindZone(fishingOperation);
        this.removeIndividualObservation(fishingOperation.getIdAsInt(), optionalZone, species, gender, maturity, lengthStep);
    }

    public void removeIndividualObservation(Integer fishingOperationId, Optional<Zone> optionalZone, Species species, CaracteristicQualitativeValue gender, Boolean maturity, Float lengthStep) {
        Objects.requireNonNull(fishingOperationId);
        Objects.requireNonNull(optionalZone);
        Objects.requireNonNull(species);
        Objects.requireNonNull(lengthStep);
        Optional<CalcifiedPiecesSamplingDefinition> cpsDefinitionOpt = this.getCalcifiedPiecesSamplingDefinition(species, maturity, lengthStep.floatValue());
        if (cpsDefinitionOpt.isPresent()) {
            int samplingInterval;
            CalcifiedPiecesSamplingDefinition cpsDefinition = cpsDefinitionOpt.get();
            if (log.isInfoEnabled()) {
                log.info((Object)("Found matching sampling definition: " + cpsDefinition));
            }
            if (!((samplingInterval = cpsDefinition.getSamplingInterval()) <= 0 || cpsDefinition.isSex() && gender == null)) {
                if (!cpsDefinition.isSex()) {
                    gender = null;
                }
                String samplingKey = CruiseSamplingInternalCache.createSamplingKey(species, gender, maturity, lengthStep);
                int totalValue = this.totalCruiseCache.decrement(samplingKey);
                int zoneValue = 0;
                if (optionalZone.isPresent()) {
                    String zoneKey = CruiseSamplingInternalCache.addPrefixKey((Serializable)((Object)optionalZone.get().getId()), samplingKey);
                    zoneValue = this.zoneCache.decrement(zoneKey);
                }
                String operationKey = CruiseSamplingInternalCache.addPrefixKey(fishingOperationId, samplingKey);
                int operationValue = this.operationCache.decrement(operationKey);
                if (log.isInfoEnabled()) {
                    log.info((Object)("remove individual observation " + samplingKey + " \u21d2 op " + operationValue + " / zone " + zoneValue + " / cruise " + totalValue));
                }
            }
        }
    }

    public void removeFishingOperation(FishingOperation fishingOperation) {
        Optional<Zone> optionalZone;
        Objects.requireNonNull(fishingOperation);
        String fishingOperationId = fishingOperation.getId();
        if (log.isInfoEnabled()) {
            log.info((Object)("Remove fishing operation: " + fishingOperationId + " from CruiseSamplingCache: " + this));
        }
        Set<String> removedKeys = this.operationCache.removeAllWhereKeyStartingWith(fishingOperationId);
        if (log.isInfoEnabled()) {
            log.info((Object)("Fishing operation: " + fishingOperationId + " removed from operationCache: " + this.operationCache.size()));
        }
        removedKeys.forEach(this.totalCruiseCache::decrement);
        if (log.isInfoEnabled()) {
            log.info((Object)("Fishing operation: " + fishingOperationId + " removed from totalCruiseCache: " + this.totalCruiseCache.size()));
        }
        if ((optionalZone = this.tryFindZone(fishingOperation)).isPresent()) {
            String zoneId = optionalZone.get().getId();
            removedKeys.forEach(key -> this.zoneCache.decrementIfExist(CruiseSamplingInternalCache.addPrefixKey((Serializable)((Object)zoneId), key)));
            if (log.isInfoEnabled()) {
                log.info((Object)("Fishing operation: " + fishingOperationId + " removed from zoneCache: " + this.zoneCache.size()));
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Fishing operation: " + fishingOperationId + " removed from CruiseSamplingCache: " + this));
        }
    }

    public Optional<Zone> tryFindZone(FishingOperation operation) {
        Optional<Object> result = operation.getSubStrata() != null ? this.tryFindZone(operation.getSubStrata()) : (operation.getStrata() != null ? this.tryFindZone(operation.getStrata()) : Optional.empty());
        return result;
    }

    public void addSamplingListener(SamplingListener listener) {
        this.listeners.add(SamplingListener.class, listener);
    }

    public void removeSamplingListener(SamplingListener listener) {
        this.listeners.remove(SamplingListener.class, listener);
    }

    protected Optional<CalcifiedPiecesSamplingDefinition> getCalcifiedPiecesSamplingDefinition(Species species, Boolean maturity, float lengthStep) {
        Collection cpsDefinitions = this.cpsDefinitionsBySpecies.get((Object)species.getReferenceTaxonId());
        return cpsDefinitions.stream().filter(cpsDef -> Objects.equals(cpsDef.getMaturity(), maturity) && lengthStep >= (float)cpsDef.getMinSize() && (cpsDef.getMaxSize() == null || lengthStep <= (float)cpsDef.getMaxSize().intValue())).findFirst();
    }

    protected int getSamplingNumber(int value, int interval) {
        return 1 + (value - 1) / interval;
    }

    protected void fireSamplingNeeded(float lengthStep, CaracteristicQualitativeValue gender, Boolean maturity, CalcifiedPiecesSamplingDefinition cpsDefinition, int samplingInterval, int totalValue, int zoneValue, int operationValue) {
        SamplingListener[] samplingListeners = (SamplingListener[])this.listeners.getListeners(SamplingListener.class);
        if (samplingListeners.length > 0) {
            int nbForCruise = this.getSamplingNumber(totalValue, samplingInterval);
            int nbForZone = this.getSamplingNumber(zoneValue, samplingInterval);
            int nbForOperation = this.getSamplingNumber(operationValue, samplingInterval);
            SamplingEvent event = new SamplingEvent(this, lengthStep, gender, maturity, cpsDefinition, nbForCruise, nbForZone, nbForOperation);
            for (SamplingListener listener : samplingListeners) {
                listener.samplingNeeded(event);
            }
        }
    }

    protected Optional<Zone> tryFindZone(TuttiLocation location) {
        Integer locationId = location.getIdAsInt();
        return this.locationIdsPerZone.keySet().stream().filter(zone -> this.locationIdsPerZone.containsEntry(zone, (Object)locationId)).findFirst();
    }

    protected Boolean getMaturity(IndividualObservationBatch individualObservationBatch) {
        CaracteristicQualitativeValue qualitativeValue;
        Boolean maturity = null;
        Caracteristic maturityCaracteristic = this.maturityCaracteristicBySpecies.get(individualObservationBatch.getSpecies().getReferenceTaxonId());
        if (maturityCaracteristic != null && (qualitativeValue = individualObservationBatch.getCaracteristics().getQualitativeValue(maturityCaracteristic)) != null) {
            maturity = this.matureStatesByMaturityCracteristic.containsEntry((Object)maturityCaracteristic.getId(), (Object)qualitativeValue.getId());
        }
        return maturity;
    }

    public Boolean getMaturity(Integer speciesId, Optional<CaracteristicQualitativeValue> maturityQualitativeValue) {
        Boolean maturity = null;
        Optional<Caracteristic> maturityCaracteristic = Optional.ofNullable(this.maturityCaracteristicBySpecies.get(speciesId));
        if (maturityCaracteristic.isPresent() && maturityQualitativeValue.isPresent()) {
            maturity = this.matureStatesByMaturityCracteristic.containsEntry((Object)maturityCaracteristic.get().getId(), (Object)maturityQualitativeValue.get().getId());
        }
        return maturity;
    }

    public int getNextSamplingCodeId(Integer speciesId) {
        Integer highestSamplingCode = this.highestSamplingCodeBySpecies.getOrDefault(speciesId, 0);
        int newHighestCode = highestSamplingCode + 1;
        this.highestSamplingCodeBySpecies.put(speciesId, newHighestCode);
        return newHighestCode;
    }
}

