/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.persistence.model.ProgramDataModel;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import fr.ifremer.tutti.service.csv.CsvProducer;
import fr.ifremer.tutti.service.genericformat.GenericFormatArchive;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportConfiguration;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportOperationContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportRequest;
import fr.ifremer.tutti.service.genericformat.csv.AccidentalCatchModel;
import fr.ifremer.tutti.service.genericformat.csv.AttachmentModel;
import fr.ifremer.tutti.service.genericformat.csv.CatchModel;
import fr.ifremer.tutti.service.genericformat.csv.GearCaracteristicModel;
import fr.ifremer.tutti.service.genericformat.csv.IndividualObservationModel;
import fr.ifremer.tutti.service.genericformat.csv.MarineLitterModel;
import fr.ifremer.tutti.service.genericformat.csv.OperationModel;
import fr.ifremer.tutti.service.genericformat.csv.ParameterModel;
import fr.ifremer.tutti.service.genericformat.csv.SampleCategoryModel;
import fr.ifremer.tutti.service.genericformat.csv.SpeciesExportModel;
import fr.ifremer.tutti.service.genericformat.csv.SurveyModel;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForAccidentalCatch;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForAttachment;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForCatch;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForGearCaracteristics;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForIndividualObservation;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForMarineLitter;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForOperation;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForParameter;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForSampleCategory;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForSpecies;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForSurvey;
import fr.ifremer.tutti.service.referential.producer.CsvProducerForTemporaryGear;
import fr.ifremer.tutti.service.referential.producer.CsvProducerForTemporaryPerson;
import fr.ifremer.tutti.service.referential.producer.CsvProducerForTemporarySpecies;
import fr.ifremer.tutti.service.referential.producer.CsvProducerForTemporaryVessel;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;

public class GenericFormatExportContext
implements Closeable,
Iterable<GenericFormatExportCruiseContext> {
    private static final Log log = LogFactory.getLog(GenericFormatExportContext.class);
    private final GenericFormatExportRequest exportRequest;
    private final Decorator<FishingOperation> fishingOperationDecorator;
    private final Caracteristic deadOrAliveCaracteristic;
    private final Caracteristic genderCaracteristic;
    private final Caracteristic weightMeasuredCaracteristic;
    private final Caracteristic pmfmIdCaracteristic;
    private final CsvProducerForSurvey producerForSurvey;
    private final CsvProducerForGearCaracteristics producerForGearCaracteristics;
    private final CsvProducerForOperation producerForOperation;
    private final CsvProducerForParameter producerForParameter;
    private final CsvProducerForIndividualObservation producerForIndividualObservation;
    private final CsvProducerForAccidentalCatch producerForAccidentalCatch;
    private final CsvProducerForCatch producerForCatch;
    private final CsvProducerForSpecies producerForSpecies;
    private final CsvProducerForMarineLitter producerForMarineLitter;
    private final CsvProducerForTemporaryGear producerForTemporaryGear;
    private final CsvProducerForTemporaryPerson producerForTemporaryPerson;
    private final CsvProducerForTemporarySpecies producerForTemporarySpecies;
    private final CsvProducerForTemporaryVessel producerForTemporaryVessel;
    private final CsvProducerForSampleCategory producerForSampleCategory;
    private final CsvProducerForAttachment producerForAttachment;
    private final ProgressionModel progressionModel;
    private final Set<GenericFormatExportCruiseContext> cruiseContexts;

    GenericFormatExportContext(ProgressionModel progressionModel, GenericFormatExportRequest exportRequest, PersistenceService persistenceService, Decorator<FishingOperation> fishingOperationDecorator) {
        Preconditions.checkNotNull((Object)progressionModel);
        this.progressionModel = progressionModel;
        Preconditions.checkNotNull((Object)exportRequest);
        this.exportRequest = exportRequest;
        Preconditions.checkNotNull(fishingOperationDecorator);
        this.fishingOperationDecorator = fishingOperationDecorator;
        Preconditions.checkNotNull((Object)persistenceService);
        this.weightMeasuredCaracteristic = persistenceService.getWeightMeasuredCaracteristic();
        this.pmfmIdCaracteristic = persistenceService.getPmfmIdCaracteristic();
        this.deadOrAliveCaracteristic = persistenceService.getDeadOrAliveCaracteristic();
        this.genderCaracteristic = persistenceService.getSexCaracteristic();
        this.cruiseContexts = new LinkedHashSet<GenericFormatExportCruiseContext>();
        List<Species> allReferentSpecies = persistenceService.getAllReferentSpecies();
        Map speciesByReferenceTaxonId = Speciess.splitReferenceSpeciesByReferenceTaxonId(allReferentSpecies);
        GenericFormatArchive archive = exportRequest.getArchive();
        char csvSeparator = exportRequest.getCsvSeparator();
        fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel sampleCategoryModel = exportRequest.getSampleCategoryModel();
        Path attachmentsSourcePath = exportRequest.getAttachmentsSourcePath();
        this.producerForSurvey = new CsvProducerForSurvey(archive.getSurveyPath(), SurveyModel.forExport(csvSeparator));
        this.producerForGearCaracteristics = new CsvProducerForGearCaracteristics(archive.getGearCaracteristicsPath(), GearCaracteristicModel.forExport(csvSeparator));
        this.producerForOperation = new CsvProducerForOperation(archive.getOperationPath(), OperationModel.forExport(csvSeparator));
        this.producerForIndividualObservation = new CsvProducerForIndividualObservation(archive.getIndividualObservationPath(), IndividualObservationModel.forExport(csvSeparator));
        this.producerForSpecies = new CsvProducerForSpecies(archive.getSpeciesPath(), SpeciesExportModel.forExport(csvSeparator), speciesByReferenceTaxonId);
        this.producerForCatch = new CsvProducerForCatch(archive.getCatchPath(), CatchModel.forExport(csvSeparator, sampleCategoryModel));
        this.producerForAccidentalCatch = new CsvProducerForAccidentalCatch(archive.getAccidentalCatchPath(), AccidentalCatchModel.forExport(csvSeparator));
        this.producerForParameter = new CsvProducerForParameter(archive.getParameterPath(), ParameterModel.forExport(csvSeparator));
        this.producerForMarineLitter = new CsvProducerForMarineLitter(archive.getMarineLitterPath(), MarineLitterModel.forExport(csvSeparator));
        this.producerForSampleCategory = new CsvProducerForSampleCategory(archive.getSampleCategoryModelPath(), SampleCategoryModel.forExport(csvSeparator));
        this.producerForAttachment = new CsvProducerForAttachment(archive.getAttachmentFilePath(), AttachmentModel.forExport(csvSeparator), attachmentsSourcePath, archive.getAttachmentDataPath());
        this.producerForTemporaryGear = new CsvProducerForTemporaryGear(archive.getTemporaryReferentialGearsPath(), csvSeparator);
        this.producerForTemporaryPerson = new CsvProducerForTemporaryPerson(archive.getTemporaryReferentialPersonsPath(), csvSeparator);
        this.producerForTemporarySpecies = new CsvProducerForTemporarySpecies(archive.getTemporaryReferentialSpeciesPath(), csvSeparator, true);
        this.producerForTemporaryVessel = new CsvProducerForTemporaryVessel(archive.getTemporaryReferentialVesselsPath(), csvSeparator);
    }

    public TuttiProtocol getProtocol() {
        return this.exportRequest.getProtocol();
    }

    public File getExportFile() {
        return this.getExportConfiguration().getExportFile();
    }

    public ProgramDataModel getDataToExport() {
        return this.getExportConfiguration().getDataToExport();
    }

    public boolean isExportAttachments() {
        return this.getExportConfiguration().isExportAttachments();
    }

    public boolean isExportSpecies() {
        return this.getExportConfiguration().isExportSpecies();
    }

    public boolean isExportBenthos() {
        return this.getExportConfiguration().isExportBenthos();
    }

    public boolean isExportMarineLitter() {
        return this.getExportConfiguration().isExportMarineLitter();
    }

    public boolean isExportAccidentalCatch() {
        return this.getExportConfiguration().isExportAccidentalCatch();
    }

    public boolean isExportIndividualObservation() {
        return this.getExportConfiguration().isExportIndividualObservation();
    }

    public GenericFormatArchive getArchive() {
        return this.exportRequest.getArchive();
    }

    public fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel getSampleCategoryModel() {
        return this.exportRequest.getSampleCategoryModel();
    }

    public File getProtocolFile() {
        return this.getArchive().getProtocolPath().toFile();
    }

    public ProgressionModel getProgressionModel() {
        return this.progressionModel;
    }

    public CsvProducerForSurvey getProducerForSurvey() {
        return this.producerForSurvey;
    }

    public CsvProducerForGearCaracteristics getProducerForGearCaracteristics() {
        return this.producerForGearCaracteristics;
    }

    public CsvProducerForOperation getProducerForOperation() {
        return this.producerForOperation;
    }

    public CsvProducerForParameter getProducerForParameter() {
        return this.producerForParameter;
    }

    public CsvProducerForIndividualObservation getProducerForIndividualObservation() {
        return this.producerForIndividualObservation;
    }

    public CsvProducerForAccidentalCatch getProducerForAccidentalCatch() {
        return this.producerForAccidentalCatch;
    }

    public CsvProducerForCatch getProducerForCatch() {
        return this.producerForCatch;
    }

    public CsvProducerForSpecies getProducerForSpecies() {
        return this.producerForSpecies;
    }

    public CsvProducerForMarineLitter getProducerForMarineLitter() {
        return this.producerForMarineLitter;
    }

    public CsvProducerForTemporaryGear getProducerForTemporaryGear() {
        return this.producerForTemporaryGear;
    }

    public CsvProducerForTemporaryPerson getProducerForTemporaryPerson() {
        return this.producerForTemporaryPerson;
    }

    public CsvProducerForTemporarySpecies getProducerForTemporarySpecies() {
        return this.producerForTemporarySpecies;
    }

    public CsvProducerForTemporaryVessel getProducerForTemporaryVessel() {
        return this.producerForTemporaryVessel;
    }

    public CsvProducerForSampleCategory getProducerForSampleCategory() {
        return this.producerForSampleCategory;
    }

    public CsvProducerForAttachment getProducerForAttachment() {
        return this.producerForAttachment;
    }

    public void increments(String message) {
        this.progressionModel.increments(message);
    }

    public void addCruiseContext(Cruise cruise, Set<FishingOperation> operations) {
        GenericFormatExportCruiseContext cruiseContext = new GenericFormatExportCruiseContext(cruise, operations);
        this.cruiseContexts.add(cruiseContext);
    }

    public GenericFormatExportOperationContext newOperationContext(PersistenceService persistenceService, WeightComputingService weightComputingService, Cruise cruise, FishingOperation operation) {
        String operationLabel = this.fishingOperationDecorator.toString((Object)operation);
        return new GenericFormatExportOperationContext(cruise, operation, operationLabel, persistenceService, weightComputingService, this.getSampleCategoryModel(), this.weightMeasuredCaracteristic, this.pmfmIdCaracteristic, this.deadOrAliveCaracteristic, this.genderCaracteristic);
    }

    @Override
    public void close() {
        for (CsvProducer<?, ?> csvProducer : this.producers()) {
            try {
                csvProducer.close();
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)("Could not close producer: " + csvProducer.getClass().getSimpleName()), (Throwable)e);
            }
        }
    }

    @Override
    public Iterator<GenericFormatExportCruiseContext> iterator() {
        return this.cruiseContexts.iterator();
    }

    public Set<CsvProducer<?, ?>> producers() {
        return Sets.newHashSet((Object[])new CsvProducer[]{this.producerForSurvey, this.producerForSpecies, this.producerForGearCaracteristics, this.producerForOperation, this.producerForParameter, this.producerForAccidentalCatch, this.producerForIndividualObservation, this.producerForCatch, this.producerForMarineLitter, this.producerForTemporaryGear, this.producerForTemporaryPerson, this.producerForTemporarySpecies, this.producerForTemporaryVessel, this.producerForSampleCategory, this.producerForAttachment});
    }

    protected GenericFormatExportConfiguration getExportConfiguration() {
        return this.exportRequest.getExportConfiguration();
    }
}

