/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches.multipost;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.AbstractSpeciesBatchFrequencys;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatchs;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.Attachments;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatchs;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatchs;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.data.SampleEntity;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequencys;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchs;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.multipost.MultiPostConstants;
import fr.ifremer.tutti.service.catches.multipost.MultiPostImportContext;
import fr.ifremer.tutti.service.catches.multipost.csv.AccidentalCatchRow;
import fr.ifremer.tutti.service.catches.multipost.csv.AccidentalCatchRowModel;
import fr.ifremer.tutti.service.catches.multipost.csv.AttachmentRow;
import fr.ifremer.tutti.service.catches.multipost.csv.AttachmentRowModel;
import fr.ifremer.tutti.service.catches.multipost.csv.CaracteristicRow;
import fr.ifremer.tutti.service.catches.multipost.csv.CaracteristicRowModel;
import fr.ifremer.tutti.service.catches.multipost.csv.CatchBatchRow;
import fr.ifremer.tutti.service.catches.multipost.csv.CatchBatchRowModel;
import fr.ifremer.tutti.service.catches.multipost.csv.CatchFrequencyRow;
import fr.ifremer.tutti.service.catches.multipost.csv.CatchFrequencyRowModel;
import fr.ifremer.tutti.service.catches.multipost.csv.CatchRow;
import fr.ifremer.tutti.service.catches.multipost.csv.CatchRowModel;
import fr.ifremer.tutti.service.catches.multipost.csv.CatchWeightsRow;
import fr.ifremer.tutti.service.catches.multipost.csv.CatchWeightsRowModel;
import fr.ifremer.tutti.service.catches.multipost.csv.FishingOperationRowModel;
import fr.ifremer.tutti.service.catches.multipost.csv.IndividualObservationRow;
import fr.ifremer.tutti.service.catches.multipost.csv.IndividualObservationRowModel;
import fr.ifremer.tutti.service.catches.multipost.csv.MarineLitterRow;
import fr.ifremer.tutti.service.catches.multipost.csv.MarineLitterRowModel;
import fr.ifremer.tutti.service.catches.multipost.csv.MarineLitterWeightRow;
import fr.ifremer.tutti.service.catches.multipost.csv.MarineLitterWeightRowModel;
import fr.ifremer.tutti.service.csv.CaracteristicValueParserFormatter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class MultiPostImportService
extends AbstractTuttiService
implements MultiPostConstants {
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;
    protected SampleCategoryModel sampleCategoryModel;
    protected Map<String, CaracteristicQualitativeValue> sampleCategoryValueMap;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
        this.sampleCategoryModel = context.getSampleCategoryModel();
        this.sampleCategoryValueMap = this.sampleCategoryModel.toMap();
    }

    public Map<String, Object> importCatchBatch(File file, FishingOperation operation) {
        return this.persistenceService.invoke(() -> {
            try (MultiPostImportContext importContext = new MultiPostImportContext(this.context, file, operation);){
                CatchBatchRowModel weightsModel = new CatchBatchRowModel();
                importContext.checkSameOperation("catchBatch.csv", weightsModel);
                HashMap<String, Object> notImportedData = new HashMap<String, Object>();
                CatchBatch catchBatch = this.importCatchWeights(importContext, weightsModel, notImportedData);
                this.importAttachments(importContext, catchBatch.getIdAsInt(), ObjectTypeCode.CATCH_BATCH);
                HashMap<String, Object> hashMap = notImportedData;
                return hashMap;
            }
        });
    }

    protected CatchBatch importCatchWeights(MultiPostImportContext importContext, CatchBatchRowModel weightsModel, Map<String, Object> notImportedData) throws IOException {
        CatchBatch catchBatch = null;
        try (Reader reader = importContext.newFileReader("catchBatch.csv");
             Import importer = Import.newImport((ImportModel)weightsModel, (Reader)reader);){
            Iterator iterator = importer.iterator();
            if (iterator.hasNext()) {
                CatchBatchRow row = (CatchBatchRow)iterator.next();
                FishingOperation operation = importContext.getOperation();
                catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operation.getIdAsInt());
                catchBatch.setFishingOperation(operation);
                if (catchBatch.getCatchTotalWeight() == null) {
                    catchBatch.setCatchTotalWeight(row.getCatchTotalWeight());
                } else if (row.getCatchTotalWeight() != null) {
                    notImportedData.put("catchTotalWeight", row.getCatchTotalWeight());
                }
                if (catchBatch.getCatchTotalRejectedWeight() == null) {
                    catchBatch.setCatchTotalRejectedWeight(row.getCatchTotalRejectedWeight());
                } else if (row.getCatchTotalRejectedWeight() != null) {
                    notImportedData.put("catchTotalRejectedWeight", row.getCatchTotalRejectedWeight());
                }
                if (catchBatch.getSpeciesTotalSortedWeight() == null) {
                    catchBatch.setSpeciesTotalSortedWeight(row.getSpeciesTotalSortedWeight());
                } else if (row.getSpeciesTotalSortedWeight() != null) {
                    notImportedData.put("speciesTotalSortedWeight", row.getSpeciesTotalSortedWeight());
                }
                if (catchBatch.getBenthosTotalSortedWeight() == null) {
                    catchBatch.setBenthosTotalSortedWeight(row.getBenthosTotalSortedWeight());
                } else if (row.getBenthosTotalSortedWeight() != null) {
                    notImportedData.put("benthosTotalSortedWeight", row.getBenthosTotalSortedWeight());
                }
                if (catchBatch.getMarineLitterTotalWeight() == null) {
                    catchBatch.setMarineLitterTotalWeight(row.getMarineLitterTotalWeight());
                } else if (row.getMarineLitterTotalWeight() != null) {
                    notImportedData.put("marineLitterTotalWeight", row.getMarineLitterTotalWeight());
                }
                this.persistenceService.saveCatchBatch(catchBatch);
            }
        }
        return catchBatch;
    }

    public Map<String, Object> importSpecies(File file, FishingOperation operation, boolean importFrequencies, boolean importIndividualObservations) {
        return this.persistenceService.invoke(() -> {
            try (MultiPostImportContext importContext = new MultiPostImportContext(this.context, file, operation);){
                CatchWeightsRowModel weightsModel = new CatchWeightsRowModel();
                importContext.checkSameOperation("weights.csv", weightsModel);
                HashMap<String, Object> notImportedData = new HashMap<String, Object>();
                LinkedHashMap<String, SpeciesBatch> notImportedBatches = new LinkedHashMap<String, SpeciesBatch>();
                BatchContainer<SpeciesBatch> speciesBatches = this.persistenceService.getRootSpeciesBatch(operation.getIdAsInt(), false);
                Map<String, SpeciesBatch> batches = this.importSpeciesBatches(importContext, speciesBatches, notImportedBatches);
                if (importFrequencies) {
                    ListMultimap<String, SpeciesBatchFrequency> frequencyListMultimap = this.importFrequencies(importContext, batches, notImportedBatches, AbstractSpeciesBatchFrequencys::newSpeciesBatchFrequency);
                    for (String batchId : frequencyListMultimap.keySet()) {
                        List frequencies = frequencyListMultimap.get((Object)batchId);
                        SpeciesBatch speciesBatch = batches.get(batchId);
                        frequencies.forEach(speciesBatchFrequency -> speciesBatchFrequency.setBatch(speciesBatch));
                        this.persistenceService.saveSpeciesBatchFrequency(speciesBatch.getIdAsInt(), frequencies);
                    }
                }
                if (importIndividualObservations) {
                    Map<String, IndividualObservationBatch> individualObservationsBatches = this.importIndividualObservationBatches(importContext, batches, notImportedBatches);
                    this.importCaracteristics(importContext, individualObservationsBatches);
                    this.persistenceService.createIndividualObservationBatches(individualObservationsBatches.values());
                    this.importAttachments(importContext, individualObservationsBatches, ObjectTypeCode.SAMPLE);
                }
                this.importAttachments(importContext, batches, notImportedBatches, ObjectTypeCode.BATCH);
                this.importSpeciesWeights(importContext, weightsModel, notImportedData);
                notImportedData.put("batchesKey", notImportedBatches.values());
                HashMap<String, Object> hashMap = notImportedData;
                return hashMap;
            }
        });
    }

    protected Map<String, SpeciesBatch> importSpeciesBatches(MultiPostImportContext importContext, BatchContainer<SpeciesBatch> speciesBatches, Map<String, SpeciesBatch> notImportedBatches) throws IOException {
        HashMap<String, SpeciesBatch> batches = new HashMap<String, SpeciesBatch>();
        try (Reader reader = importContext.newFileReader("species.csv");){
            CatchRowModel csvModel = CatchRowModel.forImport(importContext.getSpeciesList());
            try (Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);){
                for (CatchRow row : importer) {
                    SpeciesBatch batch = SpeciesBatchs.newSpeciesBatch();
                    batch.setFishingOperation(importContext.getOperation());
                    Species species = row.getSpecies();
                    batch.setSpecies(row.getSpecies());
                    batch.setWeight(row.getWeight());
                    batch.setNumber(row.getNumber());
                    batch.setComment(row.getComment());
                    batch.setSpeciesToConfirm(row.isToConfirm());
                    Pair<Integer, Serializable> valueAndCategoryType = this.getValueAndCategoryType(row);
                    Integer categoryId = (Integer)valueAndCategoryType.getKey();
                    Serializable value = (Serializable)valueAndCategoryType.getValue();
                    batch.setSampleCategoryId(categoryId);
                    batch.setSampleCategoryValue(value);
                    batch.setSampleCategoryWeight(row.getCategoryWeight());
                    String parentId = row.getParentId();
                    Integer parentPersistedId = null;
                    SpeciesBatch parent = null;
                    if (StringUtils.isNotEmpty((CharSequence)parentId)) {
                        parent = (SpeciesBatch)batches.get(parentId);
                        parentPersistedId = parent.getIdAsInt();
                    }
                    SpeciesBatch existingBatch = null;
                    List batchesToBrowse = parent == null ? speciesBatches.getChildren() : parent.getChildBatchs();
                    if (batchesToBrowse != null) {
                        for (SpeciesBatch sb : batchesToBrowse) {
                            if (!sb.getSpecies().equals(species) || sb.getSampleCategoryId().equals(batch.getSampleCategoryId()) && !sb.getSampleCategoryValue().equals(value)) continue;
                            existingBatch = sb;
                            batches.put(row.getId(), sb);
                            notImportedBatches.put(row.getId(), batch);
                            break;
                        }
                    }
                    if (existingBatch != null) continue;
                    batch = this.persistenceService.createSpeciesBatch(batch, parentPersistedId, true);
                    batches.put(row.getId(), batch);
                }
            }
        }
        return batches;
    }

    protected void importSpeciesWeights(MultiPostImportContext importContext, CatchWeightsRowModel weightsModel, Map<String, Object> notImportedData) throws IOException {
        try (Reader reader = importContext.newFileReader("weights.csv");
             Import importer = Import.newImport((ImportModel)weightsModel, (Reader)reader);){
            Iterator iterator = importer.iterator();
            if (iterator.hasNext()) {
                FishingOperation operation = importContext.getOperation();
                CatchWeightsRow row = (CatchWeightsRow)iterator.next();
                CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operation.getIdAsInt());
                catchBatch.setFishingOperation(operation);
                if (catchBatch.getSpeciesTotalSortedWeight() == null) {
                    catchBatch.setSpeciesTotalSortedWeight(row.getTotalSortedWeight());
                } else if (row.getTotalSortedWeight() != null) {
                    notImportedData.put("speciesTotalSortedWeight", row.getTotalSortedWeight());
                }
                if (catchBatch.getSpeciesTotalInertWeight() == null) {
                    catchBatch.setSpeciesTotalInertWeight(row.getInertWeight());
                } else if (row.getInertWeight() != null) {
                    notImportedData.put("speciesTotalInertWeight", row.getInertWeight());
                }
                if (catchBatch.getSpeciesTotalLivingNotItemizedWeight() == null) {
                    catchBatch.setSpeciesTotalLivingNotItemizedWeight(row.getLivingNotItemizedWeight());
                } else if (row.getLivingNotItemizedWeight() != null) {
                    notImportedData.put("speciesTotalLivingNotItemizedWeight", row.getLivingNotItemizedWeight());
                }
                this.persistenceService.saveCatchBatch(catchBatch);
            }
        }
    }

    public Map<String, Object> importSpeciesBatch(File file, FishingOperation operation, SpeciesBatch speciesBatch, boolean importFrequencies, boolean importIndividualObservations) {
        return this.persistenceService.invoke(() -> {
            try (MultiPostImportContext importContext = new MultiPostImportContext(this.context, file, operation);){
                if (importFrequencies) {
                    List<SpeciesBatchFrequency> frequenciesToSave = this.importFrequencies(importContext, speciesBatch, AbstractSpeciesBatchFrequencys::newSpeciesBatchFrequency);
                    frequenciesToSave.forEach(speciesBatchFrequency -> speciesBatchFrequency.setBatch(speciesBatch));
                    this.persistenceService.saveSpeciesBatchFrequency(speciesBatch.getIdAsInt(), frequenciesToSave);
                }
                if (importIndividualObservations) {
                    Map<String, IndividualObservationBatch> individualObservationsBatches = this.importIndividualObservationBatches(importContext, speciesBatch);
                    this.importCaracteristics(importContext, individualObservationsBatches);
                    this.persistenceService.createIndividualObservationBatches(individualObservationsBatches.values());
                    this.importAttachments(importContext, individualObservationsBatches, ObjectTypeCode.SAMPLE);
                }
                HashMap hashMap = new HashMap();
                return hashMap;
            }
        });
    }

    public Map<String, Object> importBenthos(File file, FishingOperation operation, boolean importFrequencies, boolean importIndividualObservations) {
        return this.persistenceService.invoke(() -> {
            try (MultiPostImportContext importContext = new MultiPostImportContext(this.context, file, operation);){
                CatchWeightsRowModel weightsModel = new CatchWeightsRowModel();
                importContext.checkSameOperation("weights.csv", weightsModel);
                HashMap<String, Object> notImportedData = new HashMap<String, Object>();
                LinkedHashMap<String, SpeciesBatch> notImportedBatches = new LinkedHashMap<String, SpeciesBatch>();
                BatchContainer<SpeciesBatch> benthosBatches = this.persistenceService.getRootBenthosBatch(operation.getIdAsInt(), false);
                Map<String, SpeciesBatch> batches = this.importBenthosBatches(importContext, benthosBatches, notImportedBatches);
                if (importFrequencies) {
                    ListMultimap<String, SpeciesBatchFrequency> frequencyListMultimap = this.importFrequencies(importContext, batches, notImportedBatches, SpeciesBatchFrequencys::newBenthosBatchFrequency);
                    for (String batchId : frequencyListMultimap.keySet()) {
                        List frequencies = frequencyListMultimap.get((Object)batchId);
                        SpeciesBatch speciesBatch = batches.get(batchId);
                        frequencies.forEach(speciesBatchFrequency -> speciesBatchFrequency.setBatch(speciesBatch));
                        this.persistenceService.saveBenthosBatchFrequency(speciesBatch.getIdAsInt(), frequencies);
                    }
                }
                if (importIndividualObservations) {
                    Map<String, IndividualObservationBatch> individualObservationsBatches = this.importIndividualObservationBatches(importContext, batches, notImportedBatches);
                    this.importCaracteristics(importContext, individualObservationsBatches);
                    this.persistenceService.createIndividualObservationBatches(individualObservationsBatches.values());
                    this.importAttachments(importContext, individualObservationsBatches, ObjectTypeCode.SAMPLE);
                }
                this.importAttachments(importContext, batches, notImportedBatches, ObjectTypeCode.BATCH);
                this.importBenthosWeights(importContext, weightsModel, notImportedData);
                notImportedData.put("batchesKey", notImportedBatches.values());
                HashMap<String, Object> hashMap = notImportedData;
                return hashMap;
            }
        });
    }

    protected Map<String, SpeciesBatch> importBenthosBatches(MultiPostImportContext importContext, BatchContainer<SpeciesBatch> benthosBatches, Map<String, SpeciesBatch> notImportedBatches) throws IOException {
        HashMap<String, SpeciesBatch> batches = new HashMap<String, SpeciesBatch>();
        try (Reader reader = importContext.newFileReader("benthos.csv");){
            CatchRowModel csvModel = CatchRowModel.forImport(importContext.getSpeciesList());
            try (Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);){
                FishingOperation operation = importContext.getOperation();
                for (CatchRow row : importer) {
                    SpeciesBatch batch = SpeciesBatchs.newBenthosBatch();
                    batch.setFishingOperation(operation);
                    Species species = row.getSpecies();
                    batch.setSpecies(row.getSpecies());
                    batch.setWeight(row.getWeight());
                    batch.setNumber(row.getNumber());
                    batch.setComment(row.getComment());
                    batch.setSpeciesToConfirm(row.isToConfirm());
                    Pair<Integer, Serializable> valueAndCategoryType = this.getValueAndCategoryType(row);
                    Integer categoryId = (Integer)valueAndCategoryType.getKey();
                    Serializable value = (Serializable)valueAndCategoryType.getValue();
                    batch.setSampleCategoryId(categoryId);
                    batch.setSampleCategoryValue(value);
                    batch.setSampleCategoryWeight(row.getCategoryWeight());
                    String parentId = row.getParentId();
                    Integer parentPersistedId = null;
                    SpeciesBatch parent = null;
                    if (StringUtils.isNotEmpty((CharSequence)parentId)) {
                        parent = (SpeciesBatch)batches.get(parentId);
                        parentPersistedId = parent.getIdAsInt();
                    }
                    SpeciesBatch existingBatch = null;
                    List batchesToBrowse = parent == null ? benthosBatches.getChildren() : parent.getChildBatchs();
                    if (batchesToBrowse != null) {
                        for (SpeciesBatch bb : batchesToBrowse) {
                            if (!bb.getSpecies().equals(species) || bb.getSampleCategoryId().equals(batch.getSampleCategoryId()) && !bb.getSampleCategoryValue().equals(value)) continue;
                            existingBatch = bb;
                            batches.put(row.getId(), bb);
                            notImportedBatches.put(row.getId(), batch);
                            break;
                        }
                    }
                    if (existingBatch != null) continue;
                    batch = this.persistenceService.createBenthosBatch(batch, parentPersistedId, true);
                    batches.put(row.getId(), batch);
                }
            }
        }
        return batches;
    }

    protected void importBenthosWeights(MultiPostImportContext importContext, CatchWeightsRowModel weightsModel, Map<String, Object> notImportedData) throws IOException {
        try (Reader reader = importContext.newFileReader("weights.csv");
             Import importer = Import.newImport((ImportModel)weightsModel, (Reader)reader);){
            Iterator iterator = importer.iterator();
            if (iterator.hasNext()) {
                FishingOperation operation = importContext.getOperation();
                CatchWeightsRow row = (CatchWeightsRow)iterator.next();
                CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operation.getIdAsInt());
                catchBatch.setFishingOperation(operation);
                if (catchBatch.getBenthosTotalSortedWeight() == null) {
                    catchBatch.setBenthosTotalSortedWeight(row.getTotalSortedWeight());
                } else if (row.getTotalSortedWeight() != null) {
                    notImportedData.put("benthosTotalSortedWeight", row.getTotalSortedWeight());
                }
                if (catchBatch.getBenthosTotalInertWeight() == null) {
                    catchBatch.setBenthosTotalInertWeight(row.getInertWeight());
                } else if (row.getInertWeight() != null) {
                    notImportedData.put("benthosTotalInertWeight", row.getInertWeight());
                }
                if (catchBatch.getBenthosTotalLivingNotItemizedWeight() == null) {
                    catchBatch.setBenthosTotalLivingNotItemizedWeight(row.getLivingNotItemizedWeight());
                } else if (row.getLivingNotItemizedWeight() != null) {
                    notImportedData.put("benthosTotalLivingNotItemizedWeight", row.getLivingNotItemizedWeight());
                }
                this.persistenceService.saveCatchBatch(catchBatch);
            }
        }
    }

    public Map<String, Object> importBenthosBatch(File file, FishingOperation operation, SpeciesBatch speciesBatch, boolean importFrequencies, boolean importIndividualObservations) {
        return this.persistenceService.invoke(() -> {
            try (MultiPostImportContext importContext = new MultiPostImportContext(this.context, file, operation);){
                if (importFrequencies) {
                    List<SpeciesBatchFrequency> frequenciesToSave = this.importFrequencies(importContext, speciesBatch, AbstractSpeciesBatchFrequencys::newSpeciesBatchFrequency);
                    frequenciesToSave.forEach(speciesBatchFrequency -> speciesBatchFrequency.setBatch(speciesBatch));
                    this.persistenceService.saveBenthosBatchFrequency(speciesBatch.getIdAsInt(), frequenciesToSave);
                }
                if (importIndividualObservations) {
                    Map<String, IndividualObservationBatch> individualObservationsBatches = this.importIndividualObservationBatches(importContext, speciesBatch);
                    this.importCaracteristics(importContext, individualObservationsBatches);
                    this.persistenceService.createIndividualObservationBatches(individualObservationsBatches.values());
                    this.importAttachments(importContext, individualObservationsBatches, ObjectTypeCode.SAMPLE);
                }
                HashMap hashMap = new HashMap();
                return hashMap;
            }
        });
    }

    public Map<String, Object> importMarineLitter(File file, FishingOperation operation) {
        return this.persistenceService.invoke(() -> {
            try (MultiPostImportContext importContext = new MultiPostImportContext(this.context, file, operation);){
                MarineLitterWeightRowModel weightModel = new MarineLitterWeightRowModel();
                importContext.checkSameOperation("weights.csv", weightModel);
                HashMap<String, Object> notImportedData = new HashMap<String, Object>();
                LinkedHashMap<String, MarineLitterBatch> notImportedBatches = new LinkedHashMap<String, MarineLitterBatch>();
                Map<String, MarineLitterBatch> batches = this.importMarineLitterBatches(importContext, notImportedBatches);
                this.importAttachments(importContext, batches, notImportedBatches, ObjectTypeCode.BATCH);
                this.importMarineLitterCatchWeights(importContext, weightModel, notImportedData);
                notImportedData.put("batchesKey", notImportedBatches.values());
                HashMap<String, Object> hashMap = notImportedData;
                return hashMap;
            }
        });
    }

    protected Map<String, MarineLitterBatch> importMarineLitterBatches(MultiPostImportContext importContext, Map<String, MarineLitterBatch> notImportedBatches) throws IOException {
        LinkedHashMap<String, MarineLitterBatch> batches = new LinkedHashMap<String, MarineLitterBatch>();
        FishingOperation operation = importContext.getOperation();
        BatchContainer<MarineLitterBatch> marineLitterBatches = this.persistenceService.getRootMarineLitterBatch(operation.getIdAsInt());
        Caracteristic categoryCaracteristic = this.persistenceService.getMarineLitterCategoryCaracteristic();
        Caracteristic sizeCategoryCaracteristic = this.persistenceService.getMarineLitterSizeCategoryCaracteristic();
        try (Reader reader = importContext.newFileReader("marineLitter.csv");){
            MarineLitterRowModel csvModel = MarineLitterRowModel.forImport(categoryCaracteristic, sizeCategoryCaracteristic);
            try (Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);){
                for (MarineLitterRow row : importer) {
                    MarineLitterBatch batch = MarineLitterBatchs.newMarineLitterBatch();
                    batch.setFishingOperation(operation);
                    batch.setWeight(row.getWeight());
                    batch.setNumber(row.getNumber());
                    batch.setComment(row.getComment());
                    batch.setMarineLitterCategory(row.getCategory());
                    batch.setMarineLitterSizeCategory(row.getSizeCategory());
                    MarineLitterBatch existingBatch = null;
                    List batchesToBrowse = marineLitterBatches.getChildren();
                    if (batchesToBrowse != null) {
                        for (MarineLitterBatch mlb : batchesToBrowse) {
                            if (!mlb.getMarineLitterCategory().equals(batch.getMarineLitterCategory()) || !mlb.getMarineLitterSizeCategory().equals(batch.getMarineLitterSizeCategory())) continue;
                            existingBatch = mlb;
                            batches.put(row.getBatchId(), mlb);
                            notImportedBatches.put(row.getBatchId(), batch);
                            break;
                        }
                    }
                    if (existingBatch != null) continue;
                    batch = this.persistenceService.createMarineLitterBatch(batch);
                    batches.put(row.getBatchId(), batch);
                }
            }
        }
        return batches;
    }

    protected void importMarineLitterCatchWeights(MultiPostImportContext importContext, MarineLitterWeightRowModel weightModel, Map<String, Object> notImportedData) throws IOException {
        try (Reader reader = importContext.newFileReader("weights.csv");
             Import weight = Import.newImport((ImportModel)weightModel, (Reader)reader);){
            Iterator iterator = weight.iterator();
            if (iterator.hasNext()) {
                FishingOperation operation = importContext.getOperation();
                MarineLitterWeightRow row = (MarineLitterWeightRow)iterator.next();
                CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operation.getIdAsInt());
                catchBatch.setFishingOperation(operation);
                if (catchBatch.getMarineLitterTotalWeight() == null) {
                    catchBatch.setMarineLitterTotalWeight(row.getTotalWeight());
                } else if (row.getTotalWeight() != null) {
                    notImportedData.put("marineLitterTotalWeight", row.getTotalWeight());
                }
                this.persistenceService.saveCatchBatch(catchBatch);
            }
        }
    }

    public void importAccidentalCatches(File file, FishingOperation operation) {
        this.persistenceService.invoke(() -> {
            try (MultiPostImportContext importContext = new MultiPostImportContext(this.context, file, operation);){
                FishingOperationRowModel operationModel = new FishingOperationRowModel();
                importContext.checkSameOperation("weights.csv", operationModel);
                Map<String, AccidentalBatch> accidentalBatches = this.importAccidentalCatchesBatches(importContext);
                this.importCaracteristics(importContext, accidentalBatches);
                this.persistenceService.createAccidentalBatches(accidentalBatches.values());
                this.importAttachments(importContext, accidentalBatches, ObjectTypeCode.SAMPLE);
                Object var7_8 = null;
                return var7_8;
            }
        });
    }

    protected Map<String, AccidentalBatch> importAccidentalCatchesBatches(MultiPostImportContext importContext) throws IOException {
        LinkedHashMap<String, AccidentalBatch> batches = new LinkedHashMap<String, AccidentalBatch>();
        Caracteristic sexCaracteristic = this.persistenceService.getSexCaracteristic();
        Caracteristic deadOrAliveCaracteristic = this.persistenceService.getDeadOrAliveCaracteristic();
        try (Reader reader = importContext.newFileReader("accidentalCatches.csv");){
            AccidentalCatchRowModel csvModel = AccidentalCatchRowModel.forImport(importContext.getSpeciesList(), sexCaracteristic, deadOrAliveCaracteristic, importContext.getCaracteristicsWithProtected());
            try (Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);){
                FishingOperation operation = importContext.getOperation();
                for (AccidentalCatchRow row : importer) {
                    AccidentalBatch batch = AccidentalBatchs.newAccidentalBatch();
                    batch.setFishingOperation(operation);
                    batch.setSpecies(row.getSpecies());
                    batch.setGender(row.getGender());
                    batch.setWeight(row.getWeight());
                    batch.setSize(row.getSize());
                    batch.setLengthStepCaracteristic(row.getLengthStepCaracteristic());
                    batch.setDeadOrAlive(row.getDeadOrAlive());
                    batch.setComment(row.getComment());
                    batch.setCaracteristics(new CaracteristicMap());
                    batches.put(row.getBatchId(), batch);
                }
            }
        }
        return batches;
    }

    protected Pair<Integer, Serializable> getValueAndCategoryType(CatchRow row) {
        Serializable value = row.getCategoryValue();
        Integer categoryId = row.getCategoryId();
        SampleCategoryModelEntry categoryModelEntry = this.sampleCategoryModel.getCategoryById(categoryId);
        Caracteristic caracteristic = categoryModelEntry.getCaracteristic();
        if (caracteristic.getCaracteristicType() == CaracteristicType.QUALITATIVE) {
            CaracteristicQualitativeValue caracteristicQualitativeValue = this.sampleCategoryValueMap.get(String.valueOf(value));
            Preconditions.checkNotNull((Object)caracteristicQualitativeValue, (Object)("Can't find caracteristic qualitative value with id: " + value + " for caracteristic of id: " + categoryId));
            value = caracteristicQualitativeValue;
        }
        return Pair.of((Object)categoryId, (Object)value);
    }

    protected void importAttachments(MultiPostImportContext importContext, Integer catchBatchId, ObjectTypeCode objectType) throws IOException {
        Function getObjetcIdFunction = input -> catchBatchId;
        this.importAttachments(importContext, (Function<AttachmentRow, Integer>)getObjetcIdFunction, objectType);
    }

    protected <R extends TuttiEntity> void importAttachments(MultiPostImportContext importContext, Map<String, R> data, Map<String, R> notImportedData, ObjectTypeCode objectType) throws IOException {
        Function getObjetcIdFunction = input -> {
            TuttiEntity batch;
            Integer result = null;
            if (notImportedData.get(input.getBatchId()) == null && (batch = (TuttiEntity)data.get(input.getBatchId())) != null) {
                result = batch.getIdAsInt();
            }
            return result;
        };
        this.importAttachments(importContext, (Function<AttachmentRow, Integer>)getObjetcIdFunction, objectType);
    }

    protected <R extends TuttiEntity> void importAttachments(MultiPostImportContext importContext, Map<String, R> data, ObjectTypeCode objectType) throws IOException {
        Function getObjetcIdFunction = input -> {
            Integer result = null;
            TuttiEntity batch = (TuttiEntity)data.get(input.getBatchId());
            if (batch != null) {
                result = batch.getIdAsInt();
            }
            return result;
        };
        this.importAttachments(importContext, (Function<AttachmentRow, Integer>)getObjetcIdFunction, objectType);
    }

    protected void importAttachments(MultiPostImportContext importContext, Function<AttachmentRow, Integer> getObjetcIdFunction, ObjectTypeCode objectType) throws IOException {
        try (Reader reader = importContext.newFileReader("attachments.csv");){
            AttachmentRowModel attachmentModel = AttachmentRowModel.forImport(importContext.newFile("attachments"));
            try (Import importer = Import.newImport((ImportModel)attachmentModel, (Reader)reader);){
                for (AttachmentRow row : importer) {
                    Integer objectId = (Integer)getObjetcIdFunction.apply((Object)row);
                    if (objectId == null) continue;
                    Attachment attachment = Attachments.newAttachment();
                    attachment.setName(row.getName());
                    attachment.setComment(row.getComment());
                    attachment.setObjectType(objectType);
                    attachment.setObjectId(objectId);
                    this.persistenceService.createAttachment(attachment, row.getFile());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <B extends SampleEntity> void importCaracteristics(MultiPostImportContext importContext, Map<String, B> batches) throws IOException {
        try (Reader reader = importContext.newFileReader("caracteristics.csv");){
            CaracteristicRowModel caracteristicModel = CaracteristicRowModel.forImport(importContext.getCaracteristicsWithProtected());
            try (Import importer = Import.newImport((ImportModel)caracteristicModel, (Reader)reader);){
                for (CaracteristicRow caracteristicRow : importer) {
                    SampleEntity batch = (SampleEntity)batches.get(caracteristicRow.getBatchId());
                    if (batch == null) continue;
                    Caracteristic caracteristic = caracteristicRow.getCaracteristic();
                    CaracteristicValueParserFormatter parser = CaracteristicValueParserFormatter.newParser(caracteristic);
                    Serializable value = caracteristicRow.getValue();
                    try {
                        Serializable caracteristicValue = parser.parse(String.valueOf(value));
                        batch.getCaracteristics().put(caracteristic, caracteristicValue);
                    }
                    catch (ParseException e) {
                        throw new ApplicationTechnicalException("Could not parse caracteristic value: " + value, (Throwable)e);
                        return;
                    }
                }
            }
        }
    }

    protected Map<String, IndividualObservationBatch> importIndividualObservationBatches(MultiPostImportContext importContext, Map<String, SpeciesBatch> speciesOrBenthosBatches, Map<String, SpeciesBatch> notImportedBatches) throws IOException {
        LinkedHashMap<String, IndividualObservationBatch> batches = new LinkedHashMap<String, IndividualObservationBatch>();
        try (Reader reader = importContext.newFileReader("individualObservation.csv");){
            IndividualObservationRowModel csvModel = IndividualObservationRowModel.forImport(importContext.getSpeciesList(), importContext.getCaracteristicsWithProtected());
            try (Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);){
                FishingOperation operation = importContext.getOperation();
                for (IndividualObservationRow row : importer) {
                    SpeciesBatch speciesOfBenthosBatch;
                    String speciesBatchId = row.getSpeciesBatchId();
                    if (notImportedBatches.containsKey(speciesBatchId) || (speciesOfBenthosBatch = speciesOrBenthosBatches.get(speciesBatchId)) == null) continue;
                    IndividualObservationBatch batch = IndividualObservationBatchs.newIndividualObservationBatch();
                    batch.setFishingOperation(operation);
                    batch.setBatchId(speciesOfBenthosBatch.getIdAsInt());
                    batch.setSpecies(row.getSpecies());
                    batch.setWeight(row.getWeight());
                    batch.setSize(row.getSize());
                    batch.setLengthStepCaracteristic(row.getLengthStepCaracteristic());
                    batch.setComment(row.getComment());
                    batch.setCaracteristics(new CaracteristicMap());
                    batches.put(row.getBatchId(), batch);
                }
            }
        }
        return batches;
    }

    protected ListMultimap<String, SpeciesBatchFrequency> importFrequencies(MultiPostImportContext importContext, Map<String, SpeciesBatch> batches, Map<String, SpeciesBatch> notImportedBatches, Supplier<SpeciesBatchFrequency> newFrequencySupplier) throws IOException {
        ArrayListMultimap frequencyMap = ArrayListMultimap.create();
        try (Reader reader = importContext.newFileReader("frequencies.csv");){
            CatchFrequencyRowModel frequencyModel = CatchFrequencyRowModel.forImport(importContext.getSpeciesList(), importContext.getCaracteristics());
            try (Import importer = Import.newImport((ImportModel)frequencyModel, (Reader)reader);){
                for (CatchFrequencyRow frequencyRow : importer) {
                    SpeciesBatch batch;
                    String frequencyRowBatchId = frequencyRow.getBatchId();
                    if (!notImportedBatches.containsKey(frequencyRowBatchId) || (batch = batches.get(frequencyRowBatchId)) == null) continue;
                    SpeciesBatchFrequency frequency = newFrequencySupplier.get();
                    frequency.setLengthStepCaracteristic(frequencyRow.getLengthStepCaracteristic());
                    frequency.setLengthStep(frequencyRow.getLengthStep());
                    frequency.setNumber(frequencyRow.getNumber());
                    frequency.setWeight(frequencyRow.getWeight());
                    frequencyMap.put((Object)frequencyRowBatchId, (Object)frequency);
                }
            }
        }
        return frequencyMap;
    }

    protected List<SpeciesBatchFrequency> importFrequencies(MultiPostImportContext importContext, SpeciesBatch speciesBatch, Supplier<SpeciesBatchFrequency> newFrequencySupplier) throws IOException {
        LinkedList<SpeciesBatchFrequency> frequenciesToSave = new LinkedList<SpeciesBatchFrequency>();
        try (Reader reader = importContext.newFileReader("frequencies.csv");){
            CatchFrequencyRowModel frequencyModel = CatchFrequencyRowModel.forImport(importContext.getSpeciesList(), importContext.getCaracteristics());
            try (Import importer = Import.newImport((ImportModel)frequencyModel, (Reader)reader);){
                Integer requiredSpeciesId = speciesBatch.getSpecies().getIdAsInt();
                for (CatchFrequencyRow frequencyRow : importer) {
                    Integer speciesId = frequencyRow.getSpecies().getIdAsInt();
                    if (!requiredSpeciesId.equals(speciesId)) {
                        Decorator<Species> fishingOperationDecorator = this.context.getService(DecoratorService.class).getDecoratorByType(Species.class);
                        throw new ApplicationBusinessException(I18n.t((String)"tutti.service.multipost.import.wrongSpecies.error", (Object[])new Object[]{fishingOperationDecorator.toString((Object)speciesBatch.getSpecies())}));
                    }
                    SpeciesBatchFrequency frequency = newFrequencySupplier.get();
                    frequency.setLengthStepCaracteristic(frequencyRow.getLengthStepCaracteristic());
                    frequency.setLengthStep(frequencyRow.getLengthStep());
                    frequency.setNumber(frequencyRow.getNumber());
                    frequency.setWeight(frequencyRow.getWeight());
                    frequenciesToSave.add(frequency);
                }
            }
        }
        return frequenciesToSave;
    }

    protected Map<String, IndividualObservationBatch> importIndividualObservationBatches(MultiPostImportContext importContext, SpeciesBatch speciesOfBenthosBatch) throws IOException {
        LinkedHashMap<String, IndividualObservationBatch> batches = new LinkedHashMap<String, IndividualObservationBatch>();
        try (Reader reader = importContext.newFileReader("individualObservation.csv");){
            IndividualObservationRowModel csvModel = IndividualObservationRowModel.forImport(importContext.getSpeciesList(), importContext.getCaracteristicsWithProtected());
            try (Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);){
                FishingOperation operation = importContext.getOperation();
                Integer requiredSpeciesId = speciesOfBenthosBatch.getSpecies().getIdAsInt();
                Integer speciesOrBenthosBatchId = speciesOfBenthosBatch.getIdAsInt();
                for (IndividualObservationRow row : importer) {
                    if (!requiredSpeciesId.equals(row.getSpecies().getIdAsInt())) {
                        Decorator<Species> fishingOperationDecorator = this.context.getService(DecoratorService.class).getDecoratorByType(Species.class);
                        throw new ApplicationBusinessException(I18n.t((String)"tutti.service.multipost.import.wrongSpecies.error", (Object[])new Object[]{fishingOperationDecorator.toString((Object)speciesOfBenthosBatch.getSpecies())}));
                    }
                    IndividualObservationBatch batch = IndividualObservationBatchs.newIndividualObservationBatch();
                    batch.setFishingOperation(operation);
                    batch.setBatchId(speciesOrBenthosBatchId);
                    batch.setSpecies(row.getSpecies());
                    batch.setWeight(row.getWeight());
                    batch.setSize(row.getSize());
                    batch.setLengthStepCaracteristic(row.getLengthStepCaracteristic());
                    batch.setComment(row.getComment());
                    batch.setCaracteristics(new CaracteristicMap());
                    batches.put(row.getBatchId(), batch);
                }
            }
        }
        return batches;
    }
}

