/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.service.samplingCache.CruiseSamplingCache;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchTableModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.Color;
import java.awt.Component;
import java.util.EventObject;
import java.util.Optional;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SamplingCodeCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SamplingCodeCellEditor.class);
    protected JTable table;
    protected IndividualObservationBatchTableModel tableModel;
    protected Integer rowIndex;
    protected Integer columnIndex;
    protected final SampleCodeGenerator editorButton;

    public static TableCellEditor newEditor(TuttiUI ui) {
        return new SamplingCodeCellEditor(ui.getHandler().getContext());
    }

    public SamplingCodeCellEditor(TuttiUIContext context) {
        this.editorButton = new SampleCodeGenerator(context);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.tableModel = (IndividualObservationBatchTableModel)((Object)table.getModel());
        this.rowIndex = row;
        this.columnIndex = column;
        this.editorButton.setRow((IndividualObservationBatchRowModel)this.tableModel.getEntry(row));
        return this.editorButton;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    @Override
    public Object getCellEditorValue() {
        IndividualObservationBatchRowModel model = this.editorButton.getRow();
        Preconditions.checkNotNull((Object)model, (Object)"No model found in editor.");
        String result = model.getSamplingCode();
        if (log.isDebugEnabled()) {
            log.debug((Object)("editor value: " + result));
        }
        return result;
    }

    @Override
    public boolean stopCellEditing() {
        boolean b = super.stopCellEditing();
        if (b) {
            this.editorButton.setRow(null);
        }
        return b;
    }

    @Override
    public void cancelCellEditing() {
        this.editorButton.setRow(null);
        super.cancelCellEditing();
    }

    public class SampleCodeGenerator
    extends JButton {
        final TuttiUIContext context;
        IndividualObservationBatchRowModel row;

        SampleCodeGenerator(TuttiUIContext context) {
            this.context = context;
            this.setBorder(new LineBorder(Color.BLACK));
            this.setText(I18n.t((String)"tutti.editIndividualObservationBatch.table.editor.codeSampleGenerator.label", (Object[])new Object[0]));
            this.addActionListener(evt -> this.generateCode());
        }

        public IndividualObservationBatchRowModel getRow() {
            return this.row;
        }

        public void setRow(IndividualObservationBatchRowModel row) {
            this.row = row;
        }

        protected void generateCode() {
            Optional optionalCruiseSamplingCache = this.context.getDataContext().getOptionalCruiseSamplingCache();
            if (optionalCruiseSamplingCache.isPresent()) {
                int i = ((CruiseSamplingCache)optionalCruiseSamplingCache.get()).getNextSamplingCodeId(this.getRow().getSpecies().getReferenceTaxonId());
                this.row.setSamplingCodeId(i);
            }
            SamplingCodeCellEditor.this.stopCellEditing();
        }
    }
}

