/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.actions;

import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.catches.TuttiWeightComputingException;
import fr.ifremer.tutti.service.catches.WeightCleaningService;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SampleCategoryColumnIdentifier;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchNaturalOrderComparator;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesSortMode;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import fr.ifremer.tutti.util.Numbers;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import jaxx.runtime.swing.JTables;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;

public class ComputeBatchWeightsAction
extends LongActionSupport<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {
    protected final WeightCleaningService cleaningService = this.getContext().getWeightCleaningService();
    protected List<SpeciesBatchRowModel> speciesBatchRows;
    protected List<SpeciesBatchRowModel> benthosBatchRows;
    protected CatchBatch catchBatch;
    protected Boolean modified;
    protected Integer tabInError;

    public ComputeBatchWeightsAction(EditCatchesUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        this.speciesBatchRows = null;
        this.benthosBatchRows = null;
        this.catchBatch = null;
        this.modified = null;
        this.tabInError = null;
        boolean doAction = super.prepareAction();
        if (doAction) {
            FishingOperation fishingOperation = ((EditCatchesUIModel)this.getModel()).getFishingOperation();
            Multimap errors = this.cleaningService.checkFishingOperation(fishingOperation.getIdAsInt());
            if (errors.isEmpty()) {
                this.sendMessage(I18n.t((String)"tutti.editCatchBatch.action.computeWeights.no.double.weight.detected", (Object[])new Object[0]));
            } else {
                String errorsStr = this.cleaningService.errorsToString(errors);
                String htmlMessage = I18n.t((String)"tutti.editCatchBatch.action.computeWeights.double.weight.detected", (Object[])new Object[]{errorsStr});
                JOptionPane.showMessageDialog((Component)this.getContext().getActionUI(), htmlMessage, I18n.t((String)"tutti.editCatchBatch.action.computeWeights.double.weight.detected.title", (Object[])new Object[0]), 2);
            }
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        int answer;
        String htmlMessage;
        BatchContainer computedMarineLitterBatches;
        Float totalBenthosSortedWeight;
        BatchContainer computedBenthosBatches;
        Float totalSpeciesSortedWeight;
        BatchContainer computedSpeciesBatches;
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        WeightComputingService weightComputingService = this.getContext().getWeightComputingService();
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        Integer operationId = model.getFishingOperation().getIdAsInt();
        try {
            computedSpeciesBatches = weightComputingService.getComputedSpeciesBatches(operationId);
            if (computedSpeciesBatches == null) {
                totalSpeciesSortedWeight = Float.valueOf(0.0f);
            } else {
                this.speciesBatchRows = new ArrayList<SpeciesBatchRowModel>();
                totalSpeciesSortedWeight = this.computeSpeciesBatches(persistenceService, computedSpeciesBatches, this.speciesBatchRows);
            }
        }
        catch (TuttiWeightComputingException e) {
            this.tabInError = 1;
            throw e;
        }
        try {
            computedBenthosBatches = weightComputingService.getComputedBenthosBatches(operationId);
            if (computedBenthosBatches == null) {
                totalBenthosSortedWeight = Float.valueOf(0.0f);
            } else {
                this.benthosBatchRows = new ArrayList<SpeciesBatchRowModel>();
                totalBenthosSortedWeight = this.computeSpeciesBatches(persistenceService, computedSpeciesBatches, this.benthosBatchRows);
            }
        }
        catch (TuttiWeightComputingException e) {
            this.tabInError = 2;
            throw e;
        }
        try {
            computedMarineLitterBatches = weightComputingService.getComputedMarineLitterBatches(operationId, model.getMarineLitterTotalWeight());
        }
        catch (TuttiWeightComputingException e) {
            this.tabInError = 3;
            throw e;
        }
        this.modified = model.isModify();
        this.catchBatch = model.toEntity();
        Float rate = this.getConfig().getDifferenceRateBetweenSortedAndTotalWeights();
        if (model.getSpeciesTotalSortedWeight() != null && model.getSpeciesTotalSortedWeight().floatValue() >= totalSpeciesSortedWeight.floatValue() && model.getSpeciesTotalSortedWeight().floatValue() < (1.0f + rate.floatValue() / 100.0f) * totalSpeciesSortedWeight.floatValue()) {
            ((EditCatchesUI)this.getUI()).getTabPane().setSelectedIndex(1);
            htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.message.species", (Object[])new Object[]{rate}), I18n.t((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.help", (Object[])new Object[0]));
            answer = JOptionPane.showConfirmDialog((Component)this.getContext().getActionUI(), htmlMessage, I18n.t((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.title", (Object[])new Object[0]), 0, 3);
            if (answer == 1) {
                this.catchBatch.setSpeciesTotalSortedWeight(null);
                this.catchBatch.setSpeciesTotalSortedComputedWeight(totalSpeciesSortedWeight);
                this.modified = true;
            }
        }
        if (model.getBenthosTotalSortedWeight() != null && model.getBenthosTotalSortedWeight().floatValue() >= totalBenthosSortedWeight.floatValue() && model.getBenthosTotalSortedWeight().floatValue() < (1.0f + rate.floatValue() / 100.0f) * totalBenthosSortedWeight.floatValue()) {
            ((EditCatchesUI)this.getUI()).getTabPane().setSelectedIndex(2);
            htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.message.benthos", (Object[])new Object[]{rate}), I18n.t((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.help", (Object[])new Object[0]));
            answer = JOptionPane.showConfirmDialog((Component)this.getContext().getActionUI(), htmlMessage, I18n.t((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.title", (Object[])new Object[0]), 0, 3);
            if (answer == 1) {
                this.catchBatch.setBenthosTotalSortedWeight(null);
                this.catchBatch.setBenthosTotalSortedComputedWeight(totalBenthosSortedWeight);
                this.modified = true;
            }
        }
        weightComputingService.computeCatchBatchWeights(this.catchBatch, computedSpeciesBatches, computedBenthosBatches, computedMarineLitterBatches);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.afterAction();
        ((EditCatchesUI)this.getUI()).repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterAction() {
        EditCatchesUIModel editCatchesUIModel = (EditCatchesUIModel)this.getModel();
        editCatchesUIModel.setLoadingData(true);
        SpeciesBatchUI speciesBatchUI = this.getSpeciesBatchUI();
        SpeciesBatchUI benthosBatchesUI = this.getBenthosBatchUI();
        try {
            if (this.speciesBatchRows != null) {
                speciesBatchUI.getModel().setRows(this.speciesBatchRows);
            }
            if (this.benthosBatchRows != null) {
                benthosBatchesUI.getModel().setRows(this.benthosBatchRows);
            }
            if (this.catchBatch != null) {
                editCatchesUIModel.fromEntity(this.catchBatch);
            }
            if (this.modified != null) {
                editCatchesUIModel.setModify(this.modified);
            }
        }
        finally {
            editCatchesUIModel.setLoadingData(false);
        }
        SpeciesBatchUIModel model = speciesBatchUI.getModel();
        SpeciesSortMode sortMode = model.getSpeciesSortMode();
        if (sortMode != SpeciesSortMode.NONE) {
            model.setSpeciesSortMode(SpeciesSortMode.NONE);
            model.setSpeciesSortMode(sortMode);
        }
        if ((sortMode = (model = benthosBatchesUI.getModel()).getSpeciesSortMode()) != SpeciesSortMode.NONE) {
            model.setSpeciesSortMode(SpeciesSortMode.NONE);
            model.setSpeciesSortMode(sortMode);
        }
    }

    public void postFailedAction(Throwable error) {
        this.afterAction();
        if (error instanceof TuttiWeightComputingException) {
            TuttiWeightComputingException e = (TuttiWeightComputingException)error;
            ((EditCatchesUI)this.getUI()).getTabPane().setSelectedIndex(this.tabInError);
            switch (this.tabInError) {
                case 1: {
                    this.treatSpeciesBatchError(e, this.getSpeciesBatchUI().getModel());
                    break;
                }
                case 2: {
                    this.treatSpeciesBatchError(e, this.getBenthosBatchUI().getModel());
                    break;
                }
                case 3: {
                    JTables.doSelectCell((JTable)((EditCatchesUI)this.getUI()).getMarineLitterTabContent().getTable(), (int)e.getIndex(), (int)3);
                }
            }
        }
    }

    protected Float computeSpeciesBatches(PersistenceService persistenceService, BatchContainer<SpeciesBatch> computedSpeciesBatches, List<SpeciesBatchRowModel> speciesBatchRows) {
        Float totalSortedWeight = Float.valueOf(0.0f);
        List<SpeciesBatch> children = computedSpeciesBatches.getChildren();
        for (SpeciesBatch batch : children) {
            SpeciesBatchRowModel row = this.getSpeciesBatchUI().getHandler().loadBatch(batch, null, speciesBatchRows);
            if (!persistenceService.isVracBatch((SpeciesBatch)row)) continue;
            SampleCategory<?> sampleCategory = row.getFirstSampleCategory();
            Float weight = Numbers.getValueOrComputedValue(sampleCategory.getCategoryWeight(), sampleCategory.getComputedWeight());
            totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + weight.floatValue());
        }
        return totalSortedWeight;
    }

    protected void treatSpeciesBatchError(TuttiWeightComputingException e, SpeciesBatchUIModel speciesBatchUIModel) {
        SpeciesBatchRowModel row;
        List rows;
        int index = e.getIndex();
        if (speciesBatchUIModel.getSpeciesSortMode() != SpeciesSortMode.NONE) {
            rows = new ArrayList(speciesBatchUIModel.getRows());
            SpeciesBatchNaturalOrderComparator.sort(rows);
            row = (SpeciesBatchRowModel)rows.get(index);
            index = speciesBatchUIModel.getRows().indexOf(row);
        } else {
            rows = speciesBatchUIModel.getRows();
            row = (SpeciesBatchRowModel)rows.get(index);
        }
        JXTable table = this.getSpeciesBatchUI().getTable();
        SpeciesBatchTableModel tableModel = (SpeciesBatchTableModel)((Object)table.getModel());
        Set<SampleCategoryColumnIdentifier> sampleCols = tableModel.getSampleCols();
        this.selectBatchCell(table, index, row, e.getProperty(), sampleCols, SpeciesBatchTableModel.WEIGHT);
    }

    protected void selectBatchCell(JXTable table, int index, SpeciesBatchRowModel row, String property, Set<SampleCategoryColumnIdentifier> sampleCols, ColumnIdentifier<SpeciesBatchRowModel> weightColumn) {
        TableColumn tableColumn;
        SampleCategoryColumnIdentifier columnIdentifier = weightColumn;
        if ("sampleCategoryWeight".equals(property)) {
            Integer categoryId = row.getFinestCategory().getCategoryId();
            for (SampleCategoryColumnIdentifier sampleCol : sampleCols) {
                if (!categoryId.equals(sampleCol.getSampleCategoryId())) continue;
                columnIdentifier = sampleCol;
                break;
            }
        }
        int column = 0;
        TableColumnExt columnExt = table.getColumnExt(columnIdentifier);
        int modelIndex = columnExt.getModelIndex();
        Iterator iterator = table.getColumns(false).iterator();
        while (iterator.hasNext() && !columnExt.equals(tableColumn = (TableColumn)iterator.next()) && tableColumn.getModelIndex() <= modelIndex) {
            ++column;
        }
        JTables.doSelectCell((JTable)table, (int)index, (int)column);
    }

    private SpeciesBatchUI getBenthosBatchUI() {
        return ((EditCatchesUI)this.getUI()).getBenthosTabPanel().getEditBatchesUI();
    }

    private SpeciesBatchUI getSpeciesBatchUI() {
        return ((EditCatchesUI)this.getUI()).getSpeciesTabPanel().getEditBatchesUI();
    }
}

