/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.util;

import fr.ifremer.tutti.persistence.entities.protocol.Rtp;
import fr.ifremer.tutti.type.WeightUnit;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class Weights {
    private static DecimalFormatSymbols symbols;
    private static DecimalFormat decimalFormat;

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        if (symbols == null) {
            symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            symbols.setGroupingSeparator(' ');
        }
        return symbols;
    }

    public static DecimalFormat getDecimalFormat(int minDecimal, int maxDecimal) {
        if (decimalFormat == null) {
            decimalFormat = new DecimalFormat();
            decimalFormat.setDecimalFormatSymbols(Weights.getDecimalFormatSymbols());
            decimalFormat.setGroupingUsed(false);
        }
        decimalFormat.setMinimumFractionDigits(minDecimal);
        decimalFormat.setMaximumFractionDigits(maxDecimal);
        return decimalFormat;
    }

    public static String getWeightStringValue(Float weight) {
        String textValue;
        if (weight != null) {
            DecimalFormat weightDecimalFormat = Weights.getDecimalFormat(1, 3);
            textValue = weightDecimalFormat.format(weight);
        } else {
            textValue = "";
        }
        return textValue;
    }

    public static int compareWeights(float v0, float v1) {
        v0 = WeightUnit.KG.round(Float.valueOf(v0)).floatValue();
        v1 = WeightUnit.KG.round(Float.valueOf(v1)).floatValue();
        return Weights.compareRawWeights(v0, v1);
    }

    public static int compareRawWeights(float v0, float v1) {
        float delta = v0 - v1;
        int result = (double)delta > 1.0E-5 ? 1 : (delta < -1.0E-4f ? -1 : 0);
        return result;
    }

    public static boolean isSmallerWeight(float v0, float v1) {
        return Weights.compareWeights(v0, v1) < 0;
    }

    public static boolean isGreaterWeight(float v0, float v1) {
        return Weights.compareWeights(v0, v1) > 0;
    }

    public static boolean isEqualWeight(float v0, float v1) {
        return Weights.compareWeights(v0, v1) == 0;
    }

    public static boolean isNotEqualWeight(float v0, float v1) {
        return Weights.compareWeights(v0, v1) != 0;
    }

    public static boolean isNullOrZero(Float weight) {
        return weight == null || Weights.compareRawWeights(weight.floatValue(), 0.0f) == 0;
    }

    public static boolean isNotZero(float weight) {
        return Weights.compareRawWeights(weight, 0.0f) != 0;
    }

    public static boolean isNotNullNorZero(Float number) {
        return number != null && Weights.isNotZero(number.floatValue());
    }

    public static float computeWithRtp(Rtp rtp, float lengthStep, String lengthStepCaracteristicUnit) {
        if ("mm".equals(lengthStepCaracteristicUnit)) {
            lengthStep /= 10.0f;
        }
        float computedWeight = (float)(rtp.getA() * Math.pow(lengthStep, rtp.getB().floatValue()));
        return computedWeight;
    }
}

