/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.DepartmentId;
import fr.ifremer.adagio.core.dao.administration.user.DepartmentImpl;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.administration.user.PersonId;
import fr.ifremer.adagio.core.dao.administration.user.PersonImpl;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperationImpl;
import fr.ifremer.adagio.core.dao.data.sample.Sample;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.Matrix;
import fr.ifremer.adagio.core.dao.referential.pmfm.MatrixId;
import fr.ifremer.adagio.core.dao.referential.pmfm.MatrixImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxonImpl;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.CopyIndividualObservationMode;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatchs;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.AttachmentPersistenceService;
import fr.ifremer.tutti.persistence.service.FishingOperationPersistenceService;
import fr.ifremer.tutti.persistence.service.IndividualObservationBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.CaracteristicPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.SpeciesPersistenceService;
import fr.ifremer.tutti.persistence.service.util.BatchPersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.SamplePersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.SynchronizationStatusHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.type.IntegerType;
import org.springframework.stereotype.Service;

@Service(value="individualObservationBatchPersistenceService")
public class IndividualObservationBatchPersistenceServiceImpl
extends AbstractPersistenceService
implements IndividualObservationBatchPersistenceService {
    private static final Log log = LogFactory.getLog(IndividualObservationBatchPersistenceServiceImpl.class);
    @Resource(name="caracteristicPersistenceService")
    private CaracteristicPersistenceService caracteristicService;
    @Resource(name="speciesPersistenceService")
    private SpeciesPersistenceService speciesService;
    @Resource(name="attachmentPersistenceService")
    protected AttachmentPersistenceService attachmentPersistenceService;
    @Resource(name="samplePersistenceHelper")
    protected SamplePersistenceHelper samplePersistenceHelper;
    @Resource(name="batchPersistenceHelper")
    protected BatchPersistenceHelper batchHelper;
    @Resource(name="synchronizationStatusHelper")
    protected SynchronizationStatusHelper synchronizationStatusHelper;
    @Resource(name="fishingOperationPersistenceService")
    protected FishingOperationPersistenceService fishingOperationPersistenceService;

    @Override
    public List<IndividualObservationBatch> getAllIndividualObservationBatchsForCruise(Integer cruiseId) {
        Preconditions.checkNotNull((Object)cruiseId);
        ArrayList result = new ArrayList();
        List<Integer> allFishingOperationIds = this.fishingOperationPersistenceService.getAllFishingOperationIds(cruiseId);
        allFishingOperationIds.forEach(fishingOperationId -> {
            Iterator<Object[]> list = this.queryList("allFishingOperationSamplesWithBatch", "fishingOperationId", IntegerType.INSTANCE, fishingOperationId);
            List<IndividualObservationBatch> resultForFishingOperation = this.toBeanListWithFishingOperation(list, (Integer)fishingOperationId);
            result.addAll(resultForFishingOperation);
        });
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<IndividualObservationBatch> getAllIndividualObservationBatchsForFishingOperation(Integer fishingOperationId) {
        Preconditions.checkNotNull((Object)fishingOperationId);
        Iterator<Object[]> list = this.queryList("allFishingOperationSamplesWithBatch", "fishingOperationId", IntegerType.INSTANCE, fishingOperationId);
        List<IndividualObservationBatch> result = this.toBeanListWithFishingOperation(list, fishingOperationId);
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<IndividualObservationBatch> getAllIndividualObservationBatchsForBatch(Integer batchId) {
        Preconditions.checkNotNull((Object)batchId);
        Iterator<Object[]> list = this.queryList("allFishingOperationSamplesForBatch", "batchId", IntegerType.INSTANCE, batchId);
        List<IndividualObservationBatch> result = this.toBeanList(list);
        return Collections.unmodifiableList(result);
    }

    @Override
    public Collection<IndividualObservationBatch> createIndividualObservationBatches(Collection<IndividualObservationBatch> individualObservations) {
        Preconditions.checkNotNull(individualObservations);
        List<IndividualObservationBatch> notNullObservations = individualObservations.stream().filter(source -> source.getLengthStepCaracteristic() != null).collect(Collectors.toList());
        ArrayListMultimap individualObservationBatchesByBatchId = ArrayListMultimap.create();
        notNullObservations.forEach(individualObservationBatch -> individualObservationBatchesByBatchId.put((Object)individualObservationBatch.getBatchId(), individualObservationBatch));
        for (Map.Entry entry : individualObservationBatchesByBatchId.asMap().entrySet()) {
            Integer speciesBatchId = (Integer)entry.getKey();
            Collection individualObservationBatches = (Collection)entry.getValue();
            this.createOrSave(speciesBatchId, individualObservationBatches);
        }
        return Collections.unmodifiableList(notNullObservations);
    }

    @Override
    public List<IndividualObservationBatch> saveBatchIndividualObservation(Integer speciesBatchId, List<IndividualObservationBatch> individualObservation) {
        Preconditions.checkNotNull((Object)speciesBatchId);
        Preconditions.checkNotNull(individualObservation);
        List notNullObservations = individualObservation.stream().filter(source -> source.getLengthStepCaracteristic() != null).collect(Collectors.toList());
        this.createOrSave(speciesBatchId, individualObservation);
        return Collections.unmodifiableList(notNullObservations);
    }

    @Override
    public void deleteAllIndividualObservationsForFishingOperation(Integer fishingOperationId) {
        Set<Integer> individualObservationIds = this.getAllIndividualObservationBatchIds(fishingOperationId);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("[Fishing Operation: %d] Delete %d individual observations.", fishingOperationId, individualObservationIds.size()));
        }
        individualObservationIds.forEach(this.samplePersistenceHelper::deleteSample);
    }

    @Override
    public void deleteAllIndividualObservationsForBatch(Integer speciesBatchId) {
        Set<Integer> allSpeciesBatchIds = this.batchHelper.getBatchIds(speciesBatchId);
        for (Integer aSpeciesBatchId : allSpeciesBatchIds) {
            Set<Integer> individualObservationIds = this.getAllIndividualObservationBatchIdsForBatch(aSpeciesBatchId);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("[Species batch: %d] Delete %d individual observations.", aSpeciesBatchId, individualObservationIds.size()));
            }
            individualObservationIds.forEach(this.samplePersistenceHelper::deleteSample);
        }
    }

    protected void beanToEntity(IndividualObservationBatch source, Sample target, Batch batch) {
        fr.ifremer.adagio.core.dao.data.operation.FishingOperation fishingOperation = (fr.ifremer.adagio.core.dao.data.operation.FishingOperation)this.load(FishingOperationImpl.class, source.getFishingOperation().getIdAsInt());
        target.setFishingOperation(fishingOperation);
        target.setBatch(batch);
        target.setFishingOperation(fishingOperation);
        if (TuttiEntities.isNew(source)) {
            String label = batch.getId() + "_" + source.getSpecies().getReferenceTaxonId();
            target.setLabel(label);
            Matrix matrix = (Matrix)this.load(MatrixImpl.class, MatrixId.PRODUCE_BATCH.getValue());
            target.setMatrix(matrix);
            target.setIndividualCount(Short.valueOf((short)1));
            target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)QualityFlagCode.NOTQUALIFIED.getValue())));
            if (target.getSampleDate() == null) {
                target.setSampleDate(fishingOperation.getFishingStartDateTime());
            }
            target.setCreationDate(fishingOperation.getFishingStartDateTime());
            target.setRecorderDepartment((Department)this.load(DepartmentImpl.class, DepartmentId.UNKNOWN_RECORDER_DEPARTMENT.getValue()));
            target.setRecorderPerson((Person)this.load(PersonImpl.class, PersonId.UNKNOWN_RECORDER_PERSON.getValue()));
            Program program = fishingOperation.getFishingTrip().getProgram();
            target.setProgram(program);
        }
        target.setId(source.getIdAsInt());
        target.setComments(source.getComment());
        Species species = source.getSpecies();
        Integer referenceTaxonId = species.getReferenceTaxonId();
        target.setReferenceTaxon((ReferenceTaxon)this.load(ReferenceTaxonImpl.class, referenceTaxonId));
        CaracteristicMap caracteristics = this.samplePersistenceHelper.extractCommonSampleCaracteristics(source);
        CopyIndividualObservationMode copyIndividualObservationMode = source.getCopyIndividualObservationMode();
        Objects.requireNonNull(copyIndividualObservationMode, "Any individual observation requires a copy mode");
        Caracteristic copyIndividualObservationModeCaracteristic = this.caracteristicService.getCopyIndividualObservationModeCaracteristic();
        CaracteristicQualitativeValue qualitativeValue = copyIndividualObservationMode.getQualitativeValue(copyIndividualObservationModeCaracteristic);
        caracteristics.put(copyIndividualObservationModeCaracteristic, qualitativeValue);
        if (StringUtils.isNotBlank((CharSequence)source.getSamplingCode())) {
            Caracteristic sampleCodeCaracteristic = this.caracteristicService.getSampleCodeCaracteristic();
            caracteristics.put(sampleCodeCaracteristic, (Serializable)((Object)source.getSamplingCode()));
        }
        this.samplePersistenceHelper.setSampleMeasurements(target, caracteristics);
    }

    protected IndividualObservationBatch toBean(Object[] source) {
        IndividualObservationBatch batch = IndividualObservationBatchs.newIndividualObservationBatch();
        int colIndex = 0;
        batch.setId((Integer)source[colIndex++]);
        batch.setBatchId((Integer)source[colIndex++]);
        Integer taxonId = (Integer)source[colIndex++];
        Species species = this.speciesService.getSpeciesByReferenceTaxonId(taxonId);
        batch.setSpecies(species);
        batch.setComment((String)source[colIndex]);
        batch.setSynchronizationStatus((String)source[colIndex]);
        batch.setCaracteristics(new CaracteristicMap());
        this.fillSampleMeasurements(batch);
        return batch;
    }

    protected List<IndividualObservationBatch> toBeanList(Iterator<Object[]> list) {
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            IndividualObservationBatch individualObservationBatch = this.toBean(list.next());
            result.add(individualObservationBatch);
        }
        return result;
    }

    protected List<IndividualObservationBatch> toBeanListWithFishingOperation(Iterator<Object[]> list, Integer fishingOperationId) {
        List<IndividualObservationBatch> result = this.toBeanList(list);
        FishingOperation fishingOperation = this.fishingOperationPersistenceService.getFishingOperation(fishingOperationId);
        result.forEach(individualObservationBatch -> individualObservationBatch.setFishingOperation(fishingOperation));
        return result;
    }

    protected Batch getBatch(Integer operationId) {
        Preconditions.checkNotNull((Object)operationId);
        return this.batchHelper.getRootCatchBatchByFishingOperationId(operationId, false);
    }

    protected void fillSampleMeasurements(IndividualObservationBatch batch) {
        this.samplePersistenceHelper.loadSampleMeasurements(batch);
        CaracteristicMap caracteristics = batch.getCaracteristics();
        Caracteristic copyIndividualObservationModeCaracteristic = this.caracteristicService.getCopyIndividualObservationModeCaracteristic();
        CaracteristicQualitativeValue copyIndividualObservationMode = caracteristics.removeQualitativeValue(copyIndividualObservationModeCaracteristic);
        if (copyIndividualObservationMode != null) {
            batch.setCopyIndividualObservationMode(CopyIndividualObservationMode.valueOf(copyIndividualObservationMode.getIdAsInt()));
        } else {
            batch.setCopyIndividualObservationMode(CopyIndividualObservationMode.NOTHING);
        }
        Caracteristic sampleCodeCaracteristic = this.caracteristicService.getSampleCodeCaracteristic();
        String sampleCode = caracteristics.removeStringValue(sampleCodeCaracteristic);
        batch.setSamplingCode(sampleCode);
    }

    protected Set<Integer> getAllIndividualObservationBatchIdsForBatch(Integer batchId) {
        Preconditions.checkNotNull((Object)batchId);
        Iterator<Integer> list = this.queryListTyped("allFishingOperationSampleIdsForBatch", "batchId", IntegerType.INSTANCE, batchId);
        return this.toIds(list);
    }

    protected Set<Integer> getAllIndividualObservationBatchIds(Integer fishingOperationId) {
        Preconditions.checkNotNull((Object)fishingOperationId);
        Iterator<Integer> list = this.queryListTyped("allFishingOperationSampleIds", "fishingOperationId", IntegerType.INSTANCE, fishingOperationId);
        return this.toIds(list);
    }

    protected Set<Integer> toIds(Iterator<Integer> list) {
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        while (list.hasNext()) {
            Integer id = list.next();
            result.add(id);
        }
        return result;
    }

    protected void createOrSave(Integer speciesBatchId, Collection<IndividualObservationBatch> notNullObservations) {
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByBatchId(speciesBatchId);
        if (catchBatch == null) {
            throw new IllegalStateException("Can't find catch batch from batchId: " + speciesBatchId);
        }
        this.synchronizationStatusHelper.setDirty(catchBatch);
        SortingBatch batch = this.batchHelper.getSortingBatchById(catchBatch, speciesBatchId);
        if (batch == null) {
            throw new IllegalStateException("Can't find batch from batchId: " + speciesBatchId);
        }
        Set<Integer> notUpdatedChildIds = this.getAllIndividualObservationBatchIdsForBatch(speciesBatchId);
        for (IndividualObservationBatch source : notNullObservations) {
            Sample target;
            if (TuttiEntities.isNew(source)) {
                target = Sample.Factory.newInstance();
                this.beanToEntity(source, target, (Batch)batch);
                this.samplePersistenceHelper.create(target);
                source.setId(String.valueOf(target.getId()));
                if (log.isInfoEnabled()) {
                    log.info((Object)("Create individual observation (" + source.getRankOrder() + "): " + target.getId()));
                }
            } else {
                target = this.samplePersistenceHelper.load(source.getIdAsInt());
                this.beanToEntity(source, target, (Batch)batch);
                this.samplePersistenceHelper.update(target);
                notUpdatedChildIds.remove(target.getId());
                if (log.isInfoEnabled()) {
                    log.info((Object)("Update individual observation (" + source.getRankOrder() + "): " + target.getId()));
                }
            }
            this.synchronizationStatusHelper.setDirty(source);
        }
        if (CollectionUtils.isNotEmpty(notUpdatedChildIds)) {
            for (Integer observationId : notUpdatedChildIds) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Remove obsolete individual observation: " + observationId));
                }
                this.samplePersistenceHelper.deleteSample(observationId);
            }
        }
    }
}

