/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities;

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;

public class CaracteristicMap
extends LinkedHashMap<Caracteristic, Serializable> {
    private static final long serialVersionUID = 1L;

    public static CaracteristicMap copy(CaracteristicMap map) {
        CaracteristicMap result = new CaracteristicMap();
        if (map != null) {
            result.putAll(map);
        }
        return result;
    }

    public static CaracteristicMap fromCollection(Collection<Caracteristic> caracterstics) {
        CaracteristicMap result = new CaracteristicMap();
        if (caracterstics != null) {
            caracterstics.forEach((? super T caracteristic) -> result.put((Caracteristic)caracteristic, null));
        }
        return result;
    }

    public boolean hasNonNullValues(Collection<Caracteristic> caracteristicsToIgnore) {
        return this.keySet().stream().filter(caracteristic -> caracteristicsToIgnore.contains(caracteristic) && this.get(caracteristic) != null).count() > 0L;
    }

    public CaracteristicQualitativeValue getQualitativeValue(Caracteristic caracteristic) {
        Serializable value = (Serializable)this.get(caracteristic);
        if (value != null && !(value instanceof CaracteristicQualitativeValue)) {
            throw new IllegalArgumentException("caracteristic value for " + caracteristic + " is not qualitative: " + value);
        }
        return (CaracteristicQualitativeValue)value;
    }

    public String getStringValue(Caracteristic caracteristic) {
        Serializable value = (Serializable)this.get(caracteristic);
        if (value != null && !(value instanceof String)) {
            throw new IllegalArgumentException("caracteristic value for " + caracteristic + " is not text: " + value);
        }
        return (String)((Object)value);
    }

    public Float getFloatValue(Caracteristic caracteristic) {
        Serializable value = (Serializable)this.get(caracteristic);
        if (value != null && !(value instanceof Float)) {
            throw new IllegalArgumentException("caracteristic value for " + caracteristic + " is not float: " + value);
        }
        return (Float)value;
    }

    public CaracteristicQualitativeValue removeQualitativeValue(Caracteristic caracteristic) {
        Serializable remove = (Serializable)this.remove(caracteristic);
        if (remove != null && !(remove instanceof CaracteristicQualitativeValue)) {
            throw new IllegalArgumentException("caracteristic value for " + caracteristic + " is not qualitative: " + remove);
        }
        return (CaracteristicQualitativeValue)remove;
    }

    public String removeStringValue(Caracteristic caracteristic) {
        Serializable remove = (Serializable)this.remove(caracteristic);
        if (remove != null && !(remove instanceof String)) {
            throw new IllegalArgumentException("caracteristic value for " + caracteristic + " is not text: " + remove);
        }
        return (String)((Object)remove);
    }

    public Float removeFloatValue(Caracteristic caracteristic) {
        Serializable remove = (Serializable)this.remove(caracteristic);
        if (remove != null && !(remove instanceof Float)) {
            throw new IllegalArgumentException("caracteristic value for " + caracteristic + " is not float: " + remove);
        }
        return (Float)remove;
    }

    @Override
    public Serializable put(Caracteristic key, Serializable value) {
        if (value != null) {
            CaracteristicType caracteristicType = key.getCaracteristicType();
            switch (caracteristicType) {
                case NUMBER: {
                    if (value instanceof Number) break;
                    throw new IllegalArgumentException("caracteristic value for " + key + " is not a number: " + value);
                }
                case QUALITATIVE: {
                    if (value instanceof CaracteristicQualitativeValue) break;
                    throw new IllegalArgumentException("caracteristic value for " + key + " is not qualitative: " + value);
                }
                case TEXT: {
                    if (value instanceof String) break;
                    throw new IllegalArgumentException("caracteristic value for " + key + " is not text: " + value);
                }
            }
        }
        return super.put(key, value);
    }
}

