/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ichtyometer.tool;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.ichtyometer.IchtyometerClient;
import fr.ifremer.tutti.ichtyometer.RemoteDeviceChooser;
import fr.ifremer.tutti.ichtyometer.feed.FeedReader;
import fr.ifremer.tutti.ichtyometer.feed.event.FeedReaderListener;
import java.io.Console;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class FeedReaderTool {
    public static void main(String ... args) throws IOException {
        PrintWriter writer = System.console().writer();
        writer.println("FeedReaderTool: to display record in feed mode v1.0");
        RemoteDeviceChooser remoteDeviceChooser = remoteDeviceNames -> {
            ArrayList remoteDeviceNameList = Lists.newArrayList((Iterable)remoteDeviceNames);
            Console console = System.console();
            writer.println("Choose you device");
            int i = 0;
            for (String remoteDeviceName : remoteDeviceNameList) {
                writer.println(i++ + " for device " + remoteDeviceName);
            }
            writer.println("q (to quit)");
            writer.print("Your choice: ");
            writer.flush();
            String command = console.readLine();
            if ("q".equals(command)) {
                System.exit(0);
            }
            return (String)remoteDeviceNameList.get(Integer.valueOf(command));
        };
        IchtyometerClient client = new IchtyometerClient(2);
        client.open(remoteDeviceChooser, true);
        FeedReader reader = new FeedReader();
        writer.println("client " + client + " is open and listen the board");
        FeedReaderListener listener = event -> writer.println("New record: " + event.getRecord());
        reader.addFeedModeReaderListener(listener);
        reader.start(client);
        while (true) {
            // Infinite loop
        }
    }
}

