/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import java.io.IOException;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.report.engine.toc.ITOCConstants;
import org.eclipse.birt.report.engine.toc.ITOCWriter;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.TOCEntry;
import org.eclipse.birt.report.engine.toc.document.MemTOCWriter;
import org.eclipse.birt.report.engine.toc.document.TOCWriterV3;

public class TOCWriter
implements ITOCWriter,
ITOCConstants {
    private ITOCWriter tocWriter;

    public TOCWriter(IDocArchiveWriter archive) throws IOException {
        this.tocWriter = archive == null ? new MemTOCWriter() : new TOCWriterV3(archive.createOutputStream("/toc"));
    }

    public TOCWriter(RAOutputStream output) throws IOException {
        this.tocWriter = output == null ? new MemTOCWriter() : new TOCWriterV3(output);
    }

    @Override
    public void close() throws IOException {
        if (this.tocWriter != null) {
            this.tocWriter.close();
            this.tocWriter = null;
        }
    }

    @Override
    public void closeTOCEntry(TOCEntry entry) throws IOException {
        if (this.tocWriter != null) {
            this.tocWriter.closeTOCEntry(entry);
        }
    }

    @Override
    public void startTOCEntry(TOCEntry entry) throws IOException {
        if (this.tocWriter != null) {
            this.tocWriter.startTOCEntry(entry);
        }
    }

    @Override
    public ITreeNode getTree() {
        if (this.tocWriter != null) {
            return this.tocWriter.getTree();
        }
        return null;
    }
}

