/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.model.attribute.Insets;

public final class AllAxes
implements IConstants {
    private OneAxis axPrimaryBase = null;
    private OneAxis axPrimaryOrthogonal = null;
    private OneAxis axAncillaryBase = null;
    private boolean bAxesSwapped = false;
    private OneAxis[] oa = null;
    private double dStart = 0.0;
    private double dLength = 0.0;
    private int iOverlayOrientation = 0;
    private Insets insClientArea = null;
    private static final IGObjectFactory goFactory = GObjectFactory.instance();

    AllAxes(Insets _insClientArea) {
        this.insClientArea = _insClientArea;
        if (this.insClientArea == null) {
            this.insClientArea = goFactory.createInsets(0.0, 0.0, 0.0, 0.0);
        }
    }

    final void initOverlays(int _iAxisCount, int _iOverlayOrientation) {
        this.oa = _iAxisCount > 0 ? new OneAxis[_iAxisCount] : null;
        this.iOverlayOrientation = _iOverlayOrientation;
    }

    final void defineAncillaryBase(OneAxis axBase) {
        this.axAncillaryBase = axBase;
    }

    final void definePrimary(OneAxis axPrimary) {
        int iOrientation = axPrimary.getOrientation();
        if (iOrientation == 0) {
            if (this.bAxesSwapped) {
                this.axPrimaryOrthogonal = axPrimary;
            } else {
                this.axPrimaryBase = axPrimary;
            }
        } else if (iOrientation == 1) {
            if (this.bAxesSwapped) {
                this.axPrimaryBase = axPrimary;
            } else {
                this.axPrimaryOrthogonal = axPrimary;
            }
        }
    }

    final void defineOverlay(int iAxisIndex, OneAxis axOverlay) {
        this.oa[iAxisIndex] = axOverlay;
    }

    public final OneAxis getOverlay(int iAxisIndex) {
        return this.oa[iAxisIndex];
    }

    final double getMaxStartShift() {
        double dMaxSS = 0.0;
        int i = 0;
        while (i < this.getOverlayCount()) {
            if (this.oa[i].getScale() != null && this.oa[i].getScale().getStartShift() > dMaxSS) {
                dMaxSS = this.oa[i].getScale().getStartShift();
            }
            ++i;
        }
        return dMaxSS;
    }

    final double getMaxEndShift() {
        double dMaxES = 0.0;
        int i = 0;
        while (i < this.getOverlayCount()) {
            if (this.oa[i].getScale() != null && this.oa[i].getScale().getEndShift() > dMaxES) {
                dMaxES = this.oa[i].getScale().getEndShift();
            }
            ++i;
        }
        return dMaxES;
    }

    public final int getOverlayCount() {
        return this.oa == null ? 0 : this.oa.length;
    }

    final int getOrientation() {
        return this.iOverlayOrientation;
    }

    final void setBlockCordinates(double _dStart, double _dLength) {
        this.dStart = _dStart;
        this.dLength = _dLength;
    }

    final double getStart() {
        return this.dStart;
    }

    final double getLength() {
        return this.dLength;
    }

    public final OneAxis getPrimaryBase() {
        return this.axPrimaryBase;
    }

    public final OneAxis getPrimaryOrthogonal() {
        return this.axPrimaryOrthogonal;
    }

    public final OneAxis getAncillaryBase() {
        return this.axAncillaryBase;
    }

    public boolean areAxesSwapped() {
        return this.bAxesSwapped;
    }

    final void swapAxes(boolean _bAxesSwapped) {
        this.bAxesSwapped = _bAxesSwapped;
        this.iOverlayOrientation = _bAxesSwapped ? 0 : 1;
    }

    final boolean anyOverlayPositionedAt(int iMinOrMax) {
        int iOC = this.getOverlayCount();
        int i = 0;
        while (i < iOC) {
            if (this.getOverlay(i).getIntersectionValue().getType() == iMinOrMax) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final Insets getInsets() {
        return this.insClientArea;
    }
}

