package fr.ifremer.shared.application.swing.util;

/*
 * #%L
 * Ifremer shared :: Application Swing
 * $Id: ApplicationErrorHelper.java 1379 2013-11-24 22:44:33Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/application/tags/ifremer-shared-1.0/application-swing/src/main/java/fr/ifremer/shared/application/swing/util/ApplicationErrorHelper.java $
 * %%
 * Copyright (C) 2013 Ifremer, CodeLutin, Tony CHEMIT
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.shared.application.ApplicationBusinessException;
import fr.ifremer.shared.application.swing.ApplicationUIContext;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;
import org.nuiton.csv.ImportRuntimeException;

import javax.swing.JOptionPane;

import static org.nuiton.i18n.I18n._;

/**
 * Helper to display errors.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ApplicationErrorHelper implements ErrorReporter {

    protected ApplicationUIContext context;

    public ApplicationErrorHelper(ApplicationUIContext context) {
        this.context = context;
    }

    /**
     * Display a user friendly error frame.
     *
     * @param message message for user
     * @param cause   exception cause
     */
    public void showErrorDialog(String message, Throwable cause) {

        if (cause == null) {
            JOptionPane.showMessageDialog(context.getMainUI(), "<html><body>" + message + "</body></html>",
                                          _("application.error.ui.business.error"),
                                          JOptionPane.ERROR_MESSAGE);
        } else if (cause instanceof ApplicationBusinessException) {
            JOptionPane.showMessageDialog(context.getMainUI(), "<html><body>" + cause.getMessage() + "</body></html>",
                                          _("application.error.ui.business.error"),
                                          JOptionPane.ERROR_MESSAGE);
        } else if (cause instanceof ImportRuntimeException) {
            JOptionPane.showMessageDialog(context.getMainUI(), cause.getMessage(),
                                          _("application.error.ui.business.error"),
                                          JOptionPane.ERROR_MESSAGE);
        } else {

            JXErrorPane pane = new JXErrorPane();
            ErrorInfo info = new ErrorInfo(_("application.error.ui.other.error"),
                                           _("application.error.errorpane.htmlmessage", message), null, null,
                                           cause, null, null);
            pane.setErrorInfo(info);
            pane.setErrorReporter(this);
            JXErrorPane.showDialog(context.getActionUI(), pane);
        }

    }

    /**
     * Display a user friendly error frame.
     *
     * @param message message for user
     */
    public void showErrorDialog(String message) {
        showErrorDialog(message, null);
    }

    @Override
    public void reportError(ErrorInfo errorInfo) throws NullPointerException {

        showErrorDialog(errorInfo.getBasicErrorMessage(), errorInfo.getErrorException());
    }

    /**
     * Display a user friendly warning frame.
     *
     * @param message message for user
     */
    public void showWarningDialog(String message) {

        JOptionPane.showMessageDialog(context.getMainUI(), "<html><body>" + message + "</body></html>",
                                      _("application.error.ui.business.warning"),
                                      JOptionPane.WARNING_MESSAGE);

    }

}
