package fr.ifremer.shared.application.swing.table;

/*
 * #%L
 * Ifremer shared :: Application Swing
 * $Id: ColumnIdentifier.java 1379 2013-11-24 22:44:33Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/application/tags/ifremer-shared-1.0/application-swing/src/main/java/fr/ifremer/shared/application/swing/table/ColumnIdentifier.java $
 * %%
 * Copyright (C) 2013 Ifremer, CodeLutin, Tony CHEMIT
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.shared.application.ApplicationDataUtil;

import java.io.Serializable;

/**
 * To represent a column of a table.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ColumnIdentifier<R> implements Serializable {

    private static final long serialVersionUID = 1L;

    private final String propertyName;

    private final String headerI18nKey;

    private final String headerTipI18nKey;

    public static <R> ColumnIdentifier<R> newId(String propertyName,
                                                String headerI18nKey,
                                                String headerTipI18nKey) {
        return new ColumnIdentifier<R>(propertyName,
                                       headerI18nKey,
                                       headerTipI18nKey);
    }

    public static <R> ColumnIdentifier<R> newReadOnlyId(String propertyName,
                                                        String headerI18nKey,
                                                        String headerTipI18nKey) {
        return new ColumnIdentifier<R>(propertyName,
                                       headerI18nKey,
                                       headerTipI18nKey) {

            private static final long serialVersionUID = 1L;

            @Override
            public void setValue(R entry, Object value) {
                // no set
            }
        };
    }

    protected ColumnIdentifier(String propertyName,
                               String headerI18nKey,
                               String headerTipI18nKey) {
        this.propertyName = propertyName;
        this.headerI18nKey = headerI18nKey;
        this.headerTipI18nKey = headerTipI18nKey;
    }

    public String getPropertyName() {
        return propertyName;
    }

    public String getHeaderI18nKey() {
        return headerI18nKey;
    }

    public String getHeaderTipI18nKey() {
        return headerTipI18nKey;
    }

    public Object getValue(R entry) {
        Object result = null;
        if (propertyName != null && entry != null) {
            result = ApplicationDataUtil.getProperty(entry, propertyName);
        }
        return result;
    }

    public void setValue(R entry, Object value) {
        if (propertyName != null) {
            ApplicationDataUtil.setProperty(entry, propertyName, value);
        }
    }

}
