package fr.ifremer.shared.application.swing.tab;

/*
 * #%L
 * Ifremer shared :: Application Swing
 * $Id: TabContainerHandler.java 1387 2013-11-25 16:03:00Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/application/tags/ifremer-shared-1.0/application-swing/src/main/java/fr/ifremer/shared/application/swing/tab/TabContainerHandler.java $
 * %%
 * Copyright (C) 2013 Ifremer, CodeLutin, Tony CHEMIT
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import javax.swing.JTabbedPane;

/**
 * Created on 11/25/13.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 1.0
 */
public interface TabContainerHandler {

    JTabbedPane getTabPanel();

    void init();

    /**
     * Method called when the user selects a tab.
     *
     * @param currentIndex
     * @param newIndex
     * @return <code>false</code> if you want to prevent the tab change,
     * <code>true</code> otherwise
     */
    boolean onTabChanged(int currentIndex, int newIndex);

    /**
     * Returns the tab handler of the tab i.
     *
     * @param index the index of the tab
     * @return the tab handler of the index i if the handler implements
     * the {@link TabHandler} interface,
     * <code>null</code> otherwise
     */
    TabHandler getTabHandler(int index);

    /**
     * Sets a {@link CustomTab} as tab component.
     *
     * @param index
     * @param model
     */
    void setCustomTab(int index, TabContentModel model);
}
