
package fr.ifremer.shared.application.swing.computable;

/*
 * #%L
 * Tutti :: UI
 * $Id: ComputableDataEditorHandler.java 1387 2013-11-25 16:03:00Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/application/tags/ifremer-shared-1.0/application-swing/src/main/java/fr/ifremer/shared/application/swing/computable/ComputableDataEditorHandler.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer, CodeLutin, Tony CHEMIT
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.shared.application.ApplicationDataUtil;
import fr.ifremer.shared.application.swing.ApplicationUI;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.editor.NumberEditorHandler;

import javax.swing.JTextField;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.0
 */
public class ComputableDataEditorHandler extends NumberEditorHandler {

    protected Integer decimalNumber;

    public ComputableDataEditorHandler(ComputableDataEditor ui) {
        super(ui);
    }

    @Override
    public void init() {
        final PropertyChangeListener l = new PropertyChangeListener() {

            public void propertyChange(PropertyChangeEvent evt) {
                setComputedTextIfNullModel();
            }
        };

        ComputableData bean = (ComputableData) editor.getBean();
        if (bean != null) {
            bean.addPropertyChangeListener(l);
        }
        editor.addPropertyChangeListener(ComputableDataEditor.PROPERTY_BEAN, new PropertyChangeListener() {

            public void propertyChange(PropertyChangeEvent evt) {

                ComputableData bean = (ComputableData) evt.getOldValue();
                if (bean != null) {
                    bean.removePropertyChangeListener(ComputableData.PROPERTY_COMPUTED_DATA, l);
                }

                bean = (ComputableData) evt.getNewValue();
                if (bean != null) {
                    bean.addPropertyChangeListener(ComputableData.PROPERTY_COMPUTED_DATA, l);
                }
            }
        });

        editor.addPropertyChangeListener(ComputableDataEditor.PROPERTY_MODEL, l);

        editor.getTextField().addFocusListener(new FocusListener() {

            public void focusGained(FocusEvent e) {
                JTextField tf = editor.getTextField();
                tf.setFont(ApplicationUI.TEXTFIELD_NORMAL_FONT);
                tf.setForeground(Color.BLACK);
                if (editor.getModel() == null) {
                    tf.setText("");
                }
            }

            public void focusLost(FocusEvent e) {
                setComputedTextIfNullModel();
            }
        });

        editor.addPropertyChangeListener(ComputableDataEditor.PROPERTY_DECIMAL_NUMBER,
                                         new PropertyChangeListener() {

                                             public void propertyChange(PropertyChangeEvent evt) {
                                                 decimalNumber = (Integer) evt.getNewValue();
                                             }
                                         });

        decimalNumber = ((ComputableDataEditor) editor).getDecimalNumber();

        super.init();

    }

    protected void setComputedTextIfNullModel() {
        ComputableData bean = (ComputableData) editor.getBean();
        JTextField tf = editor.getTextField();
        if (bean != null && editor.getModel() == null) {
            tf.setFont(ApplicationUI.TEXTFIELD_COMPUTED_FONT);
            tf.setForeground(((ComputableDataEditor) editor).getComputedDataColor());

            String modelText;
            Number computedData = bean.getComputedData();
            if (editor.isUseFloat()
                && decimalNumber != null && computedData != null) {
                DecimalFormat decimalFormat = ApplicationDataUtil.getDecimalFormat(1, decimalNumber);
                modelText = decimalFormat.format(computedData);
            } else {
                modelText = JAXXUtil.getStringValue(computedData);
            }
            tf.setText(modelText);

        } else {
            tf.setFont(ApplicationUI.TEXTFIELD_NORMAL_FONT);
            tf.setForeground(Color.BLACK);
        }
    }

}
