package fr.ifremer.shared.application.swing.computable;

/*
 * #%L
 * Ifremer shared :: Application Swing
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Color;
import java.awt.LayoutManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.editor.NumberEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComputableDataEditor<E extends Number> extends NumberEditor {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_COMPUTED_DATA_COLOR = "computedDataColor";
    public static final String PROPERTY_DECIMAL_NUMBER = "decimalNumber";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Sy0rDQBS9hraKUvEBIojgaz11X1xIq6iUCroRspokYzslmYwzNzbdiJ/gJ+jepTu/w52/IOIPiJOMNr5AQbMK955z7jnDuX6Aslaw3KNpSlQikEeM7G0eHe17PeZjk2lfcYmxAvuNOOC4MBEM5xph1W1l9NorvdaIIxkLJt6x6y0Y1zgIme4yhgiLHxm+1rXD4bqeykS9qQ5Nfad6+fToXATnVw5AKo27iomy9BOrSFJqgcMDhBlz6ZTWQio6xobiomP8VrNZI6Rat2nETuAMRltQkVQZMYSV30fONXJ+KhEm19pJ5DG1FXADWkdoHCvCjxWLmCK6a+QDQqUMuU+Rx4LovrFDfKOfIPVCm8j+NilSKyNlfqCCMCZVLJnCAcJUFoBkoYgNVaBKHqMCYeNPpwu5aYthQTZuxGGsTM78Ou0jyQcFeLRLRRAai7D3D8l3rFghXw2YzyMa2lc23opX2BXIOjlWwcKHlpj+kaJ/RUFGXCirxIwR5t2vlT0wK1vW+U9lzQTz7fPc7N3t/c32W0PhBcfwZ3JxAwAA";
    private static final Log log = LogFactory.getLog(ComputableDataEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Color computedDataColor;
    protected Integer decimalNumber;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ComputableDataEditor<E> $NumberEditor0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(ComputableData<E> bean) {
            super.setBean(bean);
        }
    
        public void setProperty(String property) {
            // cannot change the property
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ComputableDataEditor(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ComputableDataEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public ComputableDataEditor(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ComputableDataEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ComputableDataEditor(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ComputableDataEditor() {
        $initialize();
    }

    public ComputableDataEditor(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public ComputableDataEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public ComputableData<E> getBean() {
        return (ComputableData<E>) super.getBean();
    }

    public Color getComputedDataColor() {
        return computedDataColor;
    }

    public Integer getDecimalNumber() {
        return decimalNumber;
    }

    @Override
    public ComputableDataEditorHandler getHandler() {
        return (ComputableDataEditorHandler) super.getHandler();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setComputedDataColor(Color computedDataColor) {
        Color oldValue = this.computedDataColor;
        this.computedDataColor = computedDataColor;
        firePropertyChange(PROPERTY_COMPUTED_DATA_COLOR, oldValue, computedDataColor);
    }

    public void setDecimalNumber(Integer decimalNumber) {
        Integer oldValue = this.decimalNumber;
        this.decimalNumber = decimalNumber;
        firePropertyChange(PROPERTY_DECIMAL_NUMBER, oldValue, decimalNumber);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createComputedDataColor() {
        $objectMap.put("computedDataColor", computedDataColor = null);
    }

    protected void createDecimalNumber() {
        $objectMap.put("decimalNumber", decimalNumber = null);
    }

    @Override
    protected void createHandler() {
        $objectMap.put("handler", handler = new ComputableDataEditorHandler(this));
    }

    @Override
    protected void createProperty() {
        $objectMap.put("property", property = ComputableData.PROPERTY_DATA);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$NumberEditor0", $NumberEditor0);
        createComputedDataColor();
        createDecimalNumber();
        // inline creation of $NumberEditor0
        setName("$NumberEditor0");
        
        $completeSetup();
    }

}