package fr.ifremer.shared.application.swing.actionng;

/*
 * #%L
 * Ifremer shared :: Application Swing
 * $Id: ApplicationActionEvent.java 1379 2013-11-24 22:44:33Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/application/tags/ifremer-shared-1.0/application-swing/src/main/java/fr/ifremer/shared/application/swing/actionng/ApplicationActionEvent.java $
 * %%
 * Copyright (C) 2013 Ifremer, CodeLutin, Tony CHEMIT
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.EventObject;

/**
 * Events...
 *
 * Created on 11/23/13.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ApplicationActionEvent extends EventObject {

    private static final long serialVersionUID = 1L;

    public enum EventType {
        /**
         * Before starting action.
         */
        INIT,
        /**
         * When action is started.
         */
        START,
        /**
         * When action end with succes.
         */
        DONE,
        /**
         * When action failed.
         */
        FAIL,
        /**
         * When progression changed.
         */
        PROGRESSION_CHANGE
    }

    private Exception error;

    private final EventType eventType;

    /**
     * Constructs a prototypical Event.
     *
     * @param source    The object on which the Event initially occurred.
     * @param eventType The type of event
     * @throws IllegalArgumentException if source is null.
     */
    public ApplicationActionEvent(ApplicationAction source,
                                  EventType eventType) {
        super(source);
        this.eventType = eventType;
    }

    @Override
    public ApplicationAction getSource() {
        return (ApplicationAction) super.getSource();
    }

    public Exception getError() {
        return error;
    }

    public void setError(Exception error) {
        this.error = error;
    }

    public EventType getEventType() {
        return eventType;
    }
}
