package fr.ifremer.shared.application.swing.action;

/*
 * #%L
 * Ifremer shared :: Application Swing
 * $Id: ApplicationActionUIModel.java 1379 2013-11-24 22:44:33Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/application/tags/ifremer-shared-1.0/application-swing/src/main/java/fr/ifremer/shared/application/swing/action/ApplicationActionUIModel.java $
 * %%
 * Copyright (C) 2013 Ifremer, CodeLutin, Tony CHEMIT
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.shared.application.type.ApplicationProgressionModel;
import org.jdesktop.beans.AbstractSerializableBean;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ApplicationActionUIModel extends AbstractSerializableBean {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_ACTION = "action";

    public static final String PROPERTY_PROGRESSION_MODEL = "progressionModel";

    protected AbstractApplicationAction action;

    protected ApplicationProgressionModel progressionModel;

    public ApplicationProgressionModel getProgressionModel() {
        return progressionModel;
    }

    public void setProgressionModel(ApplicationProgressionModel progressionModel) {
        Object oldValue = getProgressionModel();
        this.progressionModel = progressionModel;
        firePropertyChange(PROPERTY_PROGRESSION_MODEL, oldValue, progressionModel);
    }

    public AbstractApplicationAction getAction() {
        return action;
    }

    public void setAction(AbstractApplicationAction action) {
        Preconditions.checkNotNull(action, "action can not be null");
        Object oldValue = getAction();
        this.action = action;
        firePropertyChange(PROPERTY_ACTION, oldValue, action);
    }

    public void clear() {
        setProgressionModel(null);

        Object oldValue = getAction();
        action = null;
        firePropertyChange(PROPERTY_ACTION, oldValue, null);
    }
}
