package fr.ifremer.shared.application.swing.action;

/*
 * #%L
 * Ifremer shared :: Application Swing
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.shared.application.swing.ApplicationUI;
import fr.ifremer.shared.application.swing.ApplicationUIContext;
import fr.ifremer.shared.application.swing.util.ApplicationUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.BlockingLayerUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplicationActionUI extends JDialog implements ApplicationUI<ApplicationActionUIModel, ApplicationActionUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAMVWzW8bRRQfu7FT24Tmo41aNUEucHCkas0BeknVNnEbkciFilCpwpfOeifeacc7w8xss1bUCv4DLnCGO5dKvfVUcei5By6IfwEhDlwRb2bXXn9siKlViJzR+n383nu/ee+tf/wNFZRElx7gKHJkGGjaJc7e1r17n7oPSFvfJKotqdBcovgvl0f5Fqp4A7nS6L1W07jXE/d6g3cFD0gw5L3ZRGWle4wonxCt0fqoR1up+v5AvRmJUPZRB0lloX7/x+/5b7yvfsgjFAnIrgylVE/ySiuZa6I89TRahkiPcJ3hoANpSBp0IN8FI2swrNQnuEu+RE/QfBMVBZYAptG705dsMax/JDQqvb93k2LGOx9odO1AOvRAki6RjvIB2XOwEIy2saY8cNQhZOLgtv2ylSq2rOTurhAWtqjRohuq3jbj7YdN3CPy7i4kOEJDDGUt4CExSv0LXe4RplFjtoRuG5QUtSQ513dwYJCXDZtRgrBnhcaqNDCudBh3MRtozppjeaBeitVxpCZ2JzGt0FifG3e6I3lHEqW2sdTo/GgiqWrUtaSxenhcMmeMcigVI75gjvVRkzH0tcREoosjlwPd76Tdn7ZnroUKMgQxZN2aHJjPQBWPyvmxUTGAVvvX6srPz399ttOfjyWIfS7TdGi8oW+F5IJITU3oM/FwhJqy+m0sNluopAiD3WBnfy0jsf1EDclBvCXj7hh352OsfIAozP/y4qfV+69OofwOKjOOvR1s7HeBdR/48jnzInH9hs3orcPTcC7C/ymNFtykgxuccbhM58jHgcegWztEN3igSaRrG/EXMBjp99rGY2h0C6BR8UjLkIBgPlRktw2eqHCAmSIR0LmWQeegJrf08s+V/ac3+pTmoMQLx5qntBa+QEUaMBoQu3SSfZK5ZCpCkdDj6d7I2iQoY+pFMns1e16eYDAHhbtcenC16NJRQA6rn1PNiLdtZbVavPs2qkHI2MbjKDQoH9oazdMVNDql/ybauo12qyt0Lwn20eVq8smONDnwU8RboIFHNJFdGmANozRnbvkf0IcG9CT0PPTKI6qoy0i/V2ZmM10yr1Fbv18nYcd3z5u9qPFl+H8QuUiDAy679mX0H/TmcLhpa54zu8mwFWpN++9QDquoHD/HS6gyhJwV+TRPqJ6mQJ/Qjg8xl6/Gi6eKNTDphppcm8DOmbM8Bar5qYDtG+/r1wephNDLbS6hkb0ZoQqH8AvOnxGkyHCPw8Wgt696WOOqC7MGLXcMTSsnIhrxt+b4LhthdWaEdwDhbypYCNu8CwAA";
    private static final Log log = LogFactory.getLog(ApplicationActionUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected BlockingLayerUI busyBlockLayerUI;
    protected JLabel globalActionLabel;
    protected JPanel globalPanel;
    protected JProgressBar globalProgressBar;
    protected final ApplicationActionUIHandler handler = new ApplicationActionUIHandler();
    protected ApplicationActionUIModel model;
    protected JPanel rootPanel;
    protected JLabel taskActionLabel;
    protected JPanel taskPanel;
    protected JProgressBar taskProgressBar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ApplicationActionUI $JDialog0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
        public void open(AbstractApplicationAction action) {
          getModel().setAction(action);
        }
    
        public void close() {
          getModel().clear();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ApplicationActionUI(JFrame frame, ApplicationUIContext context) {
        super(frame, true);
                ApplicationUIUtil.setApplicationContext(this, context);
            $initialize();
    }

    public ApplicationActionUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI() {
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Window param0) {
        super(param0);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public BlockingLayerUI getBusyBlockLayerUI() {
        return busyBlockLayerUI;
    }

    public JLabel getGlobalActionLabel() {
        return globalActionLabel;
    }

    public JPanel getGlobalPanel() {
        return globalPanel;
    }

    public JProgressBar getGlobalProgressBar() {
        return globalProgressBar;
    }

    public ApplicationActionUIHandler getHandler() {
        return handler;
    }

    public ApplicationActionUIModel getModel() {
        return model;
    }

    public JPanel getRootPanel() {
        return rootPanel;
    }

    public JLabel getTaskActionLabel() {
        return taskActionLabel;
    }

    public JPanel getTaskPanel() {
        return taskPanel;
    }

    public JProgressBar getTaskProgressBar() {
        return taskProgressBar;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToGlobalPanel() {
        if (!allComponentsCreated) {
            return;
        }
        globalPanel.add(globalActionLabel, BorderLayout.CENTER);
        globalPanel.add(globalProgressBar, BorderLayout.SOUTH);
    }

    protected void addChildrenToRootPanel() {
        if (!allComponentsCreated) {
            return;
        }
        rootPanel.add(globalPanel, BorderLayout.NORTH);
        rootPanel.add(taskPanel, BorderLayout.CENTER);
    }

    protected void addChildrenToTaskPanel() {
        if (!allComponentsCreated) {
            return;
        }
        taskPanel.add(taskActionLabel, BorderLayout.CENTER);
        taskPanel.add(taskProgressBar, BorderLayout.SOUTH);
    }

    protected void createBusyBlockLayerUI() {
        $objectMap.put("busyBlockLayerUI", busyBlockLayerUI = new BlockingLayerUI());
        
        busyBlockLayerUI.setUseIcon(false);
    }

    protected void createGlobalActionLabel() {
        $objectMap.put("globalActionLabel", globalActionLabel = new JLabel());
        
        globalActionLabel.setName("globalActionLabel");
    }

    protected void createGlobalPanel() {
        $objectMap.put("globalPanel", globalPanel = new JPanel());
        
        globalPanel.setName("globalPanel");
        globalPanel.setLayout(new BorderLayout());
    }

    protected void createGlobalProgressBar() {
        $objectMap.put("globalProgressBar", globalProgressBar = new JProgressBar());
        
        globalProgressBar.setName("globalProgressBar");
        globalProgressBar.setIndeterminate(true);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ApplicationActionUIModel.class));
    }

    protected void createRootPanel() {
        $objectMap.put("rootPanel", rootPanel = new JPanel());
        
        rootPanel.setName("rootPanel");
        rootPanel.setLayout(new BorderLayout());
    }

    protected void createTaskActionLabel() {
        $objectMap.put("taskActionLabel", taskActionLabel = new JLabel());
        
        taskActionLabel.setName("taskActionLabel");
    }

    protected void createTaskPanel() {
        $objectMap.put("taskPanel", taskPanel = new JPanel());
        
        taskPanel.setName("taskPanel");
        taskPanel.setLayout(new BorderLayout());
        taskPanel.setVisible(false);
    }

    protected void createTaskProgressBar() {
        $objectMap.put("taskProgressBar", taskProgressBar = new JProgressBar());
        
        taskProgressBar.setName("taskProgressBar");
        taskProgressBar.setIndeterminate(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add(SwingUtil.boxComponentWithJxLayer(rootPanel), BorderLayout.CENTER);
        addChildrenToRootPanel();
        addChildrenToGlobalPanel();
        addChildrenToTaskPanel();
        
        // apply 9 property setters
        busyBlockLayerUI.setBlockingColor(handler.getContext().getColorBlockingLayer());
        busyBlockLayerUI.setBlock(true);
        globalPanel.setBorder(new TitledBorder((String) null));
        globalActionLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        taskPanel.setBorder(new TitledBorder((String) null));
        taskActionLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$JDialog0", $JDialog0);
        createBusyBlockLayerUI();
        createModel();
        createRootPanel();
        createGlobalPanel();
        createGlobalActionLabel();
        createGlobalProgressBar();
        createTaskPanel();
        createTaskActionLabel();
        createTaskProgressBar();
        // inline creation of $JDialog0
        setName("$JDialog0");
        SwingUtil.setComponentHeight($JDialog0,200);
        setModal(true);
        setUndecorated(true);
        SwingUtil.setComponentWidth($JDialog0,300);
        
        $completeSetup();
        handler.afterInit(this);
    }

}