package fr.ifremer.shared.application.swing.action;

/*
 * #%L
 * Ifremer shared :: Application Swing
 * $Id: ApplicationActionFactory.java 1379 2013-11-24 22:44:33Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/application/tags/ifremer-shared-1.0/application-swing/src/main/java/fr/ifremer/shared/application/swing/action/ApplicationActionFactory.java $
 * %%
 * Copyright (C) 2013 Ifremer, CodeLutin, Tony CHEMIT
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.shared.application.ApplicationTechnicalException;
import fr.ifremer.shared.application.swing.AbstractApplicationUIHandler;
import org.apache.commons.lang3.reflect.ConstructorUtils;

import javax.swing.AbstractButton;
import javax.swing.Action;

import static org.nuiton.i18n.I18n._;

/**
 * Factory of actions.
 * <p/>
 * Created on 11/24/13.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ApplicationActionFactory {

    public <A extends AbstractApplicationAction> ApplicationUIAction<A> createUIAction(AbstractApplicationUIHandler handler,
                                                                                       Class<A> actionName) {
        return createUIAction(handler, null, actionName);
    }


    public <A extends AbstractApplicationAction> ApplicationUIAction<A> createUIAction(AbstractApplicationUIHandler handler,
                                                                                       AbstractButton abstractButton,
                                                                                       Class<A> actionName) {
        try {

            // create logic action
            A logicAction = createLogicAction(handler, actionName);

            // create ui action
            ApplicationUIAction<A> result = createUIAction(abstractButton, logicAction);
            return result;
        } catch (Exception e) {
            throw new ApplicationTechnicalException(_("application.action.create.error", actionName), e);
        }

    }

    public <A extends AbstractApplicationAction> ApplicationUIAction<A> createUIAction(AbstractButton abstractButton,
                                                                                       A logicAction) {

        // create ui action
        ApplicationUIAction<A> result = new ApplicationUIAction<A>(abstractButton,
                                                                   logicAction);
        return result;


    }

    public <A extends AbstractApplicationAction> A createLogicAction(AbstractApplicationUIHandler handler,
                                                                     Class<A> actionName) {
        try {

            // create action
            A result = ConstructorUtils.invokeConstructor(actionName, handler);
            return result;
        } catch (Exception e) {
            throw new ApplicationTechnicalException(_("application.action.create.error", actionName), e);
        }
    }

    public <A extends AbstractApplicationAction> A getLogicAction(AbstractButton b) {
        Action action = b.getAction();
        Preconditions.checkNotNull(action);
        Preconditions.checkState(action instanceof ApplicationUIAction);
        return ((ApplicationUIAction<A>) action).getLogicAction();
    }
}
