package fr.ifremer.shared.application.swing;

/*
 * #%L
 * Ifremer shared :: Application Swing
 * $Id: ApplicationUIContext.java 1379 2013-11-24 22:44:33Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/application/tags/ifremer-shared-1.0/application-swing/src/main/java/fr/ifremer/shared/application/swing/ApplicationUIContext.java $
 * %%
 * Copyright (C) 2013 Ifremer, CodeLutin, Tony CHEMIT
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.shared.application.ApplicationContext;
import fr.ifremer.shared.application.swing.action.ApplicationActionEngine;
import fr.ifremer.shared.application.swing.action.ApplicationActionFactory;
import fr.ifremer.shared.application.swing.action.ApplicationActionUI;
import fr.ifremer.shared.application.swing.util.ApplicationErrorHelper;

import java.awt.Color;
import java.awt.Component;

/**
 * Created on 11/24/13.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 1.0
 */
public interface ApplicationUIContext extends ApplicationContext {

    /**
     * @return the main ui of the application.
     */
    Component getMainUI();

    /**
     * @return the ui used to display long action.
     */
    ApplicationActionUI getActionUI();

    Component getBodyUI();

    Component getStatusUI();

    boolean isBusy();

    void setBusy(boolean busy);

    boolean isHideBody();

    void setHideBody(boolean b);

    Color getColorBlockingLayer();

    ApplicationActionFactory getActionFactory();

    ApplicationActionEngine getActionEngine();

    ApplicationErrorHelper getErrorHelper();

    String getI18nPrefix();

    String getDateFormat();
}
