/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.shared.application.swing.action;

import fr.ifremer.shared.application.swing.AbstractApplicationUIHandler;
import fr.ifremer.shared.application.swing.action.AbstractApplicationAction;
import fr.ifremer.shared.application.swing.action.ApplicationActionException;
import fr.ifremer.shared.application.swing.action.ApplicationActionFactory;
import fr.ifremer.shared.application.swing.action.ApplicationUIAction;
import javax.swing.AbstractButton;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplicationActionEngine {
    private static final Log log = LogFactory.getLog(ApplicationActionEngine.class);
    private final ApplicationActionFactory actionFactory;

    public ApplicationActionEngine(ApplicationActionFactory actionFactory) {
        this.actionFactory = actionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A extends AbstractApplicationAction> void runInternalAction(A action) {
        Throwable error = null;
        try {
            action.doAction();
            action.postSuccessAction();
        }
        catch (Throwable e) {
            error = e;
            if (log.isErrorEnabled()) {
                log.error((Object)"Error in action:", e);
            }
            throw ApplicationActionException.propagateError(action, e);
        }
        finally {
            try {
                if (error != null) {
                    action.postFailedAction(error);
                }
            }
            finally {
                action.releaseAction();
            }
        }
    }

    public <A extends AbstractApplicationAction> void runInternalAction(AbstractApplicationUIHandler handler, Class<A> actionName) {
        A action = this.actionFactory.createLogicAction(handler, actionName);
        this.runInternalAction(action);
    }

    public <A extends AbstractApplicationAction> void runAction(A action) {
        ApplicationUIAction<A> uiAction = this.actionFactory.createUIAction(null, action);
        uiAction.actionPerformed(null);
    }

    public void runAction(AbstractButton button) {
        button.getAction().actionPerformed(null);
    }

    public <A extends AbstractApplicationAction> void runActionAndWait(A action) {
        ApplicationUIAction<A> uiAction = this.actionFactory.createUIAction(null, action);
        uiAction.launchActionAndWait();
    }

    public <A extends AbstractApplicationAction> void runActionAndWait(AbstractApplicationUIHandler handler, Class<A> actionName) {
        A logicAction = this.actionFactory.createLogicAction(handler, actionName);
        this.runActionAndWait(logicAction);
    }
}

