/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.option;

import fr.ifremer.coser.CoserConfig;
import fr.ifremer.coser.CoserConstants;
import fr.ifremer.coser.data.Catch;
import fr.ifremer.coser.ui.common.CommonHandler;
import fr.ifremer.coser.ui.option.ValidatorDialog;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Resource;

public class OptionHandler
extends CommonHandler {
    private static final Log log = LogFactory.getLog(OptionHandler.class);

    public void restoreDefaults(ValidatorDialog view) {
        block3: {
            int answer = JOptionPane.showConfirmDialog(view, I18n.t((String)"coser.ui.validators.confirmRestore", (Object[])new Object[0]), I18n.t((String)"coser.ui.validators.title", (Object[])new Object[0]), 0, 3);
            if (answer == 0) {
                CoserConfig config = view.getContextValue(CoserConfig.class);
                File validatorsDir = config.getValidatorsDirectory();
                try {
                    FileUtils.deleteDirectory((File)validatorsDir);
                    view.dispose();
                }
                catch (IOException ex) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"Can't delete directory", (Throwable)ex);
                }
            }
        }
    }

    public void copyDefaultValidators(ValidatorDialog view) {
        block6: {
            int answer = JOptionPane.showConfirmDialog(view, I18n.t((String)"coser.ui.validators.confirmCopyToDisk", (Object[])new Object[0]), I18n.t((String)"coser.ui.validators.title", (Object[])new Object[0]), 0, 2);
            if (answer != 0) {
                view.dispose();
                return;
            }
            CoserConfig config = view.getContextValue(CoserConfig.class);
            File validatorsDir = config.getValidatorsDirectory();
            validatorsDir.mkdirs();
            try {
                List resources = Resource.getResources((String)"validators/fr/ifremer/coser/data/.*\\.xml", (ClassLoader)Thread.currentThread().getContextClassLoader());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("XML resources found : " + resources.size() + " files"));
                }
                for (URL resource : resources) {
                    String path = resource.getPath();
                    String lastPath = path.substring(path.indexOf("/validators/") + "/validators/".length());
                    String folderPath = lastPath.substring(0, lastPath.lastIndexOf(47));
                    String name = lastPath.substring(lastPath.lastIndexOf(47) + 1);
                    File validatorDirectory = new File(validatorsDir, folderPath);
                    validatorDirectory.mkdirs();
                    File validatorFile = new File(validatorDirectory, name);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Coping resources " + resource + " to " + validatorFile.getAbsolutePath()));
                    }
                    FileUtils.copyURLToFile((URL)resource, (File)validatorFile);
                }
            }
            catch (IOException ex) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Can't copy validators to file system", (Throwable)ex);
            }
        }
        view.dispose();
        ValidatorDialog newView = new ValidatorDialog((JAXXContext)view);
        newView.setHandler(this);
        newView.setLocationRelativeTo(view);
        newView.setVisible(true);
    }

    protected File getValidatorFile(ValidatorDialog view) {
        File validatorFile = null;
        TreePath selectedPath = view.getValidatorsTree().getSelectionPath();
        if (selectedPath != null) {
            Object[] path = selectedPath.getPath();
            CoserConfig config = view.getContextValue(CoserConfig.class);
            File validatorsDir = config.getValidatorsDirectory();
            if (path.length == 3) {
                CoserConstants.Category category = (CoserConstants.Category)path[1];
                CoserConstants.ValidationLevel level = (CoserConstants.ValidationLevel)path[2];
                String sPackage = Catch.class.getPackage().getName();
                String validatorResource = sPackage.replace('.', '/') + "/";
                validatorResource = validatorResource + StringUtils.capitalize((String)category.toString().toLowerCase());
                validatorResource = validatorResource + "-" + level.getXWorkContext() + "-validation.xml";
                validatorFile = new File(validatorsDir, validatorResource);
            }
        }
        return validatorFile;
    }

    public void selectValidator(ValidatorDialog view) {
        File validatorFile;
        view.getCreateNewButton().setEnabled(false);
        view.getDeleteButton().setEnabled(false);
        view.getSaveButton().setEnabled(false);
        TreePath selectedPath = view.getValidatorsTree().getSelectionPath();
        if (selectedPath != null && (validatorFile = this.getValidatorFile(view)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Looking for validator : " + validatorFile.getAbsoluteFile()));
            }
            if (validatorFile.isFile()) {
                view.getValidationEditor().open(validatorFile);
                view.getDeleteButton().setEnabled(true);
                view.getSaveButton().setEnabled(true);
            } else {
                view.getValidationEditor().close();
                view.getCreateNewButton().setEnabled(true);
            }
            view.getValidationEditor().validate();
            view.getValidationEditor().repaint();
        }
    }

    public void saveValidator(ValidatorDialog view) {
        view.getValidationEditor().save();
    }

    public void createNew(ValidatorDialog view) {
        block2: {
            File validatorFile = this.getValidatorFile(view);
            try {
                FileUtils.writeStringToFile((File)validatorFile, (String)"");
            }
            catch (IOException ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't copy validators to file system", (Throwable)ex);
            }
        }
        this.selectValidator(view);
    }

    public void deleteValidator(ValidatorDialog view) {
        File validatorFile = this.getValidatorFile(view);
        validatorFile.delete();
        this.selectValidator(view);
    }
}

