/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class ComponentTitledBorder
implements Border,
MouseListener,
SwingConstants {
    protected int offset = 5;
    protected Component titleComponent;
    protected JComponent container;
    protected Rectangle rect;
    protected Border border;

    public ComponentTitledBorder(Component titleComponent, JComponent container, Border border) {
        this.titleComponent = titleComponent;
        this.container = container;
        this.border = border;
        container.addMouseListener(this);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Insets borderInsets = this.border.getBorderInsets(c);
        Insets insets = this.getBorderInsets(c);
        int temp = (insets.top - borderInsets.top) / 2;
        this.border.paintBorder(c, g, x, y + temp, width, height - temp);
        Dimension size = this.titleComponent.getPreferredSize();
        this.rect = new Rectangle(this.offset, 0, size.width, size.height);
        SwingUtilities.paintComponent(g, this.titleComponent, (Container)c, this.rect);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Dimension size = this.titleComponent.getPreferredSize();
        Insets insets = this.border.getBorderInsets(c);
        insets.top = Math.max(insets.top, size.height);
        return insets;
    }

    private void dispatchEvent(MouseEvent me) {
        if (this.rect != null && this.rect.contains(me.getX(), me.getY())) {
            Point pt = me.getPoint();
            pt.translate(-this.offset, 0);
            this.titleComponent.setBounds(this.rect);
            this.titleComponent.dispatchEvent(new MouseEvent(this.titleComponent, me.getID(), me.getWhen(), me.getModifiers(), pt.x, pt.y, me.getClickCount(), me.isPopupTrigger(), me.getButton()));
            if (!this.titleComponent.isValid()) {
                this.container.repaint();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.dispatchEvent(me);
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.dispatchEvent(me);
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.dispatchEvent(me);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.dispatchEvent(me);
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.dispatchEvent(me);
    }
}

